% this script was used to generate Figure 4C in Mashour et al.Recovery of
% consciousness and cognition after general anesthesia in humans, 2021
% 
% the subfunction cal_LZC.m is required, but not provided here because 
% it was adapted from a LZC script kindly provided by Giulio Tononi and 
% Melanie Boly, University of Wisconsin-Madison for use in a prior 
% publication (Hudetz et al, Neuroscience Letters 628:132-135, 2016)
% 
% Duan LI, 2/3/2021
clear
path(path,'.\EEG data')
path(path,'..\my tools\LZC')
dataname={'UM_1';'UM_4';'UM_7';'UM_8';'UM_9';'UM_12';'UM_13';'UM_14';'UM_18';'UM_21';...
    'WU_33';'WU_34';'WU_36';'WU_38';'WU_40';'WU_42';'WU_45';'WU_46';'WU_48';'WU_49';...
    'UP_62';'UP_64';'UP_67';'UP_68';'UP_69';'UP_71';'UP_74';'UP_76';'UP_77';'UP_80'};
stage_label={'EC1','LOR','Maintenance','Emergence','EC2', 'EC3', 'EC4', 'EC5', 'EC6', 'EC7'};
Nstage=length(stage_label);
nchannels=21;
fs=250;
band=[0.5,30]; 
[b,a]=butter(4, [band(1)/(fs/2) band(2)/(fs/2)]);
epoch=4*fs;
Nsurro=50;
for pp=1:length(dataname)
    load(['anesthesia_',dataname{pp}]);
    for ss=1:Nstage
        x=eeg{ss};
        if ~isempty(x)
            x=filtfilt(b,a,x')';    
            mx=mean(x,1);
            for cc=1:nchannels
                x(cc,:)=x(cc,:)-mx;
                sig(cc,:)=abs(hilbert(x(cc,:)));
            end
            
            Nseg=fix(length(sig)/epoch);
            for j=1:Nseg
                temp=sig(:,(j-1)*epoch+1:j*epoch);   
                Thr=mean(temp,2);
                for cc=1:nchannels                    
                    s{j}(cc,:)=double(temp(cc,:)>Thr(cc));
                end
                
                % surrogate data
                for cc=1:nchannels
                    for nn=1:Nsurro
                        s_shuffle{j}{nn}(cc,:)=s{j}(cc,randperm(epoch));
                    end
                end
                clear temp 
            end
            
            parfor j=1:Nseg
                c(j)=cal_LZC(s{j});                
            end
            
            for j=1:Nseg
                for nn=1:Nsurro
                    temp_s_shuffle{nn}=s_shuffle{j}{nn};
                end
                parfor nn=1:Nsurro
                    temp_c_shuffle(nn)=cal_LZC(temp_s_shuffle{nn});
                end
                c_shuffle(j)=mean(temp_c_shuffle);
                clear temp_s_shift temp_c_shuffle
            end            
            LZC(pp,ss)=median(c./c_shuffle);    
            clear s s_shuffle sig c c_shuffle
        else 
            LZC(pp,ss)=nan;
        end        
    end
end
fig1 = figure('Position',[100 100 400 300]);set(gcf,'Renderer','zbuffer','color','w');
boxplot(LZC),ylabel('LZC'),xlim([0,Nstage+1]),ylim([0,1]),