(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     71928,       1770]
NotebookOptionsPosition[     66445,       1682]
NotebookOutlinePosition[     67075,       1706]
CellTagsIndexPosition[     67032,       1703]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["Definitions:",
 FontSize->18,
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{{3.757866419769853*^9, 3.757866429883844*^9}, {
  3.757866539881407*^9, 
  3.757866556279653*^9}},ExpressionUUID->"33242e41-eaef-4afa-abee-\
85854b3f510d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"$Assumptions", "=", 
  RowBox[{
   RowBox[{"w12", " ", "\[GreaterEqual]", "0"}], " ", "&&", " ", 
   RowBox[{"w13", " ", "\[GreaterEqual]", " ", "0"}], "&&", " ", 
   RowBox[{"w16", "\[GreaterEqual]", "0"}], " ", "&&", 
   RowBox[{"w24", "\[GreaterEqual]", "0"}], "&&", 
   RowBox[{"w25", "\[GreaterEqual]", "0"}], "&&", 
   RowBox[{"w36", "\[GreaterEqual]", "0"}], "&&", 
   RowBox[{"w45", "\[GreaterEqual]", "0"}], "&&", 
   RowBox[{"u", ">", "0"}], "&&", 
   RowBox[{"v", ">", "0"}], "&&", " ", 
   RowBox[{"w21", " ", "\[GreaterEqual]", "0"}], " ", "&&", " ", 
   RowBox[{"w31", " ", "\[GreaterEqual]", " ", "0"}], "&&", " ", 
   RowBox[{"w61", "\[GreaterEqual]", "0"}], " ", "&&", 
   RowBox[{"w42", "\[GreaterEqual]", "0"}], "&&", 
   RowBox[{"w52", "\[GreaterEqual]", "0"}], "&&", 
   RowBox[{"w63", "\[GreaterEqual]", "0"}], "&&", 
   RowBox[{"w54", "\[GreaterEqual]", "0"}], "&&", 
   RowBox[{"K34", ">", "0"}], "&&", 
   RowBox[{"K56", ">", "0"}], " ", "&&", 
   RowBox[{"K31", ">", "0"}], "&&", 
   RowBox[{"K51", ">", "0"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"w", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "w12", ",", "w13", ",", "0", ",", "0", ",", "w16"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w21", ",", "0", ",", "0", ",", "w24", ",", "w25", ",", "0"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w31", ",", "0", ",", "0", ",", "u", ",", "0", ",", "w36"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "w42", ",", 
      RowBox[{"u", "/", "K34"}], ",", "0", ",", "w45", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "w52", ",", "0", ",", "w54", ",", "0", ",", "v"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w61", ",", "0", ",", "w63", ",", "0", ",", 
      RowBox[{"v", "/", "K56"}], ",", "0"}], "}"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.7578640737068644`*^9, 3.7578641068236217`*^9}, 
   3.75786433686945*^9, {3.7578643800365143`*^9, 3.757864424421989*^9}, {
   3.757864591350319*^9, 3.757864592699066*^9}, {3.757864745827207*^9, 
   3.757864815802745*^9}, {3.757865006989094*^9, 3.7578650558822813`*^9}, {
   3.757865087709326*^9, 3.757865138999055*^9}, {3.757865179613442*^9, 
   3.7578653813784018`*^9}, 3.757865420807917*^9, {3.7578655042395563`*^9, 
   3.757865661967009*^9}, {3.757866212911834*^9, 3.757866217929141*^9}, {
   3.757866390171444*^9, 3.757866400498374*^9}, 3.7578667547910633`*^9, {
   3.75787389441011*^9, 3.757873967398306*^9}, {3.75787406472425*^9, 
   3.7578740671314583`*^9}, {3.7578926536048717`*^9, 3.757892658858676*^9}, {
   3.757892697886558*^9, 3.7578927020369263`*^9}, {3.796673432826639*^9, 
   3.796673518649343*^9}},ExpressionUUID->"1f6cecbc-3da7-49ee-8e54-\
1cd16abd6c6c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"w12", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w13", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w16", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w24", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w25", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w36", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w45", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"u", ">", "0"}], "&&", 
  RowBox[{"v", ">", "0"}], "&&", 
  RowBox[{"w21", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w31", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w61", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w42", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w52", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w63", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"w54", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"K34", ">", "0"}], "&&", 
  RowBox[{"K56", ">", "0"}], "&&", 
  RowBox[{"K31", ">", "0"}], "&&", 
  RowBox[{"K51", ">", "0"}]}]], "Output",
 CellChangeTimes->{
  3.757866755846133*^9, {3.7578739696159267`*^9, 3.757873988560342*^9}, 
   3.757874068006054*^9, 3.757875529251904*^9, {3.757888586786528*^9, 
   3.757888590945759*^9}, 3.757889079685034*^9, 3.757889114772211*^9, 
   3.757889164921619*^9, 3.757892660411228*^9, 3.757892702620775*^9, 
   3.757893884191332*^9, 3.7579624048970137`*^9, 3.7582251608663187`*^9, 
   3.758228204998062*^9, 3.758462249907015*^9, 3.758463301459647*^9, 
   3.796673522271891*^9, 3.796675390871789*^9, 3.796729196445484*^9, {
   3.796732620668469*^9, 3.796732629154333*^9}, 3.7967326726777353`*^9, {
   3.796732912876248*^9, 3.7967329189742403`*^9}, {3.7967367344214277`*^9, 
   3.796736749400298*^9}, 3.79673690747668*^9, 
   3.7967422647820063`*^9},ExpressionUUID->"a0a6b9da-7fc1-424b-8b0f-\
a853f3526dca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "w12", ",", "w13", ",", "0", ",", "0", ",", "w16"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w21", ",", "0", ",", "0", ",", "w24", ",", "w25", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w31", ",", "0", ",", "0", ",", "u", ",", "0", ",", "w36"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "w42", ",", 
     FractionBox["u", "K34"], ",", "0", ",", "w45", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "w52", ",", "0", ",", "w54", ",", "0", ",", "v"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w61", ",", "0", ",", "w63", ",", "0", ",", 
     FractionBox["v", "K56"], ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.757866755846133*^9, {3.7578739696159267`*^9, 3.757873988560342*^9}, 
   3.757874068006054*^9, 3.757875529251904*^9, {3.757888586786528*^9, 
   3.757888590945759*^9}, 3.757889079685034*^9, 3.757889114772211*^9, 
   3.757889164921619*^9, 3.757892660411228*^9, 3.757892702620775*^9, 
   3.757893884191332*^9, 3.7579624048970137`*^9, 3.7582251608663187`*^9, 
   3.758228204998062*^9, 3.758462249907015*^9, 3.758463301459647*^9, 
   3.796673522271891*^9, 3.796675390871789*^9, 3.796729196445484*^9, {
   3.796732620668469*^9, 3.796732629154333*^9}, 3.7967326726777353`*^9, {
   3.796732912876248*^9, 3.7967329189742403`*^9}, {3.7967367344214277`*^9, 
   3.796736749400298*^9}, 3.79673690747668*^9, 
   3.7967422647908363`*^9},ExpressionUUID->"d9f44235-d126-4834-82b5-\
568fb0d3b26f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "w", "]"}]], "Input",
 NumberMarks->False,ExpressionUUID->"771914ae-a2f0-4fba-92f8-f014b348771d"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "w12", "w13", "0", "0", "w16"},
     {"w21", "0", "0", "w24", "w25", "0"},
     {"w31", "0", "0", "u", "0", "w36"},
     {"0", "w42", 
      FractionBox["u", "K34"], "0", "w45", "0"},
     {"0", "w52", "0", "w54", "0", "v"},
     {"w61", "0", "w63", "0", 
      FractionBox["v", "K56"], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.796673551886324*^9, 3.796675393188532*^9, 
  3.796729196534813*^9, 3.796732924693372*^9, 3.7967367345473127`*^9, 
  3.796736910342188*^9, 
  3.796742264965863*^9},ExpressionUUID->"037c0afc-79ac-4fa3-a66e-\
889ad83c4914"]
}, Open  ]],

Cell[TextData[StyleBox["Sum of rows",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{{3.7578665837644033`*^9, 3.75786659006361*^9}, 
   3.796736913111174*^9},ExpressionUUID->"54fd5c5c-473c-4ca0-88ca-\
8beec54c6de7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"w", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "All"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "6"}], "}"}]}], "]"}]}], " "}], "\[IndentingNewLine]", 
 RowBox[{"d34", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "*", 
       RowBox[{"d", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"w", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "4"}], "]"}], "]"}], "*", 
       RowBox[{"w", "[", 
        RowBox[{"[", 
         RowBox[{"4", ",", "3"}], "]"}], "]"}]}]}], "]"}], ",", "u"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"d56", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "[", 
        RowBox[{"[", "5", "]"}], "]"}], "*", 
       RowBox[{"d", "[", 
        RowBox[{"[", "6", "]"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"w", "[", 
        RowBox[{"[", 
         RowBox[{"5", ",", "6"}], "]"}], "]"}], "*", 
       RowBox[{"w", "[", 
        RowBox[{"[", 
         RowBox[{"6", ",", "5"}], "]"}], "]"}]}]}], "]"}], ",", "v"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.7578662398902617`*^9, 3.757866241036922*^9}, {
  3.7578663818463163`*^9, 3.757866382452352*^9}, {3.757873992880022*^9, 
  3.757873992969701*^9}, {3.757893901051364*^9, 3.75789390151268*^9}, {
  3.796673568992834*^9, 
  3.796673590671473*^9}},ExpressionUUID->"4b5d8b6d-bd1f-4f99-82f9-\
63c63bf97ef4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"w12", "+", "w13", "+", "w16"}], ",", 
   RowBox[{"w21", "+", "w24", "+", "w25"}], ",", 
   RowBox[{"u", "+", "w31", "+", "w36"}], ",", 
   RowBox[{
    FractionBox["u", "K34"], "+", "w42", "+", "w45"}], ",", 
   RowBox[{"v", "+", "w52", "+", "w54"}], ",", 
   RowBox[{
    FractionBox["v", "K56"], "+", "w61", "+", "w63"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.757873983415999*^9, 3.7578739933599854`*^9}, 
   3.757874072869402*^9, 3.757875532020122*^9, 3.757888594519198*^9, {
   3.757893887872134*^9, 3.757893902464671*^9}, 3.757962406919533*^9, 
   3.758225165452821*^9, 3.75822820693567*^9, 3.758462253074389*^9, 
   3.758463305020707*^9, 3.7966735920827427`*^9, 3.796675395265336*^9, 
   3.796729196607943*^9, 3.796732934127742*^9, 3.796736734641301*^9, 
   3.796736916048522*^9, 
   3.7967422650860853`*^9},ExpressionUUID->"db80c5b4-bf7d-4b80-87c6-\
5793c8018655"],

Cell[BoxData[
 RowBox[{
  RowBox[{"w31", " ", "w42"}], "+", 
  RowBox[{"w36", " ", "w42"}], "+", 
  RowBox[{"w31", " ", "w45"}], "+", 
  RowBox[{"w36", " ", "w45"}], "+", 
  RowBox[{"u", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["w31", "K34"], "+", 
     FractionBox["w36", "K34"], "+", "w42", "+", "w45"}], ")"}]}]}]], "Output",\

 CellChangeTimes->{{3.757873983415999*^9, 3.7578739933599854`*^9}, 
   3.757874072869402*^9, 3.757875532020122*^9, 3.757888594519198*^9, {
   3.757893887872134*^9, 3.757893902464671*^9}, 3.757962406919533*^9, 
   3.758225165452821*^9, 3.75822820693567*^9, 3.758462253074389*^9, 
   3.758463305020707*^9, 3.7966735920827427`*^9, 3.796675395265336*^9, 
   3.796729196607943*^9, 3.796732934127742*^9, 3.796736734641301*^9, 
   3.796736916048522*^9, 
   3.7967422651003847`*^9},ExpressionUUID->"334e3e48-96ca-4bd9-9534-\
b89251a05427"],

Cell[BoxData[
 RowBox[{
  RowBox[{"w52", " ", "w61"}], "+", 
  RowBox[{"w54", " ", "w61"}], "+", 
  RowBox[{"w52", " ", "w63"}], "+", 
  RowBox[{"w54", " ", "w63"}], "+", 
  RowBox[{"v", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["w52", "K56"], "+", 
     FractionBox["w54", "K56"], "+", "w61", "+", "w63"}], ")"}]}]}]], "Output",\

 CellChangeTimes->{{3.757873983415999*^9, 3.7578739933599854`*^9}, 
   3.757874072869402*^9, 3.757875532020122*^9, 3.757888594519198*^9, {
   3.757893887872134*^9, 3.757893902464671*^9}, 3.757962406919533*^9, 
   3.758225165452821*^9, 3.75822820693567*^9, 3.758462253074389*^9, 
   3.758463305020707*^9, 3.7966735920827427`*^9, 3.796675395265336*^9, 
   3.796729196607943*^9, 3.796732934127742*^9, 3.796736734641301*^9, 
   3.796736916048522*^9, 
   3.796742265107107*^9},ExpressionUUID->"22068d60-2890-4b8b-993d-\
88fd2f49ce9d"]
}, Open  ]],

Cell[TextData[StyleBox["Effective reaction rates after elimination of \
metabolites 5 and 6 (useful for easy differentiation w.r.to u), and the final \
effective reaction rate y of module \[Mu] ",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{{3.757866622645009*^9, 3.757866643243532*^9}, {
  3.796724910949114*^9, 3.796724943931587*^9}, {3.796725526706009*^9, 
  3.796725544075322*^9}},ExpressionUUID->"c0691444-39e0-4983-a403-\
2c7560025637"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"W", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "+", 
      RowBox[{
       FractionBox["1", "d56"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"d", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "6"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"6", ",", "j"}], "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"d", "[", 
           RowBox[{"[", "6", "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "5"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "j"}], "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "5"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "6"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"6", ",", "j"}], "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "6"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"6", ",", "5"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "j"}], "]"}], "]"}]}]}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W", "=", 
   RowBox[{
    RowBox[{"UpperTriangularize", "[", 
     RowBox[{"W", ",", "1"}], "]"}], "+", 
    RowBox[{"LowerTriangularize", "[", 
     RowBox[{"W", ",", 
      RowBox[{"-", "1"}]}], "]"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ynum56", " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "3"}], "]"}], "]"}], "*", 
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"3", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"Total", "[", 
      RowBox[{"W", "[", 
       RowBox[{"[", 
        RowBox[{"4", ",", "All"}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "4"}], "]"}], "]"}], "*", 
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"Total", "[", 
      RowBox[{"W", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "All"}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "3"}], "]"}], "]"}], "*", 
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"3", ",", "4"}], "]"}], "]"}], "*", 
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "2"}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "4"}], "]"}], "]"}], "*", 
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "3"}], "]"}], "]"}], "*", 
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"3", ",", "2"}], "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ydenom56", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"W", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "All"}], "]"}], "]"}], "]"}], "*", 
     RowBox[{"Total", "[", 
      RowBox[{"W", "[", 
       RowBox[{"[", 
        RowBox[{"4", ",", "All"}], "]"}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"3", ",", "4"}], "]"}], "]"}], "*", 
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "3"}], "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y", " ", "=", 
   RowBox[{
    RowBox[{"W", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}], "+", 
    FractionBox["ynum56", "ydenom56"]}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.757866520685495*^9, {3.757866664225192*^9, 3.757866772913937*^9}, {
   3.757869200434733*^9, 3.757869242678001*^9}, {3.757869643039909*^9, 
   3.7578697605256433`*^9}, 3.757869817093449*^9, {3.7578699373805323`*^9, 
   3.757870031318475*^9}, {3.757870087536159*^9, 3.7578701115667543`*^9}, {
   3.75787015997643*^9, 3.757870181047797*^9}, {3.757870219850829*^9, 
   3.7578702221907473`*^9}, {3.757872564498163*^9, 3.757872564935676*^9}, {
   3.757873281104019*^9, 3.757873284680966*^9}, {3.757888989182119*^9, 
   3.757888992414845*^9}, 3.757889486564674*^9, {3.757889678494197*^9, 
   3.7578897083510637`*^9}, 3.75788974024714*^9, {3.757890054601429*^9, 
   3.757890064442737*^9}, {3.7578928139451303`*^9, 3.757892814865963*^9}, {
   3.758462265467361*^9, 3.7584622693137093`*^9}, {3.7584623028284273`*^9, 
   3.7584625220501347`*^9}, {3.7584625777503242`*^9, 3.758462699511437*^9}, {
   3.7584635842630444`*^9, 3.758463899502667*^9}, {3.758463945461275*^9, 
   3.758463947766179*^9}, {3.7584640049962254`*^9, 3.758464066422921*^9}, {
   3.7584641777098923`*^9, 3.758464259127385*^9}, {3.758464292406054*^9, 
   3.7584643117235003`*^9}, 3.758464345169108*^9, {3.758464393556987*^9, 
   3.7584644293888683`*^9}, {3.758464469135721*^9, 3.758464474827338*^9}, {
   3.758464511842195*^9, 3.7584645139214277`*^9}, {3.758464554480876*^9, 
   3.758464758174623*^9}, {3.796673684732191*^9, 3.7966737784676657`*^9}, {
   3.796673880441184*^9, 3.7966739122808657`*^9}, {3.796675359693244*^9, 
   3.796675359911601*^9}, {3.7967422377980127`*^9, 
   3.796742254348752*^9}},ExpressionUUID->"e8d2c3bc-3434-4aad-bb1a-\
aba32b92be0d"],

Cell[TextData[StyleBox["Effective reaction rates after elimination of \
metabolites 3 and 4 (useful for easy differentiation w.r.to v)",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{{3.757866622645009*^9, 3.757866643243532*^9}, {
  3.7578752680477858`*^9, 3.75787527020652*^9}, {3.796724961546277*^9, 
  3.7967249642519197`*^9}, {3.7967255504879704`*^9, 
  3.796725552983984*^9}},ExpressionUUID->"ac233889-be97-49db-ba47-\
b1a48ea3aae3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"V", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "+", 
      RowBox[{
       FractionBox["1", "d34"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"d", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "4"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "j"}], "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"d", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "3"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "j"}], "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "3"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "4"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "j"}], "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "4"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "3"}], "]"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "j"}], "]"}], "]"}]}]}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "6"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V", "=", 
   RowBox[{
    RowBox[{"UpperTriangularize", "[", 
     RowBox[{"V", ",", "1"}], "]"}], "+", 
    RowBox[{"LowerTriangularize", "[", 
     RowBox[{"V", ",", 
      RowBox[{"-", "1"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"V", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "3"}], "]"}], "]"}], " ", "=", " ", "0"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "All"}], "]"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"V", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "4"}], "]"}], "]"}], " ", "=", " ", "0"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{"[", 
     RowBox[{"4", ",", "All"}], "]"}], "]"}], " ", "=", " ", "0"}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.757866520685495*^9, {3.757866664225192*^9, 3.757866772913937*^9}, {
   3.757869200434733*^9, 3.757869242678001*^9}, {3.757869643039909*^9, 
   3.7578697605256433`*^9}, 3.757869817093449*^9, {3.7578699373805323`*^9, 
   3.757870031318475*^9}, {3.757870087536159*^9, 3.7578701115667543`*^9}, {
   3.75787015997643*^9, 3.757870181047797*^9}, {3.757870219850829*^9, 
   3.7578702221907473`*^9}, {3.757872564498163*^9, 3.757872564935676*^9}, {
   3.757873281104019*^9, 3.757873284680966*^9}, {3.7578752734248953`*^9, 
   3.757875281434554*^9}, {3.757875326615891*^9, 3.757875367802462*^9}, {
   3.7578756029214487`*^9, 3.757875615735219*^9}, {3.757888976784546*^9, 
   3.757888981666916*^9}, {3.757889014787773*^9, 3.757889044183607*^9}, {
   3.75788918790576*^9, 3.7578892287208843`*^9}, {3.7578896693354397`*^9, 
   3.7578896697187223`*^9}, {3.757889737682996*^9, 3.757889748459111*^9}, {
   3.757890016801235*^9, 3.757890033920884*^9}, {3.7578928275240707`*^9, 
   3.757892828198344*^9}, {3.75846362921541*^9, 3.758463629247758*^9}, {
   3.796673830137718*^9, 3.7966738640048943`*^9}, {3.7966739264917994`*^9, 
   3.796673939911104*^9}, {3.796742223895211*^9, 
   3.7967422243970623`*^9}},ExpressionUUID->"d9854dab-86be-4f3a-8631-\
8e08c1912f32"],

Cell[TextData[StyleBox["Sanity check  that the denominator obtained after \
elimination of 5,6 first and 3,4 second is the same as the one  obtained \
after elimination of 3,4 first and 5,6 second are the same (multiplied by d34 \
and d56, respectively, which makes them polynomial).",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{
  3.796736672135301*^9},ExpressionUUID->"0152dfff-8a81-4921-b832-\
b0d2cc3e91b4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dyduDenom", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"W", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "All"}], "]"}], "]"}], "]"}], "*", 
     RowBox[{"Total", "[", 
      RowBox[{"W", "[", 
       RowBox[{"[", 
        RowBox[{"4", ",", "All"}], "]"}], "]"}], "]"}]}], " ", "-", 
    RowBox[{
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"3", ",", "4"}], "]"}], "]"}], "*", 
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "3"}], "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dydvDenom", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"V", "[", 
       RowBox[{"[", 
        RowBox[{"5", ",", "All"}], "]"}], "]"}], "]"}], "*", 
     RowBox[{"Total", "[", 
      RowBox[{"V", "[", 
       RowBox[{"[", 
        RowBox[{"6", ",", "All"}], "]"}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"V", "[", 
      RowBox[{"[", 
       RowBox[{"5", ",", "6"}], "]"}], "]"}], "*", 
     RowBox[{"V", "[", 
      RowBox[{"[", 
       RowBox[{"6", ",", "5"}], "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"dydvDenom", "*", "d34"}], "]"}], " ", "\[Equal]", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{"dyduDenom", "*", "d56"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.796736699234206*^9, 
  3.796736721198477*^9}},ExpressionUUID->"fe94f78a-aa49-4ea0-957e-\
c8fac3bc7367"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.7967367232701674`*^9, 3.796736735004403*^9}, 
   3.796736926682343*^9, 
   3.7967422653353357`*^9},ExpressionUUID->"f45ed0ca-19a0-423e-9899-\
21742d319f2f"]
}, Open  ]],

Cell[TextData[StyleBox["Defining numerators and denominators for the \
derivatives w.r.t to u and v",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{{3.757889757334949*^9, 3.757889852184719*^9}, {
  3.757892908703841*^9, 3.757892960600169*^9}, {3.796673969798321*^9, 
  3.796673971295491*^9}, {3.7967254609115257`*^9, 3.796725495081321*^9}, {
  3.7967255821794558`*^9, 3.796725621702217*^9}, {3.796736669631781*^9, 
  3.79673667037006*^9}},ExpressionUUID->"68d5f8f9-37be-4a8a-9397-\
02e2cedf7155"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dyduNum", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"3", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "2"}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"3", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"W", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "1"}], "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dydvNum", " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"V", "[", 
      RowBox[{"[", 
       RowBox[{"5", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"V", "[", 
      RowBox[{"[", 
       RowBox[{"6", ",", "1"}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"V", "[", 
      RowBox[{"[", 
       RowBox[{"5", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"V", "[", 
      RowBox[{"[", 
       RowBox[{"6", ",", "2"}], "]"}], "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.757889833978816*^9, 3.757889865359106*^9}, {
  3.757890020703779*^9, 3.757890075772456*^9}, {3.757892822380138*^9, 
  3.757892877360911*^9}, {3.757892962715588*^9, 3.7578929632556343`*^9}, {
  3.758227969589806*^9, 3.7582279827968283`*^9}, {3.758463619649866*^9, 
  3.758463629210981*^9}, {3.758464124013509*^9, 3.758464164068219*^9}, {
  3.79667398937429*^9, 3.79667403063211*^9}, {3.79667406246566*^9, 
  3.796674078573349*^9}, {3.796736696745625*^9, 
  3.796736718106641*^9}},ExpressionUUID->"8cb8505b-533c-4e6a-94b6-\
e7bcade9b087"],

Cell[TextData[StyleBox["Derivatives of y w.r.to u and v",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{{3.757892397371285*^9, 3.7578924167087603`*^9}, 
   3.757892901706254*^9, {3.7966740507152557`*^9, 
   3.796674051974078*^9}},ExpressionUUID->"6698ac70-ce98-4fb6-a730-\
f3c988667f3b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dydu", " ", "=", " ", 
   RowBox[{
    FractionBox["1", "K31"], "*", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["dyduNum", "dyduDenom"], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dydv", " ", "=", 
   RowBox[{
    FractionBox["1", "K51"], "*", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["dydvNum", "dydvDenom"], ")"}], "2"]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.757892417616699*^9, 3.757892429747757*^9}, {
  3.7578925039212437`*^9, 3.75789276453189*^9}, {3.7578928387501802`*^9, 
  3.7578928514303637`*^9}, {3.7578928853927927`*^9, 3.757892897092843*^9}, {
  3.758227985845985*^9, 3.75822798820856*^9}, {3.758462712301942*^9, 
  3.758462781614318*^9}, {3.758462826863164*^9, 3.758462828776031*^9}, {
  3.758462891146799*^9, 3.758462962304111*^9}, {3.758463013436281*^9, 
  3.758463059911654*^9}, {3.75846311525283*^9, 3.758463115926177*^9}, {
  3.75846412402094*^9, 3.758464164071437*^9}, {3.796674085573926*^9, 
  3.796674110881988*^9}},ExpressionUUID->"18ead6a9-13e4-45a3-8709-\
3f3fab505b18"],

Cell[TextData[StyleBox["Collecting coefficients in the numerators and \
denominators of the dydu derivative:",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{{3.757874434001349*^9, 3.7578744866063957`*^9}, {
  3.757893000977973*^9, 3.757893014466124*^9}, {3.757893378557786*^9, 
  3.757893384901849*^9}, {3.796674333774246*^9, 
  3.796674334161914*^9}},ExpressionUUID->"635e7e81-1fae-48a8-81bb-\
bcb393bace10"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"dyduNumCoefList", "=", 
  RowBox[{"Map", "[", 
   RowBox[{"Simplify", ",", 
    RowBox[{"CoefficientList", "[", 
     RowBox[{
      RowBox[{"dyduNum", "*", "d56"}], ",", "v"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"dyduDenomCoefList", "=", 
  RowBox[{"Map", "[", 
   RowBox[{"Simplify", ",", 
    RowBox[{"CoefficientList", "[", 
     RowBox[{
      RowBox[{"dyduDenom", "*", "d56"}], ",", "v"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]", " ", "=", " ", 
   RowBox[{
    RowBox[{"w42", "*", "w52"}], "+", 
    RowBox[{"w54", "*", "w42"}], "+", 
    RowBox[{"w45", "*", "w52"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Phi]", "=", 
   RowBox[{
    RowBox[{"w31", "*", "w61"}], " ", "+", " ", 
    RowBox[{"w63", "*", "w31"}], "+", 
    RowBox[{"w36", "*", "w61"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"au", " ", "=", " ", 
   RowBox[{
    RowBox[{"\[Psi]", "*", 
     RowBox[{"w31", "/", "K56"}]}], "+", 
    RowBox[{"w42", "*", " ", "\[Phi]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bu", " ", "=", 
   RowBox[{"\[Psi]", "*", "\[Phi]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eu", "=", 
   RowBox[{
    RowBox[{"u", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"w31", "*", "w52"}], "+", 
           RowBox[{"w31", "*", "w54"}], "+", 
           RowBox[{"w36", "*", "w52"}]}], ")"}], "/", "K34"}], "/", "K56"}], 
       "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"w42", "*", "w61"}], "+", 
         RowBox[{"w42", "*", "w63"}], "+", 
         RowBox[{"w45", "*", "w61"}]}], ")"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"d", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "*", "\[Phi]"}], "+", 
    RowBox[{
     RowBox[{"d", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "*", 
     RowBox[{"\[Psi]", "/", "K56"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fu", "=", 
  RowBox[{
   RowBox[{"u", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"w52", "+", "w54"}], ")"}], "/", "K34"}], "*", "\[Phi]"}], 
      "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"w61", "+", "w63"}], ")"}], "*", "\[Psi]"}]}], ")"}]}], "+", 
   RowBox[{"\[Phi]", "*", "\[Psi]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"dyduNumCoefList", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{"Expand", "[", "bu", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"dyduNumCoefList", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{"Expand", "[", "au", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"dyduDenomCoefList", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{"Expand", "[", " ", "fu", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"dyduDenomCoefList", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{"Expand", "[", " ", "eu", "]"}]}]}], "Input",
 CellChangeTimes->{{3.7578725042610407`*^9, 3.757872549050375*^9}, {
   3.757872590485196*^9, 3.7578726037383423`*^9}, {3.7578727070047703`*^9, 
   3.757872743533073*^9}, 3.757872945069707*^9, {3.7578730042705507`*^9, 
   3.7578730113783493`*^9}, {3.757873076078985*^9, 3.757873151613388*^9}, {
   3.757873300949143*^9, 3.757873303592484*^9}, {3.757873413000524*^9, 
   3.757873414901417*^9}, {3.757873475473592*^9, 3.7578735039244223`*^9}, {
   3.757874168057021*^9, 3.757874170240202*^9}, {3.757874311025302*^9, 
   3.757874316829794*^9}, {3.75787578023619*^9, 3.75787578032548*^9}, {
   3.7578930536070232`*^9, 3.7578931418185883`*^9}, {3.757893193086137*^9, 
   3.757893220423924*^9}, {3.757893268294685*^9, 3.7578933339724283`*^9}, {
   3.757893440300558*^9, 3.757893463136539*^9}, {3.757962371433316*^9, 
   3.757962397900291*^9}, 3.7579624310663*^9, {3.757962519921978*^9, 
   3.7579625241742277`*^9}, {3.757962578726603*^9, 3.757962588717061*^9}, {
   3.758227996275036*^9, 3.758228019506868*^9}, {3.758229929618147*^9, 
   3.758229935917745*^9}, {3.758230197225013*^9, 3.758230242428195*^9}, {
   3.758230339495264*^9, 3.758230348190921*^9}, {3.758230423343684*^9, 
   3.758230512568228*^9}, {3.758230603348168*^9, 3.7582306790151253`*^9}, {
   3.75823072163264*^9, 3.7582307223842897`*^9}, {3.7582308278243723`*^9, 
   3.7582308284736967`*^9}, {3.7582349847425117`*^9, 3.758235095117612*^9}, {
   3.758235139432358*^9, 3.7582353598236437`*^9}, {3.758235412036964*^9, 
   3.758235417103046*^9}, {3.758235556016905*^9, 3.758235756912835*^9}, {
   3.758464124028944*^9, 3.758464143017631*^9}, {3.758464851452178*^9, 
   3.758464866908513*^9}, {3.758464909898753*^9, 3.758464910446516*^9}, {
   3.7584649665145597`*^9, 3.758464983970827*^9}, {3.7584650857373877`*^9, 
   3.758465193726672*^9}, {3.7966741218316383`*^9, 3.796674255807179*^9}, {
   3.7966742961489677`*^9, 
   3.796674339800083*^9}},ExpressionUUID->"1a6e7a5e-e771-4551-9647-\
f0d1f0364c94"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"w45", " ", "w52"}], "+", 
      RowBox[{"w42", " ", 
       RowBox[{"(", 
        RowBox[{"w52", "+", "w54"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"w36", " ", "w61"}], "+", 
      RowBox[{"w31", " ", 
       RowBox[{"(", 
        RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "K56"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"w31", " ", "w45", " ", "w52"}], "+", 
      RowBox[{"K56", " ", "w36", " ", "w42", " ", "w61"}], "+", 
      RowBox[{"w31", " ", "w42", " ", 
       RowBox[{"(", 
        RowBox[{"w52", "+", "w54", "+", 
         RowBox[{"K56", " ", 
          RowBox[{"(", 
           RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.7582302313702993`*^9, 3.758230243059205*^9}, {
   3.758230341323646*^9, 3.758230348793394*^9}, 3.7582305167347393`*^9, {
   3.758230667368095*^9, 3.75823067952877*^9}, 3.7582307229992228`*^9, 
   3.758230846386991*^9, 3.7582350308102303`*^9, {3.758235096165251*^9, 
   3.758235108349214*^9}, {3.758235140480421*^9, 3.7582351690850563`*^9}, 
   3.758235199648768*^9, {3.758235306765503*^9, 3.758235361333737*^9}, 
   3.758235418761107*^9, 3.758235557338386*^9, {3.758235592575573*^9, 
   3.758235614198547*^9}, {3.758235730584587*^9, 3.758235757802148*^9}, 
   3.758463316903202*^9, 3.758464770515912*^9, {3.758464861714429*^9, 
   3.758464868043001*^9}, 3.758464989878517*^9, 3.758465035869739*^9, 
   3.7584651945611687`*^9, 3.796674256595995*^9, {3.796674301188517*^9, 
   3.796674344766362*^9}, {3.796675379843728*^9, 3.796675404947117*^9}, 
   3.796729197371552*^9, 3.796732599198082*^9, {3.7967329491014557`*^9, 
   3.796732953088006*^9}, 3.796736735126375*^9, 3.79673786656246*^9, 
   3.796742265512457*^9},ExpressionUUID->"da10335e-8cc3-4c32-869c-\
23af69561a31"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"w45", " ", "w52"}], "+", 
       RowBox[{"w42", " ", 
        RowBox[{"(", 
         RowBox[{"w52", "+", "w54"}], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"w36", " ", "w61"}], "+", 
       RowBox[{"w31", " ", 
        RowBox[{"(", 
         RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "K34"], 
     RowBox[{"u", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"w36", " ", 
         RowBox[{"(", 
          RowBox[{"w52", "+", "w54"}], ")"}], " ", "w61"}], "+", 
        RowBox[{"w31", " ", 
         RowBox[{"(", 
          RowBox[{"w52", "+", "w54"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"w61", "+", "w63"}], ")"}]}], "+", 
        RowBox[{"K34", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"w45", " ", "w52"}], "+", 
           RowBox[{"w42", " ", 
            RowBox[{"(", 
             RowBox[{"w52", "+", "w54"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"K34", " ", "K56"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"w36", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", 
            RowBox[{"K56", " ", "w61"}]}], ")"}]}], "+", 
         RowBox[{"K34", " ", "w45", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", 
            RowBox[{"K56", " ", "w61"}]}], ")"}]}], "+", 
         RowBox[{"w31", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", "w54", "+", 
            RowBox[{"K56", " ", 
             RowBox[{"(", 
              RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"K34", " ", "w42", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", "w54", "+", 
            RowBox[{"K56", " ", 
             RowBox[{"(", 
              RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"K34", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"w36", " ", "w45", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", 
            RowBox[{"K56", " ", "w61"}]}], ")"}]}], "+", 
         RowBox[{"w36", " ", "w42", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", "w54", "+", 
            RowBox[{"K56", " ", "w61"}]}], ")"}]}], "+", 
         RowBox[{"w31", " ", "w45", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", 
            RowBox[{"K56", " ", 
             RowBox[{"(", 
              RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"w31", " ", "w42", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", "w54", "+", 
            RowBox[{"K56", " ", 
             RowBox[{"(", 
              RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7582302313702993`*^9, 3.758230243059205*^9}, {
   3.758230341323646*^9, 3.758230348793394*^9}, 3.7582305167347393`*^9, {
   3.758230667368095*^9, 3.75823067952877*^9}, 3.7582307229992228`*^9, 
   3.758230846386991*^9, 3.7582350308102303`*^9, {3.758235096165251*^9, 
   3.758235108349214*^9}, {3.758235140480421*^9, 3.7582351690850563`*^9}, 
   3.758235199648768*^9, {3.758235306765503*^9, 3.758235361333737*^9}, 
   3.758235418761107*^9, 3.758235557338386*^9, {3.758235592575573*^9, 
   3.758235614198547*^9}, {3.758235730584587*^9, 3.758235757802148*^9}, 
   3.758463316903202*^9, 3.758464770515912*^9, {3.758464861714429*^9, 
   3.758464868043001*^9}, 3.758464989878517*^9, 3.758465035869739*^9, 
   3.7584651945611687`*^9, 3.796674256595995*^9, {3.796674301188517*^9, 
   3.796674344766362*^9}, {3.796675379843728*^9, 3.796675404947117*^9}, 
   3.796729197371552*^9, 3.796732599198082*^9, {3.7967329491014557`*^9, 
   3.796732953088006*^9}, 3.796736735126375*^9, 3.79673786656246*^9, 
   3.796742265543207*^9},ExpressionUUID->"87f23b6b-5d4c-42e0-8859-\
08cb106f452f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"w42", " ", "w52"}], "+", 
     RowBox[{"w45", " ", "w52"}], "+", 
     RowBox[{"w42", " ", "w54"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"w31", " ", "w61"}], "+", 
     RowBox[{"w36", " ", "w61"}], "+", 
     RowBox[{"w31", " ", "w63"}]}], ")"}]}], "+", 
  RowBox[{"u", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"w42", " ", "w52"}], "+", 
        RowBox[{"w45", " ", "w52"}], "+", 
        RowBox[{"w42", " ", "w54"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"w61", "+", "w63"}], ")"}]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"w52", "+", "w54"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"w31", " ", "w61"}], "+", 
         RowBox[{"w36", " ", "w61"}], "+", 
         RowBox[{"w31", " ", "w63"}]}], ")"}]}], "K34"]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.7582302313702993`*^9, 3.758230243059205*^9}, {
   3.758230341323646*^9, 3.758230348793394*^9}, 3.7582305167347393`*^9, {
   3.758230667368095*^9, 3.75823067952877*^9}, 3.7582307229992228`*^9, 
   3.758230846386991*^9, 3.7582350308102303`*^9, {3.758235096165251*^9, 
   3.758235108349214*^9}, {3.758235140480421*^9, 3.7582351690850563`*^9}, 
   3.758235199648768*^9, {3.758235306765503*^9, 3.758235361333737*^9}, 
   3.758235418761107*^9, 3.758235557338386*^9, {3.758235592575573*^9, 
   3.758235614198547*^9}, {3.758235730584587*^9, 3.758235757802148*^9}, 
   3.758463316903202*^9, 3.758464770515912*^9, {3.758464861714429*^9, 
   3.758464868043001*^9}, 3.758464989878517*^9, 3.758465035869739*^9, 
   3.7584651945611687`*^9, 3.796674256595995*^9, {3.796674301188517*^9, 
   3.796674344766362*^9}, {3.796675379843728*^9, 3.796675404947117*^9}, 
   3.796729197371552*^9, 3.796732599198082*^9, {3.7967329491014557`*^9, 
   3.796732953088006*^9}, 3.796736735126375*^9, 3.79673786656246*^9, 
   3.796742265550766*^9},ExpressionUUID->"6db1d836-a957-43a1-938f-\
a2e5632ba23f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.7582302313702993`*^9, 3.758230243059205*^9}, {
   3.758230341323646*^9, 3.758230348793394*^9}, 3.7582305167347393`*^9, {
   3.758230667368095*^9, 3.75823067952877*^9}, 3.7582307229992228`*^9, 
   3.758230846386991*^9, 3.7582350308102303`*^9, {3.758235096165251*^9, 
   3.758235108349214*^9}, {3.758235140480421*^9, 3.7582351690850563`*^9}, 
   3.758235199648768*^9, {3.758235306765503*^9, 3.758235361333737*^9}, 
   3.758235418761107*^9, 3.758235557338386*^9, {3.758235592575573*^9, 
   3.758235614198547*^9}, {3.758235730584587*^9, 3.758235757802148*^9}, 
   3.758463316903202*^9, 3.758464770515912*^9, {3.758464861714429*^9, 
   3.758464868043001*^9}, 3.758464989878517*^9, 3.758465035869739*^9, 
   3.7584651945611687`*^9, 3.796674256595995*^9, {3.796674301188517*^9, 
   3.796674344766362*^9}, {3.796675379843728*^9, 3.796675404947117*^9}, 
   3.796729197371552*^9, 3.796732599198082*^9, {3.7967329491014557`*^9, 
   3.796732953088006*^9}, 3.796736735126375*^9, 3.79673786656246*^9, 
   3.796742265556684*^9},ExpressionUUID->"e426c206-8667-4f03-9a32-\
cd0a05b647ba"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.7582302313702993`*^9, 3.758230243059205*^9}, {
   3.758230341323646*^9, 3.758230348793394*^9}, 3.7582305167347393`*^9, {
   3.758230667368095*^9, 3.75823067952877*^9}, 3.7582307229992228`*^9, 
   3.758230846386991*^9, 3.7582350308102303`*^9, {3.758235096165251*^9, 
   3.758235108349214*^9}, {3.758235140480421*^9, 3.7582351690850563`*^9}, 
   3.758235199648768*^9, {3.758235306765503*^9, 3.758235361333737*^9}, 
   3.758235418761107*^9, 3.758235557338386*^9, {3.758235592575573*^9, 
   3.758235614198547*^9}, {3.758235730584587*^9, 3.758235757802148*^9}, 
   3.758463316903202*^9, 3.758464770515912*^9, {3.758464861714429*^9, 
   3.758464868043001*^9}, 3.758464989878517*^9, 3.758465035869739*^9, 
   3.7584651945611687`*^9, 3.796674256595995*^9, {3.796674301188517*^9, 
   3.796674344766362*^9}, {3.796675379843728*^9, 3.796675404947117*^9}, 
   3.796729197371552*^9, 3.796732599198082*^9, {3.7967329491014557`*^9, 
   3.796732953088006*^9}, 3.796736735126375*^9, 3.79673786656246*^9, 
   3.796742265561235*^9},ExpressionUUID->"ac6b5190-d56e-4205-a17e-\
58c28daf355c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.7582302313702993`*^9, 3.758230243059205*^9}, {
   3.758230341323646*^9, 3.758230348793394*^9}, 3.7582305167347393`*^9, {
   3.758230667368095*^9, 3.75823067952877*^9}, 3.7582307229992228`*^9, 
   3.758230846386991*^9, 3.7582350308102303`*^9, {3.758235096165251*^9, 
   3.758235108349214*^9}, {3.758235140480421*^9, 3.7582351690850563`*^9}, 
   3.758235199648768*^9, {3.758235306765503*^9, 3.758235361333737*^9}, 
   3.758235418761107*^9, 3.758235557338386*^9, {3.758235592575573*^9, 
   3.758235614198547*^9}, {3.758235730584587*^9, 3.758235757802148*^9}, 
   3.758463316903202*^9, 3.758464770515912*^9, {3.758464861714429*^9, 
   3.758464868043001*^9}, 3.758464989878517*^9, 3.758465035869739*^9, 
   3.7584651945611687`*^9, 3.796674256595995*^9, {3.796674301188517*^9, 
   3.796674344766362*^9}, {3.796675379843728*^9, 3.796675404947117*^9}, 
   3.796729197371552*^9, 3.796732599198082*^9, {3.7967329491014557`*^9, 
   3.796732953088006*^9}, 3.796736735126375*^9, 3.79673786656246*^9, 
   3.796742265565386*^9},ExpressionUUID->"56f57856-6e74-4c20-8a89-\
d0212a676b3b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.7582302313702993`*^9, 3.758230243059205*^9}, {
   3.758230341323646*^9, 3.758230348793394*^9}, 3.7582305167347393`*^9, {
   3.758230667368095*^9, 3.75823067952877*^9}, 3.7582307229992228`*^9, 
   3.758230846386991*^9, 3.7582350308102303`*^9, {3.758235096165251*^9, 
   3.758235108349214*^9}, {3.758235140480421*^9, 3.7582351690850563`*^9}, 
   3.758235199648768*^9, {3.758235306765503*^9, 3.758235361333737*^9}, 
   3.758235418761107*^9, 3.758235557338386*^9, {3.758235592575573*^9, 
   3.758235614198547*^9}, {3.758235730584587*^9, 3.758235757802148*^9}, 
   3.758463316903202*^9, 3.758464770515912*^9, {3.758464861714429*^9, 
   3.758464868043001*^9}, 3.758464989878517*^9, 3.758465035869739*^9, 
   3.7584651945611687`*^9, 3.796674256595995*^9, {3.796674301188517*^9, 
   3.796674344766362*^9}, {3.796675379843728*^9, 3.796675404947117*^9}, 
   3.796729197371552*^9, 3.796732599198082*^9, {3.7967329491014557`*^9, 
   3.796732953088006*^9}, 3.796736735126375*^9, 3.79673786656246*^9, 
   3.796742265569721*^9},ExpressionUUID->"0c136eb2-d15f-41a9-a664-\
147cb7240429"]
}, Open  ]],

Cell[TextData[StyleBox["Collecting coefficients in the numerators and \
denominators of the dydv derivative:",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{
  3.757893399934004*^9, {3.757893484489756*^9, 3.7578934866488447`*^9}, {
   3.7966743679902143`*^9, 
   3.796674368413124*^9}},ExpressionUUID->"93cd68ba-08ea-4783-a166-\
cf1ef1d14dc9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"dydvNumCoefList", "=", 
  RowBox[{"Map", "[", 
   RowBox[{"Simplify", ",", 
    RowBox[{"CoefficientList", "[", 
     RowBox[{
      RowBox[{"dydvNum", "*", "d34"}], ",", "u"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"dydvDenomCoefList", "=", 
  RowBox[{"Map", "[", 
   RowBox[{"Simplify", ",", 
    RowBox[{"CoefficientList", "[", 
     RowBox[{
      RowBox[{"dydvDenom", "*", "d34"}], ",", "u"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"av", " ", "=", " ", 
   RowBox[{
    RowBox[{"\[Psi]", "*", "w61"}], "+", " ", 
    RowBox[{"\[Phi]", "*", 
     RowBox[{"w52", "/", "K34"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bv", " ", "=", 
   RowBox[{"\[Psi]", "*", "\[Phi]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ev", "=", 
   RowBox[{
    RowBox[{"v", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"w31", "*", "w52"}], "+", 
           RowBox[{"w31", "*", "w54"}], "+", 
           RowBox[{"w36", "*", "w52"}]}], ")"}], "/", "K34"}], "/", "K56"}], 
       "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"w42", "*", "w61"}], "+", 
         RowBox[{"w42", "*", "w63"}], "+", 
         RowBox[{"w45", "*", "w61"}]}], ")"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"d", "[", 
       RowBox[{"[", "5", "]"}], "]"}], "/", "K34"}], "*", "\[Phi]"}], "+", 
    RowBox[{
     RowBox[{"d", "[", 
      RowBox[{"[", "6", "]"}], "]"}], "*", "\[Psi]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"fv", "=", 
  RowBox[{
   RowBox[{"v", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"w42", "+", "w45"}], ")"}], "*", "\[Phi]"}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"w31", "+", "w36"}], ")"}], "/", "K56"}], "*", "\[Psi]"}]}], 
     ")"}]}], "+", 
   RowBox[{"\[Phi]", "*", "\[Psi]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"dydvNumCoefList", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{"Expand", "[", "bv", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"dydvNumCoefList", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{"Expand", "[", "av", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"dydvDenomCoefList", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{"Expand", "[", " ", "fv", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"dydvDenomCoefList", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{"Expand", "[", " ", "ev", "]"}]}]}], "Input",
 CellChangeTimes->{{3.757893401785035*^9, 3.757893430701606*^9}, {
  3.7578934817784243`*^9, 3.757893523425927*^9}, {3.758228027810975*^9, 
  3.758228047497333*^9}, {3.7582301149089622`*^9, 3.758230173475965*^9}, {
  3.758230737112165*^9, 3.7582307513988113`*^9}, {3.758230833334641*^9, 
  3.758230834717622*^9}, {3.758464154661059*^9, 3.758464164059329*^9}, {
  3.758464875628043*^9, 3.758464884064848*^9}, {3.758465295935027*^9, 
  3.758465381357518*^9}, {3.758465450884811*^9, 3.758465513997178*^9}, {
  3.796674370777409*^9, 
  3.796674475752468*^9}},ExpressionUUID->"90b0d8b7-066c-404b-be15-\
3ba92ec79f06"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"w45", " ", "w52"}], "+", 
      RowBox[{"w42", " ", 
       RowBox[{"(", 
        RowBox[{"w52", "+", "w54"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"w36", " ", "w61"}], "+", 
      RowBox[{"w31", " ", 
       RowBox[{"(", 
        RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"w36", " ", "w52", " ", "w61"}], "+", 
     RowBox[{"K34", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"w45", " ", "w52"}], "+", 
        RowBox[{"w42", " ", 
         RowBox[{"(", 
          RowBox[{"w52", "+", "w54"}], ")"}]}]}], ")"}], " ", "w61"}], "+", 
     RowBox[{"w31", " ", "w52", " ", 
      RowBox[{"(", 
       RowBox[{"w61", "+", "w63"}], ")"}]}]}], "K34"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.75789352411485*^9, 3.757893929025199*^9, 3.758228223440132*^9, {
   3.758230118726778*^9, 3.7582301744917917`*^9}, {3.7582307354566193`*^9, 
   3.758230753107359*^9}, 3.758230848146132*^9, 3.758463319243391*^9, 
   3.758464773117342*^9, 3.758464885056018*^9, 3.758465479763732*^9, 
   3.75846551469269*^9, 3.796674492649418*^9, {3.7966753823542833`*^9, 
   3.796675409693263*^9}, 3.796729198077702*^9, 3.796732956649767*^9, 
   3.796736735304893*^9, 3.7967379529768248`*^9, 
   3.796742265660548*^9},ExpressionUUID->"719fcc02-4244-44e2-98ea-\
af60ae8f8be9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"v", " ", 
      RowBox[{"(", 
       RowBox[{"w31", "+", "w36"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"w45", " ", "w52"}], "+", 
        RowBox[{"w42", " ", 
         RowBox[{"(", 
          RowBox[{"w52", "+", "w54"}], ")"}]}]}], ")"}]}], "K56"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v", " ", 
        RowBox[{"(", 
         RowBox[{"w42", "+", "w45"}], ")"}]}], "+", 
       RowBox[{"w45", " ", "w52"}], "+", 
       RowBox[{"w42", " ", 
        RowBox[{"(", 
         RowBox[{"w52", "+", "w54"}], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"w36", " ", "w61"}], "+", 
       RowBox[{"w31", " ", 
        RowBox[{"(", 
         RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"K34", " ", "K56"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"K56", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"w36", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", "w54"}], ")"}], " ", "w61"}], "+", 
         RowBox[{"w31", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", "w54"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"w61", "+", "w63"}], ")"}]}], "+", 
         RowBox[{"K34", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"w45", " ", "w52"}], "+", 
            RowBox[{"w42", " ", 
             RowBox[{"(", 
              RowBox[{"w52", "+", "w54"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"v", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"w36", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", 
            RowBox[{"K56", " ", "w61"}]}], ")"}]}], "+", 
         RowBox[{"K34", " ", "w45", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", 
            RowBox[{"K56", " ", "w61"}]}], ")"}]}], "+", 
         RowBox[{"w31", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", "w54", "+", 
            RowBox[{"K56", " ", 
             RowBox[{"(", 
              RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"K34", " ", "w42", " ", 
          RowBox[{"(", 
           RowBox[{"w52", "+", "w54", "+", 
            RowBox[{"K56", " ", 
             RowBox[{"(", 
              RowBox[{"w61", "+", "w63"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.75789352411485*^9, 3.757893929025199*^9, 3.758228223440132*^9, {
   3.758230118726778*^9, 3.7582301744917917`*^9}, {3.7582307354566193`*^9, 
   3.758230753107359*^9}, 3.758230848146132*^9, 3.758463319243391*^9, 
   3.758464773117342*^9, 3.758464885056018*^9, 3.758465479763732*^9, 
   3.75846551469269*^9, 3.796674492649418*^9, {3.7966753823542833`*^9, 
   3.796675409693263*^9}, 3.796729198077702*^9, 3.796732956649767*^9, 
   3.796736735304893*^9, 3.7967379529768248`*^9, 
   3.796742265668826*^9},ExpressionUUID->"f11b497f-1217-4104-9e10-\
d40b1e8ec934"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"w42", " ", "w52"}], "+", 
     RowBox[{"w45", " ", "w52"}], "+", 
     RowBox[{"w42", " ", "w54"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"w31", " ", "w61"}], "+", 
     RowBox[{"w36", " ", "w61"}], "+", 
     RowBox[{"w31", " ", "w63"}]}], ")"}]}], "+", 
  RowBox[{"v", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"w31", "+", "w36"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"w42", " ", "w52"}], "+", 
         RowBox[{"w45", " ", "w52"}], "+", 
         RowBox[{"w42", " ", "w54"}]}], ")"}]}], "K56"], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"w42", "+", "w45"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"w31", " ", "w61"}], "+", 
        RowBox[{"w36", " ", "w61"}], "+", 
        RowBox[{"w31", " ", "w63"}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.75789352411485*^9, 3.757893929025199*^9, 3.758228223440132*^9, {
   3.758230118726778*^9, 3.7582301744917917`*^9}, {3.7582307354566193`*^9, 
   3.758230753107359*^9}, 3.758230848146132*^9, 3.758463319243391*^9, 
   3.758464773117342*^9, 3.758464885056018*^9, 3.758465479763732*^9, 
   3.75846551469269*^9, 3.796674492649418*^9, {3.7966753823542833`*^9, 
   3.796675409693263*^9}, 3.796729198077702*^9, 3.796732956649767*^9, 
   3.796736735304893*^9, 3.7967379529768248`*^9, 
   3.796742265675424*^9},ExpressionUUID->"26bfc145-ce25-4587-a5eb-\
e297eefad319"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.75789352411485*^9, 3.757893929025199*^9, 3.758228223440132*^9, {
   3.758230118726778*^9, 3.7582301744917917`*^9}, {3.7582307354566193`*^9, 
   3.758230753107359*^9}, 3.758230848146132*^9, 3.758463319243391*^9, 
   3.758464773117342*^9, 3.758464885056018*^9, 3.758465479763732*^9, 
   3.75846551469269*^9, 3.796674492649418*^9, {3.7966753823542833`*^9, 
   3.796675409693263*^9}, 3.796729198077702*^9, 3.796732956649767*^9, 
   3.796736735304893*^9, 3.7967379529768248`*^9, 
   3.796742265680645*^9},ExpressionUUID->"24589e48-ce46-4f88-aedb-\
cd20817a3b33"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.75789352411485*^9, 3.757893929025199*^9, 3.758228223440132*^9, {
   3.758230118726778*^9, 3.7582301744917917`*^9}, {3.7582307354566193`*^9, 
   3.758230753107359*^9}, 3.758230848146132*^9, 3.758463319243391*^9, 
   3.758464773117342*^9, 3.758464885056018*^9, 3.758465479763732*^9, 
   3.75846551469269*^9, 3.796674492649418*^9, {3.7966753823542833`*^9, 
   3.796675409693263*^9}, 3.796729198077702*^9, 3.796732956649767*^9, 
   3.796736735304893*^9, 3.7967379529768248`*^9, 
   3.7967422656854467`*^9},ExpressionUUID->"7f6de9d0-6041-4473-8213-\
91a11f8ac6fb"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.75789352411485*^9, 3.757893929025199*^9, 3.758228223440132*^9, {
   3.758230118726778*^9, 3.7582301744917917`*^9}, {3.7582307354566193`*^9, 
   3.758230753107359*^9}, 3.758230848146132*^9, 3.758463319243391*^9, 
   3.758464773117342*^9, 3.758464885056018*^9, 3.758465479763732*^9, 
   3.75846551469269*^9, 3.796674492649418*^9, {3.7966753823542833`*^9, 
   3.796675409693263*^9}, 3.796729198077702*^9, 3.796732956649767*^9, 
   3.796736735304893*^9, 3.7967379529768248`*^9, 
   3.796742265690613*^9},ExpressionUUID->"22bf0873-6b82-433d-a6a1-\
4e963173e7c4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.75789352411485*^9, 3.757893929025199*^9, 3.758228223440132*^9, {
   3.758230118726778*^9, 3.7582301744917917`*^9}, {3.7582307354566193`*^9, 
   3.758230753107359*^9}, 3.758230848146132*^9, 3.758463319243391*^9, 
   3.758464773117342*^9, 3.758464885056018*^9, 3.758465479763732*^9, 
   3.75846551469269*^9, 3.796674492649418*^9, {3.7966753823542833`*^9, 
   3.796675409693263*^9}, 3.796729198077702*^9, 3.796732956649767*^9, 
   3.796736735304893*^9, 3.7967379529768248`*^9, 
   3.7967422656956673`*^9},ExpressionUUID->"c9c7d671-f032-48da-a9dd-\
db14e4916135"]
}, Open  ]],

Cell[TextData[StyleBox["Obtaining the pre-factor \[Beta] in the second \
derivative d2ydudv",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{
  3.7967270972172203`*^9, {3.796727190361858*^9, 3.796727192277566*^9}, {
   3.796727231137669*^9, 3.796727231627665*^9}, {3.796727267903686*^9, 
   3.796727278719582*^9}, {3.796727434851597*^9, 3.7967274514803467`*^9}, {
   3.796727715630027*^9, 3.796727719220971*^9}, {3.7967397345192947`*^9, 
   3.796739736365284*^9}},ExpressionUUID->"8fcca014-c061-4d05-965b-\
30749f5afc57"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d2ydudvNum1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"dyduNumCoefList", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "*", 
      RowBox[{"dyduDenomCoefList", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"dyduNumCoefList", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "*", 
      RowBox[{"dyduDenomCoefList", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "w36"}], "*", 
     RowBox[{"\[Psi]", "/", "K56"}]}], "-", 
    RowBox[{"w45", "*", "\[Phi]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"d2ydudvNum1", "/", 
    RowBox[{"(", 
     RowBox[{"dydvNum", "*", "d34"}], ")"}]}], "]"}], "\[Equal]", 
  RowBox[{"Simplify", "[", "\[Beta]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.796727298541664*^9, 3.796727300804377*^9}, 
   3.796727427580915*^9, {3.796727489122211*^9, 3.7967275257321453`*^9}, {
   3.796727581533985*^9, 3.796727585552194*^9}, {3.796739396144361*^9, 
   3.796739413062468*^9}},ExpressionUUID->"7af8e81b-67b9-4e88-9a6a-\
4038116305b1"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.796727462451434*^9, 3.796727526910638*^9, 
  3.796727585945808*^9, 3.796729198927513*^9, 3.7967329632105627`*^9, 
  3.7967367354553747`*^9, 3.796739418154396*^9, 
  3.796742265798723*^9},ExpressionUUID->"e74e4f91-77d4-41f3-81c9-\
73fc8f55187e"]
}, Open  ]],

Cell[TextData[StyleBox["Another way of obtaining \[Beta]",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{{3.796727731528418*^9, 3.796727748521144*^9}, {
  3.7967397419630747`*^9, 
  3.796739744104579*^9}},ExpressionUUID->"1690f76b-1637-4fa0-89dd-\
85e7eb563d23"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"dyduNum", ",", "v"}], "]"}], "*", "dyduDenom"}], "-", 
      RowBox[{"dyduNum", "*", 
       RowBox[{"D", "[", 
        RowBox[{"dyduDenom", ",", "v"}], "]"}]}]}], ")"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"d56", "^", "2"}], "/", "dydvNum"}], "/", "d34"}]}], "]"}], 
  "\[Equal]", 
  RowBox[{"Simplify", "[", "\[Beta]", "]"}]}]], "Input",
 CellChangeTimes->{{3.7967277606534*^9, 3.796727766005015*^9}, {
  3.796739770943861*^9, 
  3.796739774884478*^9}},ExpressionUUID->"5ca4721b-261c-4ece-a43a-\
773db5bc9648"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.796727768122467*^9, 3.796729199163566*^9, 
  3.796732968703368*^9, 3.79673673577989*^9, 3.796739779676235*^9, 
  3.796742265948681*^9},ExpressionUUID->"af1e0de7-2a48-4922-abaa-\
c1de6952b014"]
}, Open  ]],

Cell[TextData[StyleBox["Verifying that \[Beta] in the second derivative \
d2ydvdu is the same as above",
 FontColor->RGBColor[1, 0.5, 0]]], "Text",
 CellChangeTimes->{{3.796727788768694*^9, 3.796727815104167*^9}, {
  3.796739788178969*^9, 
  3.796739790234898*^9}},ExpressionUUID->"28f70313-3f87-44bd-b633-\
b35d4371be5a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d2ydvduNum1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"dydvNumCoefList", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "*", 
      RowBox[{"dydvDenomCoefList", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"dydvNumCoefList", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "*", 
      RowBox[{"dydvDenomCoefList", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"d2ydvduNum1", "/", 
   RowBox[{"(", 
    RowBox[{"dyduNum", "*", "d56"}], ")"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7578747991558733`*^9, 3.757874840808485*^9}, {
  3.7578751125360727`*^9, 3.7578751238861732`*^9}, {3.7578935850900106`*^9, 
  3.757893650868367*^9}, {3.75789369774903*^9, 3.757893706680853*^9}, {
  3.758228069838841*^9, 3.7582281655566397`*^9}, {3.7584657279994783`*^9, 
  3.7584657361997213`*^9}, {3.796674506350162*^9, 3.7966745735281773`*^9}, {
  3.796727819474998*^9, 3.796727912755938*^9}, {3.796728177907618*^9, 
  3.796728182514032*^9}, {3.79672821696632*^9, 3.7967282172216473`*^9}, {
  3.796728289708321*^9, 3.796728290446423*^9}, {3.796728692705098*^9, 
  3.796728693384721*^9}, {3.796728773657735*^9, 3.796728809602813*^9}, {
  3.796728877996469*^9, 3.796728883267383*^9}, {3.796729126241645*^9, 
  3.796729136681697*^9}},ExpressionUUID->"c02e7f36-a1f2-456f-b1f5-\
e87e01735d2d"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"w36", " ", "w54", " ", "w61"}], "+", 
    RowBox[{"K34", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"w45", " ", "w52"}], "+", 
       RowBox[{"w42", " ", 
        RowBox[{"(", 
         RowBox[{"w52", "+", "w54"}], ")"}]}]}], ")"}], " ", "w63"}], "+", 
    RowBox[{"w31", " ", "w54", " ", 
     RowBox[{"(", 
      RowBox[{"w61", "+", "w63"}], ")"}]}]}], "K34"]}]], "Output",
 CellChangeTimes->{{3.757874826228064*^9, 3.757874841255212*^9}, 
   3.7578751243518133`*^9, 3.7578755521060123`*^9, 3.75787563213103*^9, 
   3.757875798687669*^9, 3.75789361463341*^9, 3.757893651461093*^9, 
   3.757893708241928*^9, 3.757893931459488*^9, 3.758228225866288*^9, 
   3.7584633233397293`*^9, 3.758464775203319*^9, 3.75846573833188*^9, 
   3.796674596472369*^9, {3.796675384838044*^9, 3.796675412017489*^9}, 
   3.796727914622998*^9, 3.7967281843486347`*^9, 3.796728218240036*^9, 
   3.7967286982079763`*^9, 3.7967287705791893`*^9, 3.796728841134678*^9, 
   3.79672888604321*^9, {3.796729132009774*^9, 3.796729138800106*^9}, 
   3.796729199299426*^9, 3.796732970613517*^9, 3.796736735913916*^9, 
   3.796740523613171*^9, 
   3.7967422660481043`*^9},ExpressionUUID->"762b84f9-58af-4a03-92ba-\
1acb28a44bb1"]
}, Open  ]]
},
WindowSize->{1423, 1157},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->2,
PrintingPageRange->{1, Automatic},
PrintingOptions->{"PaperOrientation"->"Portrait",
"PaperSize"->{612, 1008},
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->True,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{54, 54}, {72, 72}}},
FrontEndVersion->"11.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 271, 6, 38, "Text",ExpressionUUID->"33242e41-eaef-4afa-abee-85854b3f510d"],
Cell[CellGroupData[{
Cell[854, 30, 2763, 56, 73, "Input",ExpressionUUID->"1f6cecbc-3da7-49ee-8e54-1cd16abd6c6c"],
Cell[3620, 88, 1744, 34, 56, "Output",ExpressionUUID->"a0a6b9da-7fc1-424b-8b0f-a853f3526dca"],
Cell[5367, 124, 1550, 33, 49, "Output",ExpressionUUID->"d9f44235-d126-4834-82b5-568fb0d3b26f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6954, 162, 139, 2, 30, "Input",ExpressionUUID->"771914ae-a2f0-4fba-92f8-f014b348771d"],
Cell[7096, 166, 1097, 28, 142, "Output",ExpressionUUID->"037c0afc-79ac-4fa3-a66e-889ad83c4914"]
}, Open  ]],
Cell[8208, 197, 230, 4, 35, "Text",ExpressionUUID->"54fd5c5c-473c-4ca0-88ca-8beec54c6de7"],
Cell[CellGroupData[{
Cell[8463, 205, 1702, 52, 73, "Input",ExpressionUUID->"4b5d8b6d-bd1f-4f99-82f9-63c63bf97ef4"],
Cell[10168, 259, 927, 19, 49, "Output",ExpressionUUID->"db80c5b4-bf7d-4b80-87c6-5793c8018655"],
Cell[11098, 280, 874, 20, 51, "Output",ExpressionUUID->"334e3e48-96ca-4bd9-9534-b89251a05427"],
Cell[11975, 302, 872, 20, 51, "Output",ExpressionUUID->"22068d60-2890-4b8b-993d-88fd2f49ce9d"]
}, Open  ]],
Cell[12862, 325, 460, 7, 35, "Text",ExpressionUUID->"c0691444-39e0-4983-a403-2c7560025637"],
Cell[13325, 334, 5868, 159, 154, "Input",ExpressionUUID->"e8d2c3bc-3434-4aad-bb1a-aba32b92be0d"],
Cell[19196, 495, 454, 7, 35, "Text",ExpressionUUID->"ac233889-be97-49db-ba47-b1a48ea3aae3"],
Cell[19653, 504, 4016, 107, 155, "Input",ExpressionUUID->"d9854dab-86be-4f3a-8631-8e08c1912f32"],
Cell[23672, 613, 430, 7, 58, "Text",ExpressionUUID->"0152dfff-8a81-4921-b832-b0d2cc3e91b4"],
Cell[CellGroupData[{
Cell[24127, 624, 1511, 48, 73, "Input",ExpressionUUID->"fe94f78a-aa49-4ea0-957e-c8fac3bc7367"],
Cell[25641, 674, 210, 4, 34, "Output",ExpressionUUID->"f45ed0ca-19a0-423e-9899-21742d319f2f"]
}, Open  ]],
Cell[25866, 681, 512, 8, 35, "Text",ExpressionUUID->"68d5f8f9-37be-4a8a-9397-02e2cedf7155"],
Cell[26381, 691, 1552, 44, 52, "Input",ExpressionUUID->"8cb8505b-533c-4e6a-94b6-e7bcade9b087"],
Cell[27936, 737, 303, 5, 35, "Text",ExpressionUUID->"6698ac70-ce98-4fb6-a730-f3c988667f3b"],
Cell[28242, 744, 1098, 25, 96, "Input",ExpressionUUID->"18ead6a9-13e4-45a3-8709-3f3fab505b18"],
Cell[29343, 771, 425, 7, 35, "Text",ExpressionUUID->"635e7e81-1fae-48a8-81bb-bcb393bace10"],
Cell[CellGroupData[{
Cell[29793, 782, 5143, 123, 262, "Input",ExpressionUUID->"1a6e7a5e-e771-4551-9647-f0d1f0364c94"],
Cell[34939, 907, 1951, 44, 51, "Output",ExpressionUUID->"da10335e-8cc3-4c32-869c-23af69561a31"],
Cell[36893, 953, 4110, 106, 118, "Output",ExpressionUUID->"87f23b6b-5d4c-42e0-8859-08cb106f452f"],
Cell[41006, 1061, 2073, 49, 51, "Output",ExpressionUUID->"6db1d836-a957-43a1-938f-a2e5632ba23f"],
Cell[43082, 1112, 1124, 16, 34, "Output",ExpressionUUID->"e426c206-8667-4f03-9a32-cd0a05b647ba"],
Cell[44209, 1130, 1124, 16, 34, "Output",ExpressionUUID->"ac6b5190-d56e-4205-a17e-58c28daf355c"],
Cell[45336, 1148, 1124, 16, 34, "Output",ExpressionUUID->"56f57856-6e74-4c20-8a89-d0212a676b3b"],
Cell[46463, 1166, 1124, 16, 34, "Output",ExpressionUUID->"0c136eb2-d15f-41a9-a664-147cb7240429"]
}, Open  ]],
Cell[47602, 1185, 359, 7, 35, "Text",ExpressionUUID->"93cd68ba-08ea-4783-a166-cf1ef1d14dc9"],
Cell[CellGroupData[{
Cell[47986, 1196, 3390, 94, 220, "Input",ExpressionUUID->"90b0d8b7-066c-404b-be15-3ba92ec79f06"],
Cell[51379, 1292, 1447, 38, 51, "Output",ExpressionUUID->"719fcc02-4244-44e2-98ea-af60ae8f8be9"],
Cell[52829, 1332, 3124, 88, 118, "Output",ExpressionUUID->"f11b497f-1217-4104-9e10-d40b1e8ec934"],
Cell[55956, 1422, 1557, 42, 51, "Output",ExpressionUUID->"26bfc145-ce25-4587-a5eb-e297eefad319"],
Cell[57516, 1466, 613, 10, 34, "Output",ExpressionUUID->"24589e48-ce46-4f88-aedb-cd20817a3b33"],
Cell[58132, 1478, 615, 10, 34, "Output",ExpressionUUID->"7f6de9d0-6041-4473-8213-91a11f8ac6fb"],
Cell[58750, 1490, 613, 10, 34, "Output",ExpressionUUID->"22bf0873-6b82-433d-a6a1-4e963173e7c4"],
Cell[59366, 1502, 615, 10, 34, "Output",ExpressionUUID->"c9c7d671-f032-48da-a9dd-db14e4916135"]
}, Open  ]],
Cell[59996, 1515, 536, 9, 35, "Text",ExpressionUUID->"8fcca014-c061-4d05-965b-30749f5afc57"],
Cell[CellGroupData[{
Cell[60557, 1528, 1229, 33, 73, "Input",ExpressionUUID->"7af8e81b-67b9-4e88-9a6a-4038116305b1"],
Cell[61789, 1563, 297, 5, 34, "Output",ExpressionUUID->"e74e4f91-77d4-41f3-81c9-73fc8f55187e"]
}, Open  ]],
Cell[62101, 1571, 278, 5, 35, "Text",ExpressionUUID->"1690f76b-1637-4fa0-89dd-85e7eb563d23"],
Cell[CellGroupData[{
Cell[62404, 1580, 677, 20, 30, "Input",ExpressionUUID->"5ca4721b-261c-4ece-a43a-773db5bc9648"],
Cell[63084, 1602, 245, 4, 34, "Output",ExpressionUUID->"af1e0de7-2a48-4922-abaa-c1de6952b014"]
}, Open  ]],
Cell[63344, 1609, 322, 6, 35, "Text",ExpressionUUID->"28f70313-3f87-44bd-b633-b35d4371be5a"],
Cell[CellGroupData[{
Cell[63691, 1619, 1460, 31, 52, "Input",ExpressionUUID->"c02e7f36-a1f2-456f-b1f5-e87e01735d2d"],
Cell[65154, 1652, 1275, 27, 51, "Output",ExpressionUUID->"762b84f9-58af-4a03-92ba-1acb28a44bb1"]
}, Open  ]]
}
]
*)

