// Julien GARNIER, modified by Ester Comellas
// This macro works with ImageJ 1.52p

// Import the image stack
waitForUser("Load your original image stack. It must be a tif stack of a 16-bit channel with the proximal-distal axis vertically aligned.");
rename("original");

// Input the color channel of interest
Dialog.create("What color channel is in this image?");
Dialog.addChoice("Channel:", newArray("Red", "Green", "Blue"));
Dialog.show();
Channel = Dialog.getChoice();

// Import the mask 
// It is an 8bit image, but background has intensity=0 and mask has intensity=1
// We want background to be the maximum intensity possible when we apply the
// mask to the original image. If we kept the background black (0), we wouldn't
// be able to distinguish the black inside the organ from the one outside. 
// If the sample has been imaged correctly, there will never be any pixel with
// max intensity.
waitForUser("Load the mask. It must be an 8-bit tif stack produced by the Segmentation Editor.");
rename("mask");

// Convert to RGB and back to 8 bit so that black & white
// are at the extremes of the histogram B=255(=2^8-1) & W=0
// We need to do this, or invert doesn't work for some reason
run("RGB Color");
run("8-bit");
// Multiply by a large number in case the original mask was not white. 
// This way we ensure the mask is white (255) not gray.
run("Multiply...","value=1000.000 stack");

// Invert colors such that background is white (255) and mask is black (0)
run("Invert", "stack");

// Convert to 16-bit and shift "white" from 2^8 to 2^16 through multiply operation 
// Multiply by a large number (>257) to ensure that we set it to max value since
// with 16-bit images, results greater than 65535 are set to 65535.
run("16-bit");
run("Multiply...","value=1000.000 stack");

if (Channel == "Red") run("Red");
if (Channel == "Green") run("Green");
if (Channel == "Blue") run("Blue");

// Mask the original image
imageCalculator("OR create stack", "original","mask");
close("original");
close("mask");

// Reslice the image around the proximal to distal axis
run("Reslice [/]...", "output=1.000 start=Top avoid");

//Remove empty slices
id= getImageID();
Stack.getDimensions(width,height,channels,slices,frames);
s = 1;
while (s <= slices) {
setSlice(s);
getRawStatistics(nPixels, mean, min, max, std, histogram);
if (min == 65535) {
	run("Delete Slice");
	s = s - 1;
	Stack.getDimensions(width,height,channels,newSlices,frames);
	slices = newSlices;
    }
s++;
}

// Create a table with the 16-bit histogram values of each slice
nBins=65535;
//Empty exsiting Results table
//run("Clear Results");

//Define an array with the intensity values
//Row numbering starts at 1, but pixel intensity is 0 to nBins=65535
intensityvalue = newArray(nBins+1);

// Print the first column in the table with pixel intensity values
for (i=0; i<=nBins; i++){
  intensityvalue[i] = i;
  setResult("Intensity value / Slice number", i, intensityvalue[i]);
}

// Loop over all slices
for (slice=1; slice<=nSlices; slice++) {
 	if (nSlices>1) run("Set Slice...", "slice=" + slice);

	// Export 16-bit histogram of each slice
	//run("SixteenBit Histogram");

	// Raw data provides the 16-bit histogram for the current slice
	// with a bin width = 1, so no information is lost
	getRawStatistics(nPixels, mean, min, max, std, histogram);

	// Print a column in the table for the current slice with pixel intensity counts
	for (i=0; i<=nBins; i++){
 	   setResult(slice, i, histogram[i]);
	}
}

run("Input/Output...", "jpeg=85 gif=-1 file=.csv use_file copy_row save_column");

// Save the data
Dialog.create("Name the results file");
Dialog.addString("File name:", "");
Dialog.show();
SampleName = Dialog.getString();

Dir = getDirectory("Choose a directory to export the results"); 
saveAs("Results", Dir+"\\"+SampleName+".csv");