// Blastema tip intensity analysis
// Ester Comellas
// This macro works with ImageJ 1.52u

//Import the blastema image
waitForUser("Load your original blastema image via Bio-Formats Importer, then click OK. It must be a tif stack of a 16-bit channel with the proximal-distal axis vertically aligned.");
rename("blastema");

//Change these values to adjust to your image, if necessary
dist2tip = 250;
cubeside = 175;

//Get some parameters from the file
getVoxelSize(PXwidth, PXheight, PXdepth, unit);
//User input: x, y and z position of tip
setTool("point");
waitForUser("Scroll to the centre of the stack and click on the very tip of the blastema.");

run("Measure");
slice = getResult("Slice");
Xpos = getResult("X")- (cubeside/2);
XposPX = round(Xpos/PXwidth);
cubesideXPX = round(cubeside/PXwidth);
print("X position: "+getResult("X")+"; Y position: "+getResult("Y")+"; at slice: "+slice);

Ypos = getResult("Y") - dist2tip - cubeside;
YposPX = round(Ypos/PXheight);
//Assume Y position of tip is bottom of the image.
cubesideYPX = round(cubeside/PXheight);

TotalSlices = round(cubeside/PXdepth);
minSlice = (slice - round(TotalSlices/2));
maxSlice = minSlice + TotalSlices;

//Create rectangle based on user input and crop duplicated image
makeRectangle(XposPX, YposPX, cubesideXPX, cubesideYPX);
run("Crop");

//Duplicate substacking & save
run("Duplicate...", "title=blastema-cube duplicate range="+minSlice+"-"+maxSlice);
close("blastema");
//Empty and close exsiting Results table
run("Clear Results");
close("Results");

//Reslice perpendicular to the proximo-distal axis
run("Reslice [/]...", "output=1.000 start=Top avoid");  
rename("resliced-blastema-cube")

//Save cube and resliced-cube image stacks
Dir = getDirectory("Choose a directory to export the results"); 
selectWindow("blastema-cube");
run("Bio-Formats Exporter", "save="+Dir+"/blastema-cube.ome.tif compression=Uncompressed");
//close("blastema-cube");

selectWindow("resliced-blastema-cube");
run("Bio-Formats Exporter", "save="+Dir+"/resliced-blastema-cube.ome.tif compression=Uncompressed");


//Count pixel intensity
// Create a table with the 16-bit histogram values of each slice
//nBins=65535;

//Find max intensity value in stack
nBins = 0;
for (slice=1; slice<=nSlices; slice++) 
{
 	if (nSlices>1) 
 	{
 		run("Set Slice...", "slice=" + slice);
 	}
	// Raw data provides the 16-bit histogram for the current slice
	// with a bin width = 1, so no information is lost
	getRawStatistics(nPixels, mean, min, max, std, histogram);

    if (lengthOf(histogram) > nBins)
    {
        nBins = lengthOf(histogram);
    }
}

//Define an array with the intensity values
//Row numbering starts at 1, but pixel intensity is 0 to nBins=65535
intensityvalue = newArray(nBins+1);

// Print the first column in the table with pixel intensity values
for (i=0; i<=nBins; i++)
{
  intensityvalue[i] = i;
  setResult("Intensity value / Slice number", i, intensityvalue[i]);
}



// Loop over all slices
for (slice=1; slice<=nSlices; slice++) 
{
 	if (nSlices>1) 
 	{
 		run("Set Slice...", "slice=" + slice);
 	}
	// Raw data provides the 16-bit histogram for the current slice
	// with a bin width = 1, so no information is lost
	getRawStatistics(nPixels, mean, min, max, std, histogram);

	// Print a column in the table for the current slice with pixel intensity counts
	for (i=0; i<=nBins; i++)
	{
 	   if (i<lengthOf(histogram))
 	   {
 	   		setResult(slice, i, histogram[i]);
 	   }
 	   else 
 	   {
 	   		setResult(slice, i, 0);
 	   }
	}
}

run("Input/Output...", "jpeg=85 gif=-1 file=.csv use_file copy_row save_column");
saveAs("Results", Dir+"/intensity-values.csv");

//Empty and close exsiting Results table
run("Clear Results");
close("Results");