clear;
clc;
addpath ./tool
load ./DATA/Figure1-sourcedata Z1_story Z2_story

Z1=Z1_story;
Z2=Z2_story;

fs=128;
fz=fs;

L=size(Z1,1);
f=fz/L*(0:1:L-1);
L1=size(Z1,1);
f1=fz/L1*(0:1:L1-1);
L2=size(Z2,1);
f2=fz/L2*(0:1:L2-1);


for subj=1:16
    for ch=1:64
        z1_f(:,ch,subj)=abs(fft(Z1(:,ch,subj),L1)/L1*2).^2;
        z2_f(:,ch,subj)=abs(fft(Z2(:,ch,subj),L2)/L2*2).^2;
    end
end

Z1_story=z1_f;
Z2_story=z2_f;

%color
yanse1=rgb2hsv([0 0 0]);
yanse2=rgb2hsv([1 0 0]);

yanse1(2)=0.3;
yanse2(2)=0.3;

yansez1=[0.8 0.8 0.8];
yansez2=hsv2rgb(yanse2);

figure(1);
subplot(3,2,1)
hold on;
line_errorbar(f1(:,:),squeeze(mean(z1_f(:,:,:),2)),[1 1 1]./255,yansez2,1);
line_errorbar(f2(:,:),squeeze(mean(z2_f(:,:,:),2)),[1 1 1],yansez1,1);
l1=plot(f1(:,:),squeeze(mean(mean(z1_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[1 0 0]);
l2=plot(f2(:,:),squeeze(mean(mean(z2_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[0 0 0]);
xlim([1 5]);
ylim([0 0.5])
set(gca,'Xtick',[1:1:5])
set(gca,'Ytick',[0:0.1:0.5])
set(gca,'LineWidth',2)

%statictical test at 2hz 4hz
peak2=2;
peak4=4;
pp1(1)=test_peak(z1_f,f1,peak2,1e4);
pp1(2)=test_peak(z2_f,f2,peak2,1e4);
pp1(3)=test_peak(z1_f,f1,peak4,1e4);
pp1(4)=test_peak(z2_f,f2,peak4,1e4);
[HP1 ZP1 PP1]=fdr_bh(pp1);

z1_f_t4=z1_f(find(f1==4),:,:)-(z1_f(find(f1==4)-2,:,:)+z1_f(find(f1==4)-1,:,:)+z1_f(find(f1==4)+1,:,:)+z1_f(find(f1==4)+2,:,:))./4;
z1_f_t2=z1_f(find(f1==2),:,:)-(z1_f(find(f1==2)-2,:,:)+z1_f(find(f1==2)-1,:,:)+z1_f(find(f1==2)+1,:,:)+z1_f(find(f1==2)+2,:,:))./4;
z2_f_t4=z2_f(find(f1==4),:,:)-(z2_f(find(f1==4)-2,:,:)+z2_f(find(f1==4)-1,:,:)+z2_f(find(f1==4)+1,:,:)+z2_f(find(f1==4)+2,:,:))./4;
z2_f_t2=z2_f(find(f1==2),:,:)-(z2_f(find(f1==2)-2,:,:)+z2_f(find(f1==2)-1,:,:)+z2_f(find(f1==2)+1,:,:)+z2_f(find(f1==2)+2,:,:))./4;
data2(1,:)=squeeze(mean(z2_f_t2,2));
data2(2,:)=squeeze(mean(z1_f_t2,2));
data4(1,:)=squeeze(mean(z2_f_t4,2));
data4(2,:)=squeeze(mean(z1_f_t4,2));

nn=figure;subplot(1,4,3)
BSMtopo(double(mean(z1_f_t4,3)));caxis([0,0.6]);BSMtopoNoP;axis off;box off
subplot(1,4,1)
BSMtopo(double(mean(z1_f_t2,3)));caxis([0,0.3]);BSMtopoNoP;axis off;box off
subplot(1,4,4)
BSMtopo(double(mean(z2_f_t4,3)));caxis([0,0.6]);BSMtopoNoP;axis off;box off
subplot(1,4,2)
BSMtopo(double(mean(z2_f_t2,3)));caxis([0,0.3]);BSMtopoNoP;axis off;box off

%%
clearvars -except data2 data4;
clc;

load ./DATA/Figure1-sourcedata Z1_story Z2_story Z3_story Z4_story

Z1=Z1_story;
Z3=Z3_story; 
Z4=Z4_story;

fs=128;
fz=fs;

L1=size(Z1,1);
f1=fz/L1*(0:1:L1-1);
L2=size(Z3,1);
f2=fz/L2*(0:1:L2-1);
L3=size(Z4,1);
f3=fz/L3*(0:1:L3-1);

%power
for subj=1:16
    for ch=1:64
        z1_f(:,ch,subj)=abs(fft(Z3(:,ch,subj),L1)/L1*2).^2;
        z2_f(:,ch,subj)=abs(fft(Z4(:,ch,subj),L2)/L2*2).^2;
        z3_f(:,ch,subj)=abs(fft(Z1(:,ch,subj),L3)/L3*2).^2;
    end
end

%phase
for subj=1:16
    for ch=1:64
    z1_a(:,ch,subj)=fft(mean(Z3(:,ch,subj),2),L1)/L1*2;%64ͨ
    z2_a(:,ch,subj)=fft(mean(Z4(:,ch,subj),2),L2)/L2*2;
    z3_a(:,ch,subj)=fft(mean(Z1(:,ch,subj),2),L2)/L2*2;
    end
end

z_2La(:,:,1)=squeeze(z3_a(find(f1==2),:,:));
z_2La(:,:,2)=squeeze(z1_a(find(f2==2),:,:));
z_2La(:,:,3)=squeeze(z2_a(find(f3==2),:,:));

%color
yanse1=rgb2hsv([1 0 0]);
yanse2=rgb2hsv([0.1 0.6 1]);
yanse3=rgb2hsv([255 180 0]./255);

yanse1(2)=0.3;
yanse2(2)=0.3;
yanse3(2)=0.3;

yansez1=hsv2rgb(yanse1);
yansez2=hsv2rgb(yanse2);
yansez3=hsv2rgb(yanse3);

figure(1);
subplot(3,2,2)
hold on;
line_errorbar(f3(:,:),squeeze(mean(z3_f(:,:,:),2)),[0.1 0.6 1],yansez1,1);
line_errorbar(f1(:,:),squeeze(mean(z1_f(:,:,:),2)),[1 1 1]./255,yansez2,1);
line_errorbar(f2(:,:),squeeze(mean(z2_f(:,:,:),2)),[1 1 1],yansez3,1);
l1=plot(f1(:,:),squeeze(mean(mean(z1_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[0.1 0.6 1]);
l2=plot(f2(:,:),squeeze(mean(mean(z2_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[255 180 0]./255);
l3=plot(f3(:,:),squeeze(mean(mean(z3_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[1 0 0]);
xlim([1 5]);
ylim([0 0.8])
set(gca,'Xtick',[1:1:5])
set(gca,'Ytick',[0:0.2:0.8])
set(gca,'LineWidth',2)

%statictical test at 2hz 4hz
peak2=2;
peak4=4;
pp2(1)=test_peak(z1_f,f1,peak2,1e4);
pp2(2)=test_peak(z2_f,f2,peak2,1e4);
pp2(3)=test_peak(z1_f,f1,peak4,1e4);
pp2(4)=test_peak(z2_f,f2,peak4,1e4);
[HP2 ZP2 PP2]=fdr_bh(pp2);


z1_f_t4=z1_f(find(f1==4),:,:)-(z1_f(find(f1==4)-2,:,:)+z1_f(find(f1==4)-1,:,:)+z1_f(find(f1==4)+1,:,:)+z1_f(find(f1==4)+2,:,:))./4;
z1_f_t2=z1_f(find(f1==2),:,:)-(z1_f(find(f1==2)-2,:,:)+z1_f(find(f1==2)-1,:,:)+z1_f(find(f1==2)+1,:,:)+z1_f(find(f1==2)+2,:,:))./4;
z2_f_t4=z2_f(find(f1==4),:,:)-(z2_f(find(f1==4)-2,:,:)+z2_f(find(f1==4)-1,:,:)+z2_f(find(f1==4)+1,:,:)+z2_f(find(f1==4)+2,:,:))./4;
z2_f_t2=z2_f(find(f1==2),:,:)-(z2_f(find(f1==2)-2,:,:)+z2_f(find(f1==2)-1,:,:)+z2_f(find(f1==2)+1,:,:)+z2_f(find(f1==2)+2,:,:))./4;
data2(3,:)=squeeze(mean(z2_f_t2,2));
data2(4,:)=squeeze(mean(z1_f_t2,2));
data4(3,:)=squeeze(mean(z2_f_t4,2));
data4(4,:)=squeeze(mean(z1_f_t4,2));

nn=figure;subplot(1,4,3)
BSMtopo(double(mean(z1_f_t4,3)));caxis([0,0.8]);BSMtopoNoP;axis off;box off
subplot(1,4,1)
BSMtopo(double(mean(z1_f_t2,3)));caxis([0,0.3]);BSMtopoNoP;axis off;box off
subplot(1,4,4)
BSMtopo(double(mean(z2_f_t4,3)));caxis([0,0.8]);BSMtopoNoP;axis off;box off
subplot(1,4,2)
BSMtopo(double(mean(z2_f_t2,3)));caxis([0,0.3]);BSMtopoNoP;axis off;box off

%%
clearvars -except data2 data4 z_2La;
clc;
load ./DATA/Figure1-sourcedata Z1_movie Z2_movie Z3_movie Z4_movie

Z1=Z1_movie;
Z2=Z2_movie;

fs=128;
fz=fs;

L=size(Z1,1);
f=fz/L*(0:1:L-1);

L1=size(Z1,1);
f1=fz/L1*(0:1:L1-1);
L2=size(Z2,1);
f2=fz/L2*(0:1:L2-1);

for subj=1:16
    for ch=1:64
        z1_f(:,ch,subj)=abs(fft(Z1(:,ch,subj),L1)/L1*2).^2;
        z2_f(:,ch,subj)=abs(fft(Z2(:,ch,subj),L2)/L2*2).^2;
    end
end

%ɫ
yanse1=rgb2hsv([0.1 0.6 1]);
yanse2=rgb2hsv([1 0 0]);

yanse1(2)=0.3;
yanse2(2)=0.3;

yansez1=[0.8 0.8 0.8];
yansez2=hsv2rgb(yanse2);

figure(1);
subplot(3,2,3)
hold on;
line_errorbar(f1(:,:),squeeze(mean(z1_f(:,:,:),2)),[1 1 1]./255,yansez2,1);
line_errorbar(f2(:,:),squeeze(mean(z2_f(:,:,:),2)),[1 1 1],yansez1,1);
l1=plot(f1(:,:),squeeze(mean(mean(z1_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[1 0 0]);
l2=plot(f2(:,:),squeeze(mean(mean(z2_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[0 0 0]);
xlim([1 5]);
ylim([0 0.5])
set(gca,'Xtick',[1:1:5])
set(gca,'Ytick',[0:0.1:0.5])
set(gca,'LineWidth',2)

%statictical test at 2hz 4hz
peak2=2;
peak4=4;
pp3(1)=test_peak(z1_f,f1,peak2,1e4);
pp3(2)=test_peak(z2_f,f2,peak2,1e4);
pp3(3)=test_peak(z1_f,f1,peak4,1e4);
pp3(4)=test_peak(z2_f,f2,peak4,1e4);
[HP3 ZP3 PP3]=fdr_bh(pp3);

z1_f_t4=z1_f(find(f1==4),:,:)-(z1_f(find(f1==4)-2,:,:)+z1_f(find(f1==4)-1,:,:)+z1_f(find(f1==4)+1,:,:)+z1_f(find(f1==4)+2,:,:))./4;
z1_f_t2=z1_f(find(f1==2),:,:)-(z1_f(find(f1==2)-2,:,:)+z1_f(find(f1==2)-1,:,:)+z1_f(find(f1==2)+1,:,:)+z1_f(find(f1==2)+2,:,:))./4;
z2_f_t4=z2_f(find(f1==4),:,:)-(z2_f(find(f1==4)-2,:,:)+z2_f(find(f1==4)-1,:,:)+z2_f(find(f1==4)+1,:,:)+z2_f(find(f1==4)+2,:,:))./4;
z2_f_t2=z2_f(find(f1==2),:,:)-(z2_f(find(f1==2)-2,:,:)+z2_f(find(f1==2)-1,:,:)+z2_f(find(f1==2)+1,:,:)+z2_f(find(f1==2)+2,:,:))./4;
data2(5,:)=squeeze(mean(z2_f_t2,2));
data2(6,:)=squeeze(mean(z1_f_t2,2));
data4(5,:)=squeeze(mean(z2_f_t4,2));
data4(6,:)=squeeze(mean(z1_f_t4,2));


nn=figure;subplot(1,4,3)
BSMtopo(double(mean(z1_f_t4,3)));caxis([0,0.6]);BSMtopoNoP;axis off;box off
subplot(1,4,1)
BSMtopo(double(mean(z1_f_t2,3)));caxis([0,0.3]);BSMtopoNoP;axis off;box off
subplot(1,4,4)
BSMtopo(double(mean(z2_f_t4,3)));caxis([0,0.6]);BSMtopoNoP;axis off;box off
subplot(1,4,2)
BSMtopo(double(mean(z2_f_t2,3)));caxis([0,0.3]);BSMtopoNoP;axis off;box off

%%
clearvars -except data2 data4 z_2La;
clc;
load ./DATA/Figure1-sourcedata Z1_movie Z2_movie Z3_movie Z4_movie
Z1=Z1_movie;
Z3=Z3_movie;
Z4=Z4_movie;

fs=128;
fz=fs;

L1=size(Z1,1);
f1=fz/L1*(0:1:L1-1);
L2=size(Z4,1);
f2=fz/L2*(0:1:L2-1);
L3=size(Z3,1);
f3=fz/L3*(0:1:L3-1);

%power
for subj=1:16
    for ch=1:64
        z1_f(:,ch,subj)=abs(fft(Z3(:,ch,subj),L1)/L1*2).^2;
        z2_f(:,ch,subj)=abs(fft(Z4(:,ch,subj),L2)/L2*2).^2;
        z3_f(:,ch,subj)=abs(fft(Z1(:,ch,subj),L3)/L3*2).^2;
    end
end

%phase
for subj=1:16
    for ch=1:64
    z1_a(:,ch,subj)=fft(mean(Z3(:,ch,subj),2),L1)/L1*2;
    z2_a(:,ch,subj)=fft(mean(Z4(:,ch,subj),2),L2)/L2*2;
    z3_a(:,ch,subj)=fft(mean(Z1(:,ch,subj),2),L2)/L2*2;
    end
end

z_2Ma(:,:,2)=squeeze(z1_a(find(f1==2),:,:));
z_2Ma(:,:,3)=squeeze(z2_a(find(f2==2),:,:));
z_2Ma(:,:,1)=squeeze(z3_a(find(f3==2),:,:));

%COLOR
yanse1=rgb2hsv([0.1 0.6 1]);
yanse2=rgb2hsv([255 180 0]./255);
yanse3=rgb2hsv([1 0 0]);

yanse1(2)=0.3;
yanse2(2)=0.3;
yanse3(2)=0.3;

yansez1=hsv2rgb(yanse1);
yansez2=hsv2rgb(yanse2);
yansez3=hsv2rgb(yanse3);

figure(1);
subplot(3,2,4)
hold on;
line_errorbar(f3(1,:),squeeze(mean(z3_f(:,:,:),2)),[0 0 0],yansez3,1);
line_errorbar(f2(1,:),squeeze(mean(z2_f(:,:,:),2)),[1 1 1]./255,yansez2,1);
line_errorbar(f1(1,:),squeeze(mean(z1_f(:,:,:),2)),[1 1 1],yansez1,1);
l3=plot(f3(1,:),squeeze(mean(mean(z3_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[1 0 0]);
l1=plot(f2(1,:),squeeze(mean(mean(z2_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[255 180 0]./255);
l2=plot(f1(1,:),squeeze(mean(mean(z1_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[0.1 0.6 1]);
xlim([1 5]);
ylim([0 0.5])
set(gca,'Xtick',[1:1:5])
set(gca,'Ytick',[0:0.1:0.5])
set(gca,'LineWidth',2)

%statictical test at 2hz 4hz
peak2=2;
peak4=4;
pp4(1)=test_peak(z1_f,f1,peak2,1e4);
pp4(2)=test_peak(z2_f,f2,peak2,1e4);
pp4(3)=test_peak(z1_f,f1,peak4,1e4);
pp4(4)=test_peak(z2_f,f2,peak4,1e4);
[HP4 ZP4 PP4]=fdr_bh(pp4);

z1_f_t4=z1_f(find(f1==4),:,:)-(z1_f(find(f1==4)-2,:,:)+z1_f(find(f1==4)-1,:,:)+z1_f(find(f1==4)+1,:,:)+z1_f(find(f1==4)+2,:,:))./4;
z1_f_t2=z1_f(find(f1==2),:,:)-(z1_f(find(f1==2)-1,:,:)+z1_f(find(f1==2)-1,:,:)+z1_f(find(f1==2)+1,:,:)+z1_f(find(f1==2)+1,:,:))./4;
z2_f_t4=z2_f(find(f1==4),:,:)-(z2_f(find(f1==4)-2,:,:)+z2_f(find(f1==4)-1,:,:)+z2_f(find(f1==4)+1,:,:)+z2_f(find(f1==4)+2,:,:))./4;
z2_f_t2=z2_f(find(f1==2),:,:)-(z2_f(find(f1==2)-1,:,:)+z2_f(find(f1==2)-1,:,:)+z2_f(find(f1==2)+1,:,:)+z2_f(find(f1==2)+1,:,:))./4;
data2(7,:)=squeeze(mean(z2_f_t2,2));
data2(8,:)=squeeze(mean(z1_f_t2,2));
data4(7,:)=squeeze(mean(z2_f_t4,2));
data4(8,:)=squeeze(mean(z1_f_t4,2));

nn=figure;subplot(1,4,3)
BSMtopo(double(mean(z1_f_t4,3)));caxis([0,0.6]);BSMtopoNoP;axis off;box off
subplot(1,4,1)
BSMtopo(double(mean(z1_f_t2,3)));caxis([0,0.15]);BSMtopoNoP;axis off;box off
subplot(1,4,4)
BSMtopo(double(mean(z2_f_t4,3)));caxis([0,0.6]);BSMtopoNoP;axis off;box off
subplot(1,4,2)
BSMtopo(double(mean(z2_f_t2,3)));caxis([0,0.15]);BSMtopoNoP;axis off;box off

%%
clearvars -except data2 data4 z_2La z_2Ma;
clc;
load ./DATA/Figure1-sourcedata Z1_nature Z2_nature
Z1=Z1_nature;
Z2=Z2_nature;

fs=128;
fz=fs;

L1=size(Z1,1);
f1=fz/L1*(0:1:L1-1);
L2=size(Z2,1);
f2=fz/L2*(0:1:L2-1);

for subj=1:16
    for ch=1:64
    z1_f(:,ch,subj)=abs(fft(Z1(:,ch,subj),L1)/L1*2).^2;
    z2_f(:,ch,subj)=abs(fft(Z2(:,ch,subj),L2)/L2*2).^2;
    end
end

%Color
yanse1=rgb2hsv([0 0 0]);
yanse2=rgb2hsv([1 0 0]);

yanse1(2)=0.3;
yanse2(2)=0.3;

yansez1=[0.8 0.8 0.8];
yansez2=hsv2rgb(yanse2);

figure(1);
subplot(3,2,5)
hold on;
line_errorbar(f1(:,:),squeeze(mean(z1_f(:,:,:),2)),[1 1 1]./255,yansez2,1);
line_errorbar(f2(:,:),squeeze(mean(z2_f(:,:,:),2)),[1 1 1],yansez1,1);
l1=plot(f1(:,:),squeeze(mean(mean(z1_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[1 0 0]);
l2=plot(f2(:,:),squeeze(mean(mean(z2_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[0 0 0]);
xlim([1 5]);
ylim([0 0.5]);
set(gca,'Xtick',[1:1:5])
set(gca,'Ytick',[0:0.1:0.5])
set(gca,'LineWidth',2)

%statictical test at 2hz 4hz
peak2=2;
peak4=4;
pp5(1)=test_peak(z1_f,f1,peak2,1e4);
pp5(2)=test_peak(z2_f,f2,peak2,1e4);
pp5(3)=test_peak(z1_f,f1,peak4,1e4);
pp5(4)=test_peak(z2_f,f2,peak4,1e4);
[HP5 ZP5 PP5]=fdr_bh(pp5);

z1_f_t4=z1_f(find(f1==4),:,:)-(z1_f(find(f1==4)-2,:,:)+z1_f(find(f1==4)-1,:,:)+z1_f(find(f1==4)+1,:,:)+z1_f(find(f1==4)+2,:,:))./4;
z1_f_t2=z1_f(find(f1==2),:,:)-(z1_f(find(f1==2)-2,:,:)+z1_f(find(f1==2)-1,:,:)+z1_f(find(f1==2)+1,:,:)+z1_f(find(f1==2)+2,:,:))./4;
z2_f_t4=z2_f(find(f1==4),:,:)-(z2_f(find(f1==4)-2,:,:)+z2_f(find(f1==4)-1,:,:)+z2_f(find(f1==4)+1,:,:)+z2_f(find(f1==4)+2,:,:))./4;
z2_f_t2=z2_f(find(f1==2),:,:)-(z2_f(find(f1==2)-2,:,:)+z2_f(find(f1==2)-1,:,:)+z2_f(find(f1==2)+1,:,:)+z2_f(find(f1==2)+2,:,:))./4;
data2(9,:)=squeeze(mean(z2_f_t2,2));
data2(10,:)=squeeze(mean(z1_f_t2,2));
data4(9,:)=squeeze(mean(z2_f_t4,2));
data4(10,:)=squeeze(mean(z1_f_t4,2));

nn=figure;subplot(1,4,3)
BSMtopo(double(mean(z1_f_t4,3)));caxis([0,0.3]);BSMtopoNoP;colormap(autumn);axis off;box off
subplot(1,4,1)
BSMtopo(double(mean(z1_f_t2,3)));caxis([0,0.15]);BSMtopoNoP;colormap(autumn);axis off;box off
subplot(1,4,4)
BSMtopo(double(mean(z2_f_t4,3)));caxis([0,0.3]);BSMtopoNoP;colormap(autumn);axis off;box off
subplot(1,4,2)
BSMtopo(double(mean(z2_f_t2,3)));caxis([0,0.15]);BSMtopoNoP;colormap(autumn);axis off;box off

save .\DATA\Figure3-sourcedata.mat data2 data4 z_2La z_2Ma; %the generated data is used for Figure2