clear;clc;
addpath .\tool
load ./DATA/Figure4-sourcedata

L=size(z1_f,1);
fz=128;
f1=fz/L*(0:1:L-1);
f2=f1;
Bv=1e4;

%figure color
yanse1=rgb2hsv([0 255 0]./255);
yanse2=rgb2hsv([255 0 255]./255);

yanse1(2)=0.3;
yanse2(2)=0.3;

yansez1=hsv2rgb(yanse1);
yansez2=hsv2rgb(yanse2);
yansez3=[195 195 195]./255;

% amplitude1
figure(1);subplot(1,2,1);hold on;
line_errorbar(f1(1,:),squeeze(mean(z1_f(:,:,:),2)),[1 1 1]./255,yansez2,1);
line_errorbar(f2(1,:),squeeze(mean(z1_fm(:,:,:),2)),[1 1 1],yansez1,1);
l1=plot(f1(1,:),squeeze(mean(mean(z1_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[180 0 180]./255);
l2=plot(f2(1,:),squeeze(mean(mean(z1_fm(:,:,:),2),3)),'LineWidth',1.5,'Color',[0 200 0]./255);
xlim([1 5])
% legend([l1 l2],'story','movie')
xlim([1 5]);
ylim([0 0.8])
set(gca,'Xtick',[1:1:5])
set(gca,'Ytick',[0:0.2:0.8])
set(gca,'LineWidth',2)

%statictical test at 2hz 4hz
peak2=2;
peak4=4;
pp1(1)=test_peak(z1_f,f1,peak2,1e4);
pp1(2)=test_peak(z1_fm,f2,peak2,1e4);
pp1(3)=test_peak(z1_f,f1,peak4,1e4);
pp1(4)=test_peak(z1_fm,f2,peak4,1e4);
[HP1 ZP1 PP1]=fdr_bh(pp1);

%power at 2 Hz
z1_f_t4=z1_f(find(f1==4),:,:)-(z1_f(find(f1==4)-2,:,:)+z1_f(find(f1==4)-1,:,:)+z1_f(find(f1==4)+1,:,:)+z1_f(find(f1==4)+2,:,:))./4;
z1_f_t2=z1_f(find(f1==2),:,:)-(z1_f(find(f1==2)-2,:,:)+z1_f(find(f1==2)-1,:,:)+z1_f(find(f1==2)+1,:,:)+z1_f(find(f1==2)+2,:,:))./4;
z2_f_t4=z1_fm(find(f1==4),:,:)-(z1_fm(find(f1==4)-2,:,:)+z1_fm(find(f1==4)-1,:,:)+z1_fm(find(f1==4)+1,:,:)+z1_fm(find(f1==4)+2,:,:))./4;
z2_f_t2=z1_fm(find(f1==2),:,:)-(z1_fm(find(f1==2)-2,:,:)+z1_fm(find(f1==2)-1,:,:)+z1_fm(find(f1==2)+1,:,:)+z1_fm(find(f1==2)+2,:,:))./4;

%bar
zLw=squeeze(mean(z1_f_t2,2));
zMw=squeeze(mean(z2_f_t2,2));
erLw=std(zLw)/sqrt(size(zLw,1));
erMw=std(zMw)/sqrt(size(zMw,1));

%topography1
figure;subplot(1,4,1);BSMtopo(double(mean(z1_f_t2,3)));axis off;caxis([0,0.1]);BSMtopoNoP;axis off;box off
subplot(1,4,2);BSMtopo(double(mean(z2_f_t2,3)));axis off;caxis([0,0.1]);BSMtopoNoP;axis off;box off
subplot(1,4,3);BSMtopo(double(mean(z1_f_t4,3)));axis off;caxis([0,0.8]);BSMtopoNoP;axis off;box off
subplot(1,4,4);BSMtopo(double(mean(z2_f_t4,3)));axis off;caxis([0,0.8]);BSMtopoNoP;axis off;box off

%amplitude2
figure(1);subplot(1,2,2);hold on;
line_errorbar(f1(1,:),squeeze(mean(z2_f(:,:,:),2)),[1 1 1]./255,yansez2,1);
line_errorbar(f2(1,:),squeeze(mean(z2_fm(:,:,:),2)),[1 1 1],yansez1,1);
l1=plot(f1(1,:),squeeze(mean(mean(z2_f(:,:,:),2),3)),'LineWidth',1.5,'Color',[180 0 180]./255);
l2=plot(f2(1,:),squeeze(mean(mean(z2_fm(:,:,:),2),3)),'LineWidth',1.5,'Color',[0 200 0]./255);
xlim([1 5])
% legend([l1 l2],'story','movie')
xlim([1 5]);
ylim([0 0.8])
set(gca,'Xtick',[1:1:5])
set(gca,'Ytick',[0:0.2:0.8])
set(gca,'LineWidth',2)

%statictical test at 2hz 4hz
peak2=2;
peak4=4;
pp2(1)=test_peak(z2_f,f1,peak2,1e4);
pp2(2)=test_peak(z2_fm,f2,peak2,1e4);
pp2(3)=test_peak(z2_f,f1,peak4,1e4);
pp2(4)=test_peak(z2_fm,f2,peak4,1e4);
[HP2 ZP2 PP2]=fdr_bh(pp2);

%topography2
z1_f_t4=z2_f(find(f1==4),:,:)-(z2_f(find(f1==4)-2,:,:)+z2_f(find(f1==4)-1,:,:)+z2_f(find(f1==4)+1,:,:)+z2_f(find(f1==4)+2,:,:))./4;
z1_f_t2=z2_f(find(f1==2),:,:)-(z2_f(find(f1==2)-2,:,:)+z2_f(find(f1==2)-1,:,:)+z2_f(find(f1==2)+1,:,:)+z2_f(find(f1==2)+2,:,:))./4;
z2_f_t4=z2_fm(find(f1==4),:,:)-(z2_fm(find(f1==4)-2,:,:)+z2_fm(find(f1==4)-1,:,:)+z2_fm(find(f1==4)+1,:,:)+z2_fm(find(f1==4)+2,:,:))./4;
z2_f_t2=z2_fm(find(f1==2),:,:)-(z2_fm(find(f1==2)-2,:,:)+z2_fm(find(f1==2)-1,:,:)+z2_fm(find(f1==2)+1,:,:)+z2_fm(find(f1==2)+2,:,:))./4;

%bar
zLm=squeeze(mean(z1_f_t2,2));
zMm=squeeze(mean(z2_f_t2,2));
erLm=std(zLm)/sqrt(size(zLm,1));
erMm=std(zMm)/sqrt(size(zMm,1));

%topography1
figure;subplot(1,4,1);BSMtopo(double(mean(z1_f_t2,3)));axis off;caxis([0,0.1]);BSMtopoNoP;axis off;box off
subplot(1,4,2);BSMtopo(double(mean(z2_f_t2,3)));axis off;caxis([0,0.1]);BSMtopoNoP;axis off;box off
subplot(1,4,3);BSMtopo(double(mean(z1_f_t4,3)));axis off;caxis([0,0.8]);BSMtopoNoP;axis off;box off
subplot(1,4,4);BSMtopo(double(mean(z2_f_t4,3)));axis off;caxis([0,0.8]);BSMtopoNoP;axis off;box off


%%
%plot_bar
nn=figure;
plot(0:5,zeros(6),'Color',[ .23 .23 .23],'LineWidth',2);
hold on;
ba=bar(1,mean(zLw,1),0.3,'FaceColor',[255 255 255]./255,'EdgeColor',[180 0 180]./255,'LineWidth',1.5); 
errorbar(1,mean(zLw,1),erLw,'.','Color',[ .23 .23 .23],'LineWidth',1.2)
ba=bar(3.2,mean(zLm,1),0.3,'FaceColor',[255 255 255]./255,'EdgeColor',[180 0 180]./255,'LineWidth',1.5); 
errorbar(3.2,mean(zLm,1),erLm,'.','Color',[ .23 .23 .23],'LineWidth',1.2)
hold on;
ba=bar(1.8,mean(zMw,1),0.3,'FaceColor',[255 255 255]./255,'EdgeColor',[0 200 0]./255,'LineWidth',1.5); 
errorbar(1.8,mean(zMw,1),erMw,'.','Color',[ .23 .23 .23],'LineWidth',1.2)
ba=bar(4,mean(zMm,1),0.3,'FaceColor',[255 255 255]./255,'EdgeColor',[0 200 0]./255,'LineWidth',1.5); 
errorbar(4,mean(zMm,1),erMm,'.','Color',[ .23 .23 .23],'LineWidth',1.2)

set(gca,'Ytick',[0:0.1:0.2])
xlim([0 5])
ylim([0 0.2])
set(gca,'xtick',[],'xcolor','w')
set(gca,'LineWidth',2)
box off
set(nn,'position',[100 100 550 300]);

%bootstrap
p1=unpaired(zLw',zMw',Bv);%unpaired,red
p2=unpaired(zMm',zLm',Bv);
p3=paired(zLw',zLm',Bv); %paired,black
p4=paired(zMw',zMm',Bv); 
[hh zz pp]=fdr_bh([p1 p2 p3 p4]);

%Topography at 2hz
ds=squeeze(z1_f(find(f1==2),:,:)-(z1_f(find(f1==2)-2,:,:)+z1_f(find(f1==2)-1,:,:)+z1_f(find(f1==2)+1,:,:)+z1_f(find(f1==2)+2,:,:))./4);
dm=squeeze(z1_fm(find(f1==2),:,:)-(z1_fm(find(f1==2)-2,:,:)+z1_fm(find(f1==2)-1,:,:)+z1_fm(find(f1==2)+1,:,:)+z1_fm(find(f1==2)+2,:,:))./4);
bs=squeeze(z2_f(find(f1==2),:,:)-(z2_f(find(f1==2)-2,:,:)+z2_f(find(f1==2)-1,:,:)+z2_f(find(f1==2)+1,:,:)+z2_f(find(f1==2)+2,:,:))./4);
bm=squeeze(z2_fm(find(f1==2),:,:)-(z2_fm(find(f1==2)-2,:,:)+z2_fm(find(f1==2)-1,:,:)+z2_fm(find(f1==2)+1,:,:)+z2_fm(find(f1==2)+2,:,:))./4);

%difference
temp=(bs);%
%permutation test
data(:,:,1)=squeeze(ds)';%*ͨ
data(:,:,2)=squeeze(temp)';
Bv=1e4;
for ch=1:64
[O,AA(:,:,ch)]=bootstrap_for_vector_Max(Bv,0.05,@compare_power2side,squeeze(data(:,ch,:))); 
ph1(:,ch)=[sum(AA(:,1,ch)<=0)+1]/[Bv+1];
ph2(:,ch)=[sum(AA(:,2,ch)<=0)+1]/[Bv+1];

if ph1(:,ch)<=ph2(:,ch);
   ph(ch)=ph1(:,ch)*2; 
else
   ph(ch)=ph2(:,ch)*2;
end
end

[hx zx px]=fdr_bh(ph);%

ds=ds;
temp=temp;

figure;
subplot(1,2,1)
BSMtopo(double(mean(ds-temp,2)))
axis off
caxis([0,0.1]);

axis off
box off

%Topography2
clear data ph;
data(:,:,1)=squeeze(ds)';
data(:,:,2)=squeeze(temp)';
[O,AA]=bootstrap_for_vector_Max(Bv,0.05,@compare_Max,squeeze(data(:,:,:))); 
for ch=1:64
ph(:,ch)=[sum(AA(:,ch)<=0)+1]/[Bv+1];
if ph(:,ch)<=0.5
   ph(:,ch)=ph(:,ch)*2; 
else
   ph(:,ch)=(1-ph(:,ch))*2;
end
end
[hx zx px]=fdr_bh(ph);%

%zscore
ds=mean(ds,2)./max(mean(ds,2));
temp=mean(temp,2)./max(mean(temp,2));

subplot(1,2,2)
BSMtopo(double(mean(ds-temp,3)))
axis off
caxis([-0.2,0.2]);

axis off
box off