%%%%%%% SCRIPTS FOR EEG PREPROCESSING %%%%%%%%%%%%
STUDY = []; CURRENTSTUDY = 0; ALLEEG = []; EEG=[]; CURRENTSET=[];
ID = ''; %subjectID
type = ''; %Time or condition etc.
        
%% OPEN EEGLAG
[ALLEEG EEG CURRENTSET ALLCOM] = eeglab;

%--------------------------------------------------------------------------
%% LOAD EEG FILE
% loads raw bdf file with no reference
EEG = pop_biosig(['path of data file']); %Note name of file
[ALLEEG EEG CURRENTSET] = pop_newset(ALLEEG, EEG, CURRENTSET, 'setname', 'BDF file','gui','off'); 
size(EEG.event)
eeglab redraw


%% Crop data using triggers to only contain task period
EEG.event(1) = []; %= pop_editeventvals(EEG,'delete',1);
EEG.urevent(1)=[];
EEG.eventdescription(1)=[];

for i=1:length(EEG.event)
    trig(i)=EEG.event(i).latency;
end

start = trig(1); stop = trig(2);
nosamples = stop-start;
EEG.data = EEG.data(:,start:stop);
EEG.times = EEG.times(:,start:stop);
EEG.pnts = nosamples+1;
EEG.xmax = EEG.pnts/EEG.srate;
EEG = eeg_checkset( EEG );
[ALLEEG EEG] = eeg_store(ALLEEG, EEG, CURRENTSET);

eeglab redraw

%% Import channel locations
EEG=pop_chanedit(EEG, 'lookup','Paths of channel info file downloaded from www.biosemi.com');
[ALLEEG EEG] = eeg_store(ALLEEG, EEG, CURRENTSET);
EEG = eeg_checkset( EEG );
eeglab redraw

%% Select EEG channels and inspect

EEG = eeg_checkset( EEG );
EEG = pop_select( EEG,'channel',{'Fp1' 'AF7' 'AF3' 'F1' 'F3' 'F5' 'F7' 'FT7' 'FC5' 'FC3' 'FC1' 'C1' 'C3' 'C5' 'T7' 'TP7' 'CP5' 'CP3' 'CP1' 'P1' 'P3' 'P5' 'P7' 'P9' 'PO7' 'PO3' 'O1' 'Iz' 'Oz' 'POz' 'Pz' 'CPz' 'Fpz' 'Fp2' 'AF8' 'AF4' 'AFz' 'Fz' 'F2' 'F4' 'F6' 'F8' 'FT8' 'FC6' 'FC4' 'FC2' 'FCz' 'Cz' 'C2' 'C4' 'C6' 'T8' 'TP8' 'CP6' 'CP4' 'CP2' 'P2' 'P4' 'P6' 'P8' 'P10' 'PO8' 'PO4' 'O2'});
[ALLEEG EEG CURRENTSET] = pop_newset(ALLEEG, EEG, CURRENTSET,'setname','BDF file EEG','gui','off'); 
%% filter data

% filter EEG data 0.5-48 Hz. 
EEG = pop_eegfiltnew(EEG,0.5,48,13518,0,[],0);
[ALLEEG EEG CURRENTSET] = pop_newset(ALLEEG, EEG, CURRENTSET,'setname','BDF file f EEG','gui','off');
pop_eegplot( EEG, 1, 1, 1);
%eeglab redraw % 

%% Downsample 256Hz
%downsample to 256 Hz
EEG = pop_resample( EEG, 256);
[ALLEEG EEG CURRENTSET] = pop_newset(ALLEEG, EEG, CURRENTSET,'setname', 'BDF file f downsamp EEG','gui','off'); 
originalAllChan = EEG; %saves duplicate of EEG dataset to be used for interpolation

%% Rereference to average reference to visually inspect - to be used for exclusion of noisy sensors
EEG = pop_reref( EEG, [],'exclude',[]); % 
[ALLEEG EEG CURRENTSET] = pop_newset(ALLEEG, EEG, CURRENTSET,'setname','BDF file f rr','gui','off');
pop_eegplot( EEG, 1, 1, 1);

%% EXCLUDE bad channels. Exclude noisy channels from EEG. 

% remove bad channels
[ALLEEG EEG CURRENTSET] = pop_newset(ALLEEG, EEG, 5,'retrieve',4,'study',0); %Note that '4' should correspond to the downsampled, but unreferenced, dataset.
EEG = pop_select( EEG,'nochannel',{''});
[ALLEEG EEG CURRENTSET] = pop_newset(ALLEEG, EEG, CURRENTSET,'setname','BDF file f downsamp chanrem','gui','off');

%% Reference EEG to average reference (for dataset without bad channels)
% re-reference.  
EEG = pop_reref( EEG, [],'exclude',[]); % exclude noisy channels from average ref.
[ALLEEG EEG CURRENTSET] = pop_newset(ALLEEG, EEG, CURRENTSET,'setname','BDF file f downsamp chanrem rr','gui','off');
pop_eegplot( EEG, 1, 1, 1);

EEG = pop_saveset( EEG, 'filename',[ID, '_', type,'_preproc_ICAready.set'],'filepath','H:\Documents\MATLAB\Data\ARMIN\Preproc\NEW_2019Oct\Static\EMG_pre\for Coherence');
[ALLEEG EEG] = eeg_store(ALLEEG, EEG, CURRENTSET);


%% run ICA and plot decomposition
%Remove components manually using scroll component activations and reject by map
EEG = eeg_checkset( EEG );
EEG = pop_runica(EEG, 'extended',1,'interupt','on', 'pca', EEG.nbchan-1);
[ALLEEG EEG] = eeg_store(ALLEEG, EEG, CURRENTSET);
EEG = pop_saveset( EEG, 'filename',[ID, '_', type,'_preproc_ICAweighted.set'],'filepath','H:\Documents\MATLAB\Data\ARMIN\Preproc\NEW_2019Oct\Static\EMG_pre\for Coherence');
[ALLEEG EEG] = eeg_store(ALLEEG, EEG, CURRENTSET);
EEG = eeg_checkset( EEG );
pop_selectcomps(EEG, [1:30] ); 
pop_eegplot( EEG, 0, 1, 1);

eeglab redraw;
%% Remove components reflecting eye blinks, horizontal eye movements, rare events
%Remove components. Manually add numbers in squared brackets below (pop_subcomp(EEG,[],0); 
%to remove components
EEG = pop_subcomp( EEG, [] , 0);
[ALLEEG EEG CURRENTSET] = pop_newset(ALLEEG, EEG, 1,'gui','off'); 
EEG = pop_saveset( EEG, 'filename',[ID, '_', type,'_preproc_ICApruned.set'],'filepath','H:\Documents\MATLAB\Data\ARMIN\Preproc\NEW_2019Oct\Static\EMG_pre\for Coherence');
pop_eegplot( EEG, 1, 1, 1);

%% Interpolate removed channels using default 'spherical' option
EEG = pop_interp(EEG, originalAllChan.chanlocs, 'spherical');
[ALLEEG EEG CURRENTSET] = pop_newset(ALLEEG, EEG, CURRENTSET,'setname','BDF file reref filt ICA removed all chans','gui','off'); 
EEG = eeg_checkset( EEG );
EEG = pop_saveset( EEG, 'filename',[ID, '_', type,'_preproc_ICApruned_interp_EEG.set'],'filepath','H:\Documents\MATLAB\Data\ARMIN\Preproc\NEW_2019Oct\Static\EMG_pre\for Coherence');

eeglab redraw



