######################################################### SOURCE CODE FILE 3 (For FIGURE 5) ###########################################################################


# Loading in required packages

library(readxl)
library(forcats)
library(ggplot2)
library(ggpubr)
library(dplyr)
library(segmented)
library(readxl)
library(plyr)
library(caret)
library(corrplot)

# Loading in data
datCoupling <- read_excel("your file path for dataset")

## reordering factors within dataset datCoupling 

datCoupling$Group <- factor(datCoupling$Group, levels = c("G8to10", "G12to14", "G16to18","G20to30"))
datCoupling$Group <- revalue(datCoupling$Group, c("G8to10"="8 to 10", "G12to14"="12 to 14","G16to18"="16 to 18", "G20to30"="20 to 30"))

str(datCoupling)


### Forward: PMv-DLPFC

p1 <-ggscatter(datCoupling, x="Performance",y="PMv.DLPFC",  fill="Group",  palette = "lancet", shape=21,  size=3.2,  add = "reg.line",add.params= list(color="Group"),
               cor.method = "pearson", ylab="Coupling strength", ylim=c(-2,2), xlab="Precision grip performance (a.u.)", fullrange=TRUE, margin.plot="boxplot")


p1 <-p1+stat_cor(aes(color = Group), label.x = 1.5)
p1
p1bp <- ggboxplot(datCoupling, x="Group",y="PMv.DLPFC",  fill="Group", palette = "lancet", ylim=c(-2,2), width=0.1)
p1bp 

### Backward: SMA-M1


p2 <- ggscatter(datCoupling, x="Performance",y="SMA.M1",  fill="Group",  palette = "lancet", shape=21,  size=3.2,  add = "reg.line",add.params= list(color="Group"),
                cor.method = "pearson", ylab="Coupling strength", ylim=c(-2,2), xlab="Precision grip performance (a.u.)", margin.plot = "boxplot", fullrange=TRUE, )

p2<-p2 +stat_cor(aes(color = Group), label.x = 1.5)

p2bp <- ggboxplot(datCoupling, x="Group",y="SMA.M1",  fill="Group", palette = "lancet", ylim=c(-2,2), width=0.1)
p2bp 


#### Age effects: Backwards: SMA to IPL - not related to performance
p5 <- ggscatter(datCoupling, x="Performance",y="SMA.IPL",  fill="Group",  palette = "lancet", shape=21, ylim=c(-2,2), size=3.2, ylab="Coupling strength", xlab="Precision grip performance (a.u.)")
p5 

p51bp <- ggboxplot(datCoupling, x="Group",y="SMA.IPL",  fill="Group",palette = "lancet", ylim=c(-2,2), width=0.1)

p51bp


### Performance effects Forward: SPL-PMv


p3 <- ggscatter(datCoupling, x="Performance",y="IPL.PMv", color="black", fill="Group", palette="lancet", shape=21, size=2.8, 
                add = "reg.line", add.params= list(color="blue",fill="lightblue"), fullrange=TRUE,  cor.coef = FALSE, cor.coeff.args = list(method="pearson", label.sep="\n"),
                ylim = c(-2,2), ylab="Coupling strength", xlab="Precision grip performance (a.u.)", margin.plot="boxplot")
p3 <- p3 + stat_cor(aes(color = Group), label.x = 1.5)
p3
p3bp <- ggboxplot(datCoupling, x="Group",y="IPL.PMv",  fill="Group", palette = "lancet", ylim=c(-2,2), width=0.1)
p3bp


### Backwards: PMv-SPL

p4 <- ggscatter(datCoupling, x="Performance",y="PMv.IPL", color="black", fill="Group", palette="lancet", shape=21, size=2.8, 
                add = "reg.line", add.params= list(color="blue",fill="lightblue"), fullrange=TRUE,  cor.coef = FALSE, cor.coeff.args = list(method="pearson", label.sep="\n"),
                ylim = c(-2,2), ylab="datCoupling Strength", xlab="Precision grip performance (a.u.)", margin.plot="boxplot")

p4 <-p4 + stat_cor(aes(color = Group), label.x = 1.5)

p4bp <- ggboxplot(datCoupling, x="Group",y="PMv.IPL",  fill="Group", palette = "lancet", ylim=c(-2,2), width=0.1)
p4bp