######################################################### SOURCE CODE FILE 2 (For FIGURE 4) ###########################################################################

# Loading in required packages

library(readxl)
library(forcats)
library(ggplot2)
library(ggpubr)
library(dplyr)
library(segmented)
library(readxl)
library(plyr)
library(caret)
library(corrplot)

########### PEB RESULTS PLOTS - FIGURE 4 ###########

datPEB <- read_excel("your file path here")
str(datPEB)
datPEB$Group <- factor(datPEB$Group, levels = c("G8to10", "G12to14", "G16to18","G20to30"))
datPEB$Group <- revalue(datPEB$Group, c("G8to10"="8 to 10", "G12to14"="12 to 14","G16to18"="16 to 18", "G20to30"="20 to 30"))

#dat$Connection <- revalue(dat$Connection, c("(1,1)"="TEST"))
#dat$Connection <- factor(dat$Connection, levels = c("YOUNG", "MIDDLE", "OLD","ADULT"))

dat_common <- subset(datPEB, PEB.matrix=="Common")
dat_age <- subset(datPEB, PEB.matrix=="AgeGroup")
dat_performance <- subset(datPEB, PEB.matrix=="Performance")
dat_interaction <- subset(datPEB, PEB.matrix=="InterAct")

## plot commonalities

p1test <- ggplot(dat_common, aes(x=Connection_plot, y=Ep_plot, fill="PEB.matrix")) +
  geom_bar(position=position_dodge(), stat="identity", color="white") + ylim(-4,0) +
  geom_linerange(aes(ymin=Ep_plot-CI_plot, ymax=Ep_plot+CI_plot), width=.2,position=position_dodge(.1), size=2)+
  geom_hline(yintercept=0) +
  theme_classic()+theme(axis.title.x=element_blank(),axis.text.x=element_blank(),legend.position="none")

p1.1test <- p1test + scale_fill_brewer(palette="Dark2") + labs(y = "Estimate") 
p1.1test

## plot age group 

p2test <- ggplot(dat_age, aes(x=Connection_plot, y=Ep_plot, fill="PEB.matrix")) +
  geom_bar(position=position_dodge(), stat="identity", color="white")+ylim(0,2) +
  geom_linerange(aes(ymin=Ep_plot-CI_plot, ymax=Ep_plot+CI_plot), width=.2,position=position_dodge(.1), size=2)+
  geom_hline(yintercept=0)+
  theme_classic()+theme(axis.title.x=element_blank(),axis.text.x=element_blank(),legend.position="none")

p2.1test <- p2test + scale_fill_brewer(palette="Dark2") + labs(y = "Estimate")
p2.1test

## plot performance 

p3test <- ggplot(dat_performance, aes(x=Connection_plot, y=Ep_plot, fill="PEB.matrix")) +
  geom_bar(position=position_dodge(), stat="identity", color="white") + ylim(-4,4) +
  geom_linerange(aes(ymin=Ep_plot-CI_plot, ymax=Ep_plot+CI_plot), width=.2,position=position_dodge(.1), size=2)+
  geom_hline(yintercept=0) +
  theme_classic()+theme(axis.title.x=element_blank(),axis.text.x=element_blank(),legend.position="none")

p3.1test <- p3test + scale_fill_brewer(palette="Dark2") + labs(y = "Estimate")
p3.1test


## plot interaction 

p4test <- ggplot(dat_interaction, aes(x=Connection_plot, y=Ep_plot, fill="PEB.matrix")) +
  geom_bar(position=position_dodge(), stat="identity", color="white") + ylim(0,1) +
  geom_linerange(aes(ymin=Ep_plot-CI_plot, ymax=Ep_plot+CI_plot), position=position_dodge(.1), size=2)+
  geom_hline(yintercept=0) +
  theme_classic()+theme(axis.title.x=element_blank(),axis.text.x=element_blank(),legend.position="none")

p4.1test <- p4test + scale_fill_brewer(palette="Dark2") + labs(y = "Estimate")
p4.1test

# Combine figures
ggarrange(p1.1test, p2.1test, p3.1test, p4.1test, ncol=1)
