######################################################### SOURCE CODE FILE 4(For FIGURE 6) ###########################################################################


# Loading in required packages

library(readxl)
library(forcats)
library(ggplot2)
library(ggpubr)
library(dplyr)
library(segmented)
library(readxl)
library(plyr)
library(caret)
library(corrplot)

# Loading in data
datCoupling <- read_excel("C:/Users/nfx206/OneDrive/Documents/Universitetsarbejde/Projekter/2017-2019, ARMIN/Study/Paper/DCM&MotorControl/Revisions-v2/Figure 5 - source data 1.xlsx")

## reordering factors within dataset datCoupling 

datCoupling$Group <- factor(datCoupling$Group, levels = c("G8to10", "G12to14", "G16to18","G20to30"))
datCoupling$Group <- revalue(datCoupling$Group, c("G8to10"="8 to 10", "G12to14"="12 to 14","G16to18"="16 to 18", "G20to30"="20 to 30"))

str(datCoupling)

######### Cross-validation - FIGURE 6 ################

library(caret)
#Performance
set.seed(123)
train.control <- trainControl(method = "LOOCV")
model_performance <- train(Performance ~ PMv_to_DLPFC + SMA_to_IPL + SMA_to_M1 + PMv_to_IPL + IPL_to_PMv, data = datCoupling, method = "lm",
                           trControl = train.control)
print(model_performance)
summary(model_performance)

datLOOCVperformance <- model_performance$pred
datCoupling$PredPerf <- datLOOCVperformance$pred
datCoupling$RealPerf <- datLOOCVperformance$obs

pLOOCV_performance <- ggscatter(datCoupling, x="PredPerf", y="RealPerf", color="black", fill="Group", palette="lancet", shape=21, size=3.2, add = "reg.line", add.params= list(color="darkgreen",fill="forestgreen"),  cor.coef = TRUE, conf.int = TRUE, cor.coeff.args = list(method="pearson", label.sep="\n"), ylab="Observed performance (a.u.)", xlab="Predicted performance (a.u.)")
pLOOCV_performance

#Age
train.control <- trainControl(method = "LOOCV")
model_age <- train(Age ~   PMv_to_DLPFC + SMA_to_IPL + SMA_to_M1 + PMv_to_IPL + IPL_to_PMv, data = datCoupling, method = "lm",
                   trControl = train.control)

print(model_age)
summary(model_age)
datLOOCVAge <- model_age$pred

datCoupling$PredAge<- datLOOCVAge$pred
datCoupling$RealAge <- datLOOCVAge$obs

pLOOCV_Age <- ggscatter(datCoupling, x="PredAge", y="RealAge", color="black", fill="Group", palette="lancet", shape=21, size=2.8,  ylab="Observed Age (mo)", xlab="Predicted Age (mo)")
pLOOCV_Age

## Classifier analysis using quadriatic districimant analysis

set.seed(123)
train.control <- trainControl(method = "LOOCV")

qda_fit <- train(Group ~ PMv_to_DLPFC + SMA_to_IPL + SMA_to_M1 + PMv_to_IPL + IPL_to_PMv, data = datCoupling, method = "qda",
                 trControl = train.control)
print(qda_fit)

datLOOCVgroup <- qda_fit$pred

datCoupling$PredGroup<- datLOOCVgroup$pred
datCoupling$RealGroup <- datLOOCVgroup$obs

#creating confusion matrix
confusionMatrix(datCoupling$PredGroup,datCoupling$RealGroup)

#creating figure
table(datCoupling$PredGroup,datCoupling$RealGroup)
corrplot(table(datCoupling$PredGroup,datCoupling$Group), is.corr = FALSE, method="color", addCoef.col="darkgrey",tl.col="black", cl.lim=c(0,30))
datCoupling$PredRight<- datCoupling$PredGroup == datCoupling$RealGroup

datcorrqda <- matrix(c(7/22,10/19,1/19,0/21,
                       11/22,5/19,3/19,1/21,
                       4/22,3/19,10/19,5/28,
                       0/21,1/19,5/19,22/28),ncol=4,byrow=TRUE)

rownames(datcorrqda)=c("8 to 10","12 to 14","16 to 18","20 to 30")
colnames(datcorrqda)=c("8 to 10","12 to 14","16 to 18","20 to 30")
colorlist <- colorRampPalette(c("white", "white", "white", "#E5F5E0", "#A1D99B" ,
                                "#238B45", "forestgreen"))

confusionqda <- corrplot(round(datcorrqda,2), is.corr = FALSE, method="color",addCoef.col = "black", tl.col="black", cl.lim=c(0,1), col=colorlist(100))
