# Analysis code used in LiCre paper Duplus et al. 2021

This code was developed by the team of Gael Yvert at Laboratory of Biology and Modelling of the Cell, ENS de Lyon and CNRS, France. It is provided as a supplement of the following publication:

>A single-chain and fast-responding light-inducible Cre recombinase as a novel optogenetic switch

The code allows to analyse raw flow-cytometry experiments, in order to count cells (either yeast of human) that express GFP or mCherry or both.

## Analysis code organization

- The analysis code is organized in several main files, all located in the [src/](src) directory.
- Directory [data/](data) should be organized by dates. This repository does not contain the data but only specific comments regarding the dataset. The dataset itself can be retrieved from [Biostudies](https://www.ebi.ac.uk/biostudies/) under accession number `S-BSST580`.
- Several configuration files are needed for some of the scripts. Directory [results/2020-12-03/](results/2020-12-03) contains these configuration files (.conf extension).

## How to run an analysis on raw data

Here is an example to run one of the Sweave scripts (Sweave scripts are ended by a .Rnw extension):

First, go to a subdirectory of the results/ folder. For example:
```sh
cd ./results/2020-12-03/
```

Then copy the script in this subdirectory:
```sh
cp ../../src/proc_conditions_PAUL.Rnw .
```

And run it, preferentially in the background using nohup so that you can close your ssh connexion while it runs.
```sh
nohup bash ../../src/Sweave.sh -ld -nc proc_conditions_PAUL.Rnw &
```

A number of `.pdf` files are produced, that either contain one figure or the whole analysis. In addition, two directories are produced that store results files:

- `outputs/` , which contains per-sample summaries such as the number of green cells. 
- `plots/` , which contains.... plots.

