#######################################################################

sem = function(x) return(sd(x)/sqrt(length(x)))

#######################################################################

barplot.these <- function(x, variants = c("none", "WT"), conditions = c("dark", "light"), ylim = NULL){
   sx = subset(x, variant %in% variants & condition %in% conditions)
   sx$variant   = as.factor(sx$variant)
   sx$condition = as.factor(sx$condition)
   sx$meanEff = ave(sx$efficiency, sx$variant, sx$condition, FUN = mean)
   sx$sdEff   = ave(sx$efficiency, sx$variant, sx$condition, FUN = sd)
   sx$nObs    = ave(sx$efficiency, sx$variant, sx$condition, FUN = length)
   sx$sem = sx$sdEff/sqrt(sx$nObs)
   pdwidth = 0.7

   p <- ggplot(sx, aes(x=variant, y=efficiency, fill=condition, colour = condition))            +
        theme(panel.grid.major.x = element_blank(),panel.grid.minor.x = element_blank()) + 
        scale_x_discrete(limits = variants)                             +
        scale_fill_manual(values = c("darkgrey", "cyan"))               +
        scale_colour_manual(values = c("black", "blue"))               +

        stat_summary(fun.y=mean, geom="bar", width = 0.5, position= position_dodge(width=pdwidth)) +

        geom_errorbar(aes(ymin=meanEff-sem,ymax=meanEff+sem), width = 0.2, position = position_dodge(pdwidth)) +

        geom_jitter(shape = 1, size = 2, position = position_dodge(width=pdwidth))

   if (!is.null(ylim))
      p = p +  scale_y_continuous(limits = ylim)

   return(p)
}

#######################################################################

barplot.intensities <- function(x, cons = "WT", conditions = c("dark", "light"), intensities = NULL, ylim = NULL){
   sx = subset(x, construct %in% cons & condition %in% conditions)
   if(!is.null(intensities))
      sx = subset(sx, illumination.intensity.percent %in% intensities)
   sx$condition = as.factor(sx$condition)
   sx$intensity = as.factor(sx$illumination.intensity.percent)
   sx$meanEff = ave(sx$efficiency, sx$condition, sx$intensity, FUN = mean)
   sx$sem  = ave(sx$efficiency, sx$condition, sx$intensity, FUN = sem)
   
   pdwidth = 0.7

   p <- ggplot(sx, aes(x=intensity, y=efficiency, fill=condition, colour = condition))            +
         theme(panel.grid.major.x = element_blank(),panel.grid.minor.x = element_blank()) + 
         #scale_x_discrete(limits = intensity)                             +
         scale_fill_manual(values = c("darkgrey", "cyan"))               +
         scale_colour_manual(values = c("black", "blue"))               +
         stat_summary(fun.y=mean, geom="bar", width = 0.5, position= position_dodge(width=pdwidth)) +

         geom_errorbar(aes(ymin=meanEff-sem,ymax=meanEff+sem), width = 0.2, position = position_dodge(pdwidth)) +
         geom_jitter(shape = 1, size = 2, position = position_dodge(width=pdwidth))

    if (!is.null(ylim))
      p = p +  scale_y_continuous(limits = ylim)

   return(p)
}

###########################################################################

barplot.durations <- function(x, cons = "WT", conditions = c("dark", "light"), durations = NULL, ylim = NULL){
   sx = subset(x, construct %in% cons & condition %in% conditions)
   if(!is.null(durations))
      sx = subset(sx, illumination.duration.min %in% durations)
   sx$condition = as.factor(sx$condition)
   sx$duration  = as.factor(sx$illumination.duration.min)
   sx$meanEff   = ave(sx$efficiency, sx$condition, sx$duration, FUN = mean)
   sx$sem       = ave(sx$efficiency, sx$condition, sx$duration, FUN = sem)
   
   pdwidth = 0.7

   p <- ggplot(sx, aes(x=duration, y=efficiency, fill=condition, colour = condition))            +
         theme(panel.grid.major.x = element_blank(),panel.grid.minor.x = element_blank()) + 
         scale_fill_manual(values = c("darkgrey", "cyan"))               +
         scale_colour_manual(values = c("black", "blue"))               +
         stat_summary(fun.y=mean, geom="bar", width = 0.5, position= position_dodge(width=pdwidth)) +

         geom_errorbar(aes(ymin=meanEff-sem,ymax=meanEff+sem), width = 0.2, position = position_dodge(pdwidth)) +
         geom_jitter(shape = 1, size = 2, position = position_dodge(width=pdwidth))

   if (!is.null(ylim))
      p = p +  scale_y_continuous(limits = ylim)
   return(p)
}

###########################################################################

barplot.background <- function(x, ylim = NULL){
   sx = x
   sx$construct = as.factor(sx$construct)
   sx$meanEff   = ave(sx$efficiency, sx$construct, FUN = mean)
   sx$sem       = ave(sx$efficiency, sx$construct, FUN = sem)
   
   pdwidth = 0.7

   p <- ggplot(sx, aes(x=construct, y=efficiency))            +
         theme(panel.grid.major.x = element_blank(),panel.grid.minor.x = element_blank()) + 
         #scale_x_discrete(limits = intensity)                             +
         #geom_bar(width = 0.5, position= position_dodge(width=pdwidth), stat = "identity", colour = "black") +
         stat_summary(fun.y=mean, geom="bar", width = 0.5, position= position_dodge(width=pdwidth)) +

         scale_fill_manual(values = c("darkgrey"))               +
         geom_errorbar(aes(ymin=meanEff-sem,ymax=meanEff+sem), width = 0.2, position = position_dodge(pdwidth)) +
         geom_jitter(shape = 1, size = 2, position = position_dodge(width=pdwidth))

 
   if (!is.null(ylim))
      p = p +  scale_y_continuous(limits = ylim)

   return(p)
}

#######################################################################

barplot.twocol <- function(x, conditions = c("dark", "light"), ylim = NULL){
   sx = subset(x, condition %in% conditions)
   sx$type   = as.factor(sx$type)
   sx$condition = as.factor(sx$condition)
   sx$meanFrac = ave(sx$fraction, sx$type, sx$condition, FUN = mean)
   sx$sem      = ave(sx$fraction, sx$type, sx$condition, FUN = sem)

   pdwidth = 0.7

   p <- ggplot(sx, aes(x=type, y=fraction, fill=condition, colour = condition))            +
        theme(panel.grid.major.x = element_blank(),panel.grid.minor.x = element_blank()) + 
        scale_fill_manual(values = c("darkgrey", "cyan"))               +
        scale_colour_manual(values = c("black", "blue"))               +

        stat_summary(fun.y=mean, geom="bar", width = 0.5, position= position_dodge(width=pdwidth)) +

        geom_errorbar(aes(ymin=meanFrac-sem,ymax=meanFrac+sem), width = 0.2, position = position_dodge(pdwidth)) +

        geom_jitter(shape = 1, size = 2, position = position_dodge(width=pdwidth))

   if (!is.null(ylim))
      p = p +  scale_y_continuous(limits = ylim)

   return(p)
}

###########################################################################

barplot.lenti <- function(x, conditions = c("dark", "light"), ylim = NULL){
   sx = subset(x, condition %in% conditions)
   sx$condition = as.factor(sx$condition)
   sx$construct.Cre = as.factor(sx$construct.Cre)
   sx$meanEff   = ave(sx$efficiency, sx$construct.Cre, sx$condition, FUN = mean)
   sx$sem       = ave(sx$efficiency, sx$construct.Cre, sx$condition, FUN = sem)

   pdwidth = 0.7

   p <- ggplot(sx, aes(x=construct.Cre, y=efficiency, fill=condition, colour = condition))            +
         theme(panel.grid.major.x = element_blank(),panel.grid.minor.x = element_blank()) + 
         scale_fill_manual(values = c("darkgrey", "cyan"))               +
         scale_colour_manual(values = c("black", "blue"))               +
         stat_summary(fun.y=mean, geom="bar", width = 0.5, position= position_dodge(width=pdwidth)) +

         geom_errorbar(aes(ymin=meanEff-sem,ymax=meanEff+sem), width = 0.2, position = position_dodge(pdwidth)) +
         geom_jitter(shape = 1, size = 2, position = position_dodge(width=pdwidth))

   if (!is.null(ylim))
      p = p +  scale_y_continuous(limits = ylim)
   return(p)
}

