rm(list=ls())
library(ggplot2)
source("../../src/barplots.with.dots.R")

for (subdir in c("figs/")){ 
  if (! (subdir %in% dir()) ) system(paste("mkdir -p ", subdir, sep = " "));
};


#######################################################################

res0 = read.table("outputs/2018-07-18_efficiencies_0.txt", header =TRUE, sep = "\t")
res1 = read.table("outputs/20160301_efficiencies_1.txt", header =TRUE, sep = "\t")
res2 = read.table("outputs/20160115_efficiencies_2.txt", header =TRUE, sep = "\t")
res3 = read.table("outputs/20160122_efficiencies_3.txt", header =TRUE, sep = "\t")
res4 = read.table("outputs/2018-07-20_efficiencies_4.txt", header =TRUE, sep = "\t")
res6 = read.table("outputs/2018-09-20_efficiencies_6.txt", header =TRUE, sep = "\t")
res7 = read.table("outputs/2018-10-04_efficiencies_7.txt", header =TRUE, sep = "\t")
res8 = read.table("outputs/2018-10-15_efficiencies_8.txt", header =TRUE, sep = "\t")
res.sato   = read.table("outputs/2019-01-24_efficiencies_sato.txt", header =TRUE, sep = "\t")
res.tucker = read.table("outputs/2019-01-29_efficiencies_tuck.txt", header =TRUE, sep = "\t")
#res.twocol = read.table("outputs/towcolors-counts.txt", header =TRUE, sep = "\t")

###########

pdf(file = "figs/bp_a.pdf")
print(barplot.these(res0, variants = c("empty", "CreWT", "CreAA", "CreWT_Delta37", "CreAA_Delta37"), conditions = c("dark")))
dev.off()

pdf(file = "figs/bp_b.pdf", width = 11.25, height = 4.95)
print(barplot.these(res1, variants = c("none", "WT", "Cdel2", "Cdel3", "Cdel4", "Cdel6", "Cdel8", "Cdel10", "Cdel12", "Cdel14", "CreAA", "Ndel2-21", "Ndel2-28", "Ndel2-37", "AA_Ndel2-21", "AA_Ndel2-28", "AA_Ndel2-37"), conditions = c("dark")))
dev.off()

required.fields = c("variant", "condition", "efficiency")
i0 = which(res0$variant %in% c("none", "CreWT", "CreAA", "CreAA_Delta37") )
j0 = which(names(res0) %in% required.fields)
these0 = res0[i0,j0]
i1 = which(res1$variant %in% c("WT", "Cdel2", "Cdel3", "Cdel4", "Cdel6", "Cdel8", "Cdel10", "Cdel12", "Cdel14", "Ndel2-21", "Ndel2-28", "Ndel2-37", "AA_Ndel2-21", "AA_Ndel2-28"))
j1 = which(names(res1) %in% required.fields)
these1 = res1[i1,j1]
dat = rbind(these0, these1)


pdf(file = "figs/bp_c.pdf", width = 6.2, height = 3.8)
print(barplot.these(dat, variants = c("CreWT", "CreAA", "Ndel2-21", "Ndel2-28", "Ndel2-37", "AA_Ndel2-21", "AA_Ndel2-28", "CreAA_Delta37"), conditions = c("dark")))
dev.off()

### Fig S1 ###
pdf(file = "figs/bp_d.pdf")
print(barplot.these(res1, variants = c("none", "WT", "CreVVD", "CreAA_VVD_0Linker", "CreAA_VVD_Linker2aa", "CreAA_VVD", "CreAD_VVD", "CreAR_VVD", "CreEA_VVD", "CreRA_VVD", "CreRR_VVD" ), conditions = c("dark", "light")))
dev.off()

### Fig S2a ###
pdf(file = "figs/bp_e.pdf")
print(barplot.these(res2, variants = c("314", "CreWT", "408", "iLID_Cre17", "iLID_Cre19", "iLID_Cre20", "iLID_Cre21", "iLID_Cre22", "iLID_Cre23", "iLID_Cre24","iLID_Cre25", "iLID_Cre26", "iLID_Cre27", "iLID_Cre29", "iLID_Cre32"), conditions = c("dark", "light")))
dev.off()

### Fig S2b ###
pdf(file = "figs/bp_f.pdf")
print(barplot.these(res2, variants = c("314", "CreAA", "iLID_CreAA17", "iLID_CreAA19", "iLID_CreAA20", "iLID_CreAA21", "iLID_CreAA22", "iLID_CreAA23", "iLID_CreAA24","iLID_CreAA25", "iLID_CreAA26", "iLID_CreAA27", "iLID_CreAA29", "iLID_CreAA32"), conditions = c("dark", "light")))
dev.off()

### Fig 2a ###
pdf(file = "figs/bp_g.pdf", width = 7.7, height = 3.8)
print(barplot.these(res3, variants = c("314", "CreWT", "iLID_Cre17B", "iLID_Cre19B", "iLID_Cre27B", "iLID_Cre32B" ), conditions = c("dark", "light")))
dev.off()

### Fig 2c ###
pdf(file = "figs/bp_h.pdf", width = 10.71, height = 6.3)
print(barplot.these(res4, variants = c("Neg", "WT", "iLID_CreAA20", "iLID_CreAA21", "iLID_CreAA22"), conditions = c("dark", "light")))
dev.off()

### Fig 2b ###
pdf(file = "figs/bp_i.pdf", width = 14.2, height = 3.8)
print(barplot.these(res4, variants = c("Neg", "WT", "iLID_Cre32",  "24F", "24I", "25C", "25F", "25X", "26R"), conditions = c("dark", "light")))
dev.off()

######################################################

pdf(file = "figs/bp_j.pdf", width = 10.1, height = 5.2)
print(barplot.intensities(res6, cons = "CreAA20", conditions = c("dark", "light"), ylim = c(0,0.7)))
dev.off()

pdf(file = "figs/bp_k.pdf")
print(barplot.intensities(res7, cons = "CreAA20", conditions = c("dark", "light")))
dev.off()

pdf(file = "figs/bp_l.pdf")
print(barplot.intensities(res7, cons = "Cre32", conditions = c("dark", "light")))
dev.off()

pdf(file = "figs/bp_m.pdf")
print(barplot.intensities(res7, cons = "WT", conditions = c("dark", "light")))
dev.off()

pdf(file = "figs/bp_n.pdf")
print(barplot.intensities(res7, cons = "Neg", conditions = c("dark", "light")))
dev.off()

######################################################

pdf(file = "figs/bp_o.pdf")
print(barplot.durations(res8, cons = "CreAA20", conditions = c("dark", "light"), ylim = c(0,0.7)))
dev.off()

pdf(file = "figs/bp_p.pdf")
print(barplot.durations(res8, cons = "Cre32", conditions = c("dark", "light")))
dev.off()

pdf(file = "figs/bp_q.pdf")
print(barplot.durations(res8, cons = "WT", conditions = c("dark", "light")))
dev.off()

pdf(file = "figs/bp_r.pdf")
print(barplot.durations(res8, cons = "Neg", conditions = c("dark", "light")))
dev.off()


#######################################################
df = subset(res8, construct %in% c("Neg", "CreAA20", "Cre32") & condition == "dark")

pdf(file = "figs/bp_s.pdf")
print(barplot.background(df, ylim = c(0,0.7)))
dev.off()

#######################################################
# subset on MagCre and Neg
df = subset(res.sato, construct %in% c("Neg", "Mag_Cre"))
# discard MagCre under 100% illumination (suboptimal)
df = subset(df, !(construct == "Mag_Cre" & (condition == "light" & illumination.intensity.percent == 100)))
# discard Neg and light (we don't need it)
df = subset(df, !(construct == "Neg" & condition == "light")) 

# add in group 'dark' the samples that were not illuminated (duration = 0)
df$condition[ df$illumination.duration.min == 0 ] <- "dark"

# set duration = -1 (which will create a separate category) for Neg & Dark control
df$illumination.duration.min[ df$condition == "dark" & df$construct == "Neg" ] <- -1
pdf(file = "figs/bp_t.pdf", width = 5.43, height = 5.44)
print(barplot.durations(df, cons = c("Mag_Cre", "Neg"), ylim = c(0, 0.7)))
dev.off()

##############################################################"
# subset on CIB1CRYCre and Neg
df = subset(res.tucker, construct %in% c("Neg", "CIB1_CRY2"))
# discard Neg and light (we don't need it)
#df = subset(df, !(construct == "Neg" & condition == "light")) 
df$variant = df$construct

pdf(file = "figs/bp_u.pdf", width = 7.5, height = 5.4)
print(barplot.these(df, variants = c("Neg", "CIB1_CRY2"), ylim = c(0,0.7) ))
dev.off()


##############################################################
#constr = "AA20"
#metconc = 0

#x = subset(res.twocol, construct == constr & methionine.conc == metconc)
#x$P.red             = (x$n.redonly + x$n.redandgreen)/x$n.total
#x$P.red.given.green = x$n.redandgreen / (x$n.redandgreen + x$n.greenonly)
#x$P.green           = (x$n.greenonly + x$n.redandgreen)/x$n.total
#x$P.green.given.red = x$n.redandgreen / (x$n.redandgreen + x$n.redonly)
#x$P.red.and.green   = x$n.redandgreen / x$n.total
#x$condition = as.character(x$condition)
#n = dim(x)[1]
#init = rep(NA, times = n*5)
#df = data.frame(fraction = init, type = init, condition =init)
#d = 1
#for (i in 1:dim(x)[1]){
#  {
#  df$fraction[d]  = x$P.green[i]
#  df$condition[d] = x$condition[i]
#  df$type[d]     = "G"
#  d = d + 1;
# }
#  {
#  df$fraction[d]  = x$P.red[i]
#  df$condition[d] = x$condition[i]
#  df$type[d]     = "R"
#  d = d + 1;
#  }
# {
#  df$fraction[d]  = x$P.green.given.red[i]
#  df$condition[d] = x$condition[i]
#  df$type[d]     = "GinR"
#  d = d + 1;
#  }
#  {
#  df$fraction[d]  = x$P.red.given.green[i]
#  df$condition[d] = x$condition[i]
#  df$type[d]     = "RinG"
#  d = d + 1;
#  }
#  {
#  df$fraction[d]  = x$P.red.and.green[i]
#  df$condition[d] = x$condition[i]
#  df$type[d]     = "RandG"
#  d = d + 1;
#  }
#}

#pdf(file = "figs/v.pdf", width = 7.5, height = 5.4)
#print(barplot.twocol(df))
#dev.off()
