rm(list=ls())

library(ggplot2)

for (subdir in c("figs/")){ 
  if (! (subdir %in% dir()) ) system(paste("mkdir -p ", subdir, sep = " "));
};

x <- read.table("../../data/2019-05-17/dosage.txt", sep = "\t", dec = ",", header = TRUE)

sem <-function(x) return( sd(x)/sqrt(length(x)) )
x$mean = ave(x$ug.per.g, x$condition, FUN = mean)
x$sem  = ave(x$ug.per.g, x$condition, FUN = sem)

pdwidth = 0.7

p <- ggplot(x, aes(x=condition, y=ug.per.g) )+
        theme(panel.grid.major.x = element_blank(),panel.grid.minor.x = element_blank()) + 
        scale_x_discrete()                             +
        stat_summary(fun.y=mean, geom="bar", width = 0.5, position= position_dodge(width=pdwidth)) +

        geom_errorbar(aes(ymin=mean-sem,ymax=mean+sem), width = 0.2, position = position_dodge(pdwidth)) +

        geom_jitter(shape = 1, size = 2, position = position_dodge(width=pdwidth))

print(p)

pdf(file = "figs/crtDosage.pdf")
print(p)
dev.off()


