######################
#
# Plot efficiencies of 
# LiCre, MagCre and CRY/CIBCre
# illuminated at various intensities
# continuous light
# under DMX LED spot
#
########################

library(ggplot2)

for (subdir in c("figs/")){ 
  if (! (subdir %in% dir()) ) system(paste("mkdir -p ", subdir, sep = " "));
};

# standard error of the mean
sem = function(x) return(sd(x)/sqrt(length(x)))

# read data
res = read.table("outputs/intensities_spot_twocolors-counts.txt", header =TRUE, sep = "\t")

# remove one data point (see justification in data/2020-10-16/comments.txt)
i = which(res$date == "2020-10-16" & res$name == "PL1.0006.fcs")
res = res[-i,]

# remove negative and positive controls used to set fluo thresholds
res = subset(res, !(construct %in% c("Cre", "Neg")))

# fix ambiguity about positive intensity and zero duration
res$illumination.intensity[ res$illumination.duration.min == 0 ] <- 0;
# fix ambiguity about dark controls
res$illumination.intensity[ res$condition == "dark" ] <- 0;

# We distinguish dark controls on the plot
# by assigning them artificial intensity values
#res$illumination.intensity[ res$illumination.intensity == 0 & res$construct == "Mag_Cre"] <- 1.8;
#res$illumination.intensity[ res$illumination.intensity == 0 & res$construct == "CIB1_CRY2"] <- 2;
#res$illumination.intensity[ res$illumination.intensity == 0 & res$construct == "LiCre"] <- 2.2;


#plot
pdf(file = "figs/intensities_spot_light.pdf")
ymax = 0.25
sx = subset(res, illumination.intensity != 0)

sx$meanEff   = ave(sx$f.RED, sx$construct, sx$illumination.intensity, FUN = mean)
sx$sem       = ave(sx$f.RED, sx$construct, sx$illumination.intensity, FUN = sem)

p = ggplot( sx, aes(x=illumination.intensity, y = f.RED, colour = construct)) +
       theme(panel.grid.major.x = element_blank(),panel.grid.minor.x = element_blank()) +
       scale_colour_manual(values = c("green", "blue", "magenta")) +
       stat_summary(fun.y=mean, geom = "line", position= "identity") +
       geom_errorbar(aes(ymin=meanEff-sem,ymax=meanEff+sem), width = 0.05, position = "identity") +
       geom_jitter(shape = 1, size = 1, position = "identity") +
       ylim(0,ymax) +
       theme(panel.grid.major.x = element_line(colour = "white")) +
       scale_x_log10(breaks = c(5,10,15,30,45,130,255)) +
       ggtitle("intensities on DMX spot, during 30 minutes")
print(p)
dev.off()

#plot values of dark controls
sx = subset(res, illumination.intensity == 0)

sx$meanEff   = ave(sx$f.RED, sx$construct, FUN = mean)
sx$sem       = ave(sx$f.RED, sx$construct, FUN = sem)


pdf(file = "figs/intensities_spot_dark.pdf")

p = ggplot( sx, aes(x=construct, y = f.RED, colour = construct, fill = construct)) +
       theme(panel.grid.major.x = element_blank(),panel.grid.minor.x = element_blank()) +
       scale_colour_manual(values = c("green", "blue", "magenta")) +
       stat_summary(fun.y=mean, geom = "bar", width = 0.2, position= "identity") +
       scale_fill_manual(values = c("green", "blue", "magenta")) +
       geom_errorbar(aes(ymin=meanEff-sem,ymax=meanEff+sem), width = 0.05, position = "identity") +
       geom_jitter(shape = 1, size = 1, position = "identity") +
       ylim(0,ymax) +
       ggtitle("dark controls in parallel of intensities on DMX spot, during 30 minutes")
print(p)
dev.off()
