######################
#
# Plot efficiencies of 
# LiCre and MagCre
# transduced by lentirial vectors
# into human cells,
# illuminated at two intensities
# continuous light
# in the PAUL apparatus
#
########################

rm(list = ls())
library(ggplot2)
source("../../src/barplots.with.dots.R")


for (subdir in c("figs/")){ 
  if (! (subdir %in% dir()) ) system(paste("mkdir -p ", subdir, sep = " "));
};

# standard error of the mean
sem = function(x) return(sd(x)/sqrt(length(x)))

ylim = c(0,0.9);

# read data 10% PAUL intensity
res1 = read.table("outputs/2020-10-09_lenti-counts.txt", header =TRUE, sep = "\t")

pdf(file = "figs/lenti1.pdf");
p = barplot.lenti(res1, ylim = ylim);
print(p);
dev.off()

# read data 5% PAUL intensity
res2 = read.table("outputs/2020-11-18_lenti-counts.txt", header =TRUE, sep = "\t")
res3 = read.table("outputs/2020-11-22_lenti-counts.txt", header =TRUE, sep = "\t")
x = rbind(res2,res3)
pdf(file = "figs/lenti2.pdf")
p = barplot.lenti(x, ylim = ylim);
print(p);
dev.off()

