(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     33783,        699]
NotebookOptionsPosition[     33398,        682]
NotebookOutlinePosition[     33838,        700]
CellTagsIndexPosition[     33795,        697]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Program", " ", "to", " ", "plot", " ", "simulation", " ", "data", " ", 
    "as", " ", "a", " ", "movie"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"By", " ", "Koichiro", " ", "Uriu"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", "\"\<workingdirectory/\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", "=", "25"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "=", "60"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Lx", "=", 
     RowBox[{"300", "+", "r", "+", "R"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Ly", "=", 
     RowBox[{
      RowBox[{"2", "*", "R"}], "+", 
      RowBox[{"2", " ", "r"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Lz", "=", 
     RowBox[{"2", " ", "r"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Lxmin", "=", 
     RowBox[{"-", "400"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sLy", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rc", "=", "11"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dt", "=", "1.0"}], ";", 
    RowBox[{"pr", "=", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numcell", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"\"\<cell_number.dat\>\"", ",", "Number"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numacell", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"\"\<arrested_cell_number.dat\>\"", ",", "Number"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"\"\<cell_position.dat\>\"", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"Number", ",", 
         RowBox[{"{", "3", "}"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sa", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"\"\<somite_shapes_DAPT.dat\>\"", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"Number", ",", 
         RowBox[{"{", "4", "}"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"imax", "=", 
    RowBox[{"Length", "[", "numcell", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ip", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"\"\<intensity.dat\>\"", ",", "Number"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lxa", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"\"\<PSM_length.dat\>\"", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"Number", ",", 
         RowBox[{"{", "3", "}"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.703920673283646*^9, 3.703920706483222*^9}, {
   3.704405301160741*^9, 3.704405363047023*^9}, {3.704405470761257*^9, 
   3.704405470912669*^9}, {3.704406090617378*^9, 3.704406091392035*^9}, {
   3.7044107476586533`*^9, 3.704410748503662*^9}, {3.704410863422865*^9, 
   3.704410864526165*^9}, {3.704410954036009*^9, 3.704410954572073*^9}, {
   3.704426683054594*^9, 3.7044266833535357`*^9}, {3.704427425608712*^9, 
   3.704427428413403*^9}, 3.7044307646398573`*^9, {3.7044309947204723`*^9, 
   3.704431007141247*^9}, {3.704431097035046*^9, 3.704431104655798*^9}, {
   3.704435095959976*^9, 3.7044351044133387`*^9}, {3.7045004940113*^9, 
   3.70450065221852*^9}, {3.704500697396883*^9, 3.70450069774885*^9}, {
   3.704518037399036*^9, 3.7045180642302713`*^9}, {3.704586341102112*^9, 
   3.704586413249288*^9}, {3.704586484359621*^9, 3.704586486223095*^9}, {
   3.7045867195756807`*^9, 3.704586729461708*^9}, {3.704586765974702*^9, 
   3.704586766077856*^9}, {3.704586805553935*^9, 3.704586840806858*^9}, {
   3.7045869046062727`*^9, 3.704586905508686*^9}, {3.704586941824033*^9, 
   3.704586941894245*^9}, {3.7045871120628138`*^9, 3.704587112116466*^9}, {
   3.704587205012644*^9, 3.704587205175975*^9}, {3.7045873648874397`*^9, 
   3.7045873670219593`*^9}, {3.704587422970582*^9, 3.7045874255478067`*^9}, {
   3.704587463086788*^9, 3.704587489796281*^9}, {3.7045875247260017`*^9, 
   3.7045875248142548`*^9}, {3.704587580821725*^9, 3.704587591818203*^9}, 
   3.704592327602709*^9, {3.704667773794339*^9, 3.704667809406713*^9}, {
   3.704667892975109*^9, 3.704667893021975*^9}, {3.704668054954771*^9, 
   3.7046680557616873`*^9}, {3.704668128320279*^9, 3.7046681286148243`*^9}, {
   3.705213321951838*^9, 3.705213365652173*^9}, {3.705375868919729*^9, 
   3.7053758870259733`*^9}, {3.705376938791834*^9, 3.7053769539017057`*^9}, {
   3.70537838959379*^9, 3.705378395639983*^9}, {3.7053790120820513`*^9, 
   3.705379020069265*^9}, {3.705387521469584*^9, 3.705387537959099*^9}, {
   3.7053892023898*^9, 3.7053892072202473`*^9}, {3.705466503353541*^9, 
   3.705466520078533*^9}, {3.7059821369214*^9, 3.70598215100105*^9}, {
   3.7060392000959272`*^9, 3.706039214575514*^9}, {3.706042170244268*^9, 
   3.706042170371561*^9}, {3.7060923148751163`*^9, 3.7060923149499617`*^9}, {
   3.706247344147008*^9, 3.706247364643654*^9}, {3.706247770059724*^9, 
   3.70624777459238*^9}, {3.706248173953136*^9, 3.706248178788083*^9}, {
   3.706253911590864*^9, 3.706253939113308*^9}, {3.706254657545512*^9, 
   3.7062546636727457`*^9}, {3.7062555517304707`*^9, 3.706255558701723*^9}, {
   3.706302562875277*^9, 3.706302589745586*^9}, 3.706303544496977*^9, {
   3.706323524842416*^9, 3.706323546226411*^9}, 3.706324184872366*^9, {
   3.706329602440035*^9, 3.706329624450658*^9}, 3.7063303715429697`*^9, {
   3.706346542040739*^9, 3.7063465539528103`*^9}, {3.7063861258736763`*^9, 
   3.706386136865041*^9}, {3.706405886876423*^9, 3.7064059127741528`*^9}, {
   3.706589026542453*^9, 3.706589050204616*^9}, {3.706589095494876*^9, 
   3.7065891142309217`*^9}, {3.706589444544633*^9, 3.706589463635991*^9}, {
   3.706589513328561*^9, 3.7065895134327307`*^9}, {3.7119405303291397`*^9, 
   3.711940677878326*^9}, {3.7119518013525887`*^9, 3.71195181431802*^9}, {
   3.7119549247056103`*^9, 3.711954924826499*^9}, {3.7122676664726353`*^9, 
   3.7122676806964197`*^9}, 3.71226778993108*^9, {3.712271571774209*^9, 
   3.712271571859798*^9}, {3.712274889145397*^9, 3.712274889279498*^9}, {
   3.712277021172448*^9, 3.712277021288993*^9}, {3.712280745984377*^9, 
   3.712280758771165*^9}, {3.7122830230438223`*^9, 3.712283023121327*^9}, {
   3.71228743645403*^9, 3.712287436512496*^9}, {3.712299605403466*^9, 
   3.712299605509444*^9}, {3.7124722462538767`*^9, 3.712472260237338*^9}, {
   3.716789145820435*^9, 3.716789152077888*^9}, {3.71678919068154*^9, 
   3.716789202460031*^9}, {3.7167905020178337`*^9, 3.716790502102792*^9}, 
   3.716797710157032*^9, {3.716797746295144*^9, 3.716797755931469*^9}, {
   3.716840608562188*^9, 3.7168406092103043`*^9}, {3.716938014233706*^9, 
   3.716938032255313*^9}, {3.717918998767316*^9, 3.717919039229629*^9}, {
   3.717963836982017*^9, 3.7179638501188507`*^9}, {3.717965574815255*^9, 
   3.7179655758477917`*^9}, {3.717983266369795*^9, 3.717983292617855*^9}, {
   3.7179936412647142`*^9, 3.717993646322002*^9}, {3.718050603285183*^9, 
   3.718050615353627*^9}, {3.720901793866767*^9, 3.7209018435852613`*^9}, {
   3.7209046327543163`*^9, 3.7209046333768253`*^9}, {3.7209080267495117`*^9, 
   3.720908026866946*^9}, {3.720913061728396*^9, 3.720913061871291*^9}, {
   3.72352898764128*^9, 3.723529004954317*^9}, {3.723611163021386*^9, 
   3.72361117484627*^9}, {3.723613659876006*^9, 3.723613663398428*^9}, {
   3.72401278022536*^9, 3.724012787622881*^9}, {3.724097412280192*^9, 
   3.724097436304018*^9}, {3.724359124206932*^9, 3.72435915453691*^9}, {
   3.725691482892036*^9, 3.725691486966195*^9}, {3.725695457903104*^9, 
   3.72569545798934*^9}, {3.725743822480618*^9, 3.7257438225313807`*^9}, {
   3.726030111950693*^9, 3.726030115611569*^9}, {3.7261061795946302`*^9, 
   3.7261061901091557`*^9}, {3.726108550262426*^9, 3.726108550396886*^9}, {
   3.726110464204671*^9, 3.726110464303087*^9}, {3.7261123190415907`*^9, 
   3.726112320640448*^9}, {3.726113889930244*^9, 3.726113895397612*^9}, {
   3.726172853382867*^9, 3.7261728554644613`*^9}, {3.726176181734234*^9, 
   3.726176185798531*^9}, {3.726180633321288*^9, 3.726180633399515*^9}, {
   3.726182145992787*^9, 3.726182146068861*^9}, {3.7261841549525642`*^9, 
   3.726184155039381*^9}, {3.726186008991439*^9, 3.726186009093403*^9}, {
   3.726191135975182*^9, 3.7261911399477*^9}, {3.7262010169217567`*^9, 
   3.726201017040803*^9}, {3.726210408330871*^9, 3.7262104202754593`*^9}, {
   3.726558356772596*^9, 3.726558360605424*^9}, {3.727229898432433*^9, 
   3.72722991798637*^9}, {3.7272314579189587`*^9, 3.727231458005089*^9}, {
   3.727496328094639*^9, 3.7274963320701447`*^9}, {3.727497728982697*^9, 
   3.727497729312704*^9}, {3.727506202097249*^9, 3.727506205733532*^9}, {
   3.727552305597982*^9, 3.727552305651626*^9}, {3.7280227515376987`*^9, 
   3.7280227560768337`*^9}, {3.729392720317572*^9, 3.7293927250160427`*^9}, {
   3.7293947349890757`*^9, 3.729394737645631*^9}, {3.729395879505795*^9, 
   3.729395881535923*^9}, {3.72965182271117*^9, 3.729651833605033*^9}, {
   3.729839007454425*^9, 3.729839010945903*^9}, {3.730787138731825*^9, 
   3.730787151946203*^9}, {3.730787202468416*^9, 3.730787240649241*^9}, {
   3.7307879796343822`*^9, 3.7307879865604362`*^9}, {3.7307880386227417`*^9, 
   3.730788043779945*^9}, {3.730789234349172*^9, 3.7307892622178383`*^9}, {
   3.730839259373493*^9, 3.73083926471867*^9}, {3.730845546442474*^9, 
   3.730845546494235*^9}, {3.730851017140698*^9, 3.730851017829234*^9}, {
   3.7308608822281637`*^9, 3.7308608878261223`*^9}, {3.730864722726239*^9, 
   3.730864722853656*^9}, {3.731120373531827*^9, 3.7311203786689043`*^9}, {
   3.731125090292468*^9, 3.731125097888785*^9}, {3.731125229316622*^9, 
   3.731125240409545*^9}, {3.731125329675758*^9, 3.731125329808957*^9}, {
   3.731130424161895*^9, 3.731130434215446*^9}, {3.731134972585685*^9, 
   3.731134978140918*^9}, {3.734931271700179*^9, 3.734931276068318*^9}, {
   3.735503574029861*^9, 3.735503584556199*^9}, {3.735510092058712*^9, 
   3.735510092119583*^9}, {3.735517789053938*^9, 3.735517790225954*^9}, {
   3.735530291203121*^9, 3.735530299321939*^9}, {3.735536577411789*^9, 
   3.7355365775187263`*^9}, {3.736669474045006*^9, 3.7366694741575317`*^9}, {
   3.736842653166233*^9, 3.736842658635126*^9}, {3.737942417744257*^9, 
   3.737942432420617*^9}, {3.738293821048374*^9, 3.738293824746828*^9}, {
   3.73829660292419*^9, 3.738296608531225*^9}, {3.738483589124914*^9, 
   3.738483640547782*^9}, {3.738564613164298*^9, 3.73856462703329*^9}, 
   3.738645773320778*^9, {3.741584908214065*^9, 3.741584916378437*^9}, {
   3.7419069241776953`*^9, 3.7419069285977583`*^9}, {3.743738794991715*^9, 
   3.743738800717389*^9}, {3.74935820497342*^9, 3.749358210151409*^9}, {
   3.749365492848604*^9, 3.749365496900237*^9}, {3.751686616384536*^9, 
   3.751686624535948*^9}, {3.7516917743283567`*^9, 3.751691779936936*^9}, {
   3.751768321489254*^9, 3.751768397684683*^9}, {3.751769454137388*^9, 
   3.751769460254484*^9}, {3.751771995697542*^9, 3.751771996983522*^9}, {
   3.7517732865775347`*^9, 3.7517733039631767`*^9}, {3.7520074998778343`*^9, 
   3.7520075083107243`*^9}, {3.7520256184965487`*^9, 3.75202562356854*^9}, {
   3.752028692673464*^9, 3.7520286927656603`*^9}, {3.7520301647173862`*^9, 
   3.752030164774255*^9}, {3.75203320025366*^9, 3.7520332052990417`*^9}, {
   3.7520383653715267`*^9, 3.752038369571344*^9}, {3.753598529020533*^9, 
   3.7535985312765007`*^9}, {3.753598582365746*^9, 3.75359859230501*^9}, {
   3.7554875742647667`*^9, 3.755487586759004*^9}, {3.758682909784191*^9, 
   3.758682916131467*^9}, {3.761978816735999*^9, 3.7619788727183123`*^9}, {
   3.761979047376135*^9, 3.761979047474677*^9}, {3.76249595328701*^9, 
   3.762495962073234*^9}, {3.762496014043589*^9, 3.762496018033041*^9}, {
   3.762500021106018*^9, 3.762500025609543*^9}, {3.762666562877146*^9, 
   3.7626665985523453`*^9}, {3.7627545532352448`*^9, 
   3.7627545664936743`*^9}, {3.762759570302849*^9, 3.762759570369903*^9}, {
   3.7639582006163197`*^9, 3.763958227406419*^9}, {3.7639583077138147`*^9, 
   3.763958307788516*^9}, {3.763959246950807*^9, 3.763959247048671*^9}, {
   3.764017660112452*^9, 3.764017665799149*^9}, {3.764919108674973*^9, 
   3.764919112972473*^9}, {3.768354949648149*^9, 3.768354961280251*^9}, {
   3.7683550073668833`*^9, 3.768355007471191*^9}, {3.770689629941777*^9, 
   3.7706896306763887`*^9}, {3.7706896867614727`*^9, 
   3.7706896961551027`*^9}, {3.77145163275456*^9, 3.771451660230836*^9}, 
   3.7714589225945053`*^9, {3.77301038804705*^9, 3.7730103936419783`*^9}, {
   3.773790117600127*^9, 3.7737901378584003`*^9}, {3.774162285713202*^9, 
   3.774162306085084*^9}, {3.7741624149093027`*^9, 3.7741624407499847`*^9}, {
   3.774219053998129*^9, 3.774219057695283*^9}, {3.774225818637005*^9, 
   3.774225822408486*^9}, {3.7947984758718987`*^9, 3.794798480414722*^9}, {
   3.794811793057312*^9, 3.794811839851343*^9}, {3.805060161855652*^9, 
   3.8050602055385323`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"anime", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", "0"}], ";", 
    RowBox[{"g", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ims", "=", 
     RowBox[{"{", 
      RowBox[{"600", ",", "300"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eps", "=", "15"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xpinset", "=", "0.92"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", "imax"}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"t", "=", 
        RowBox[{"dt", "*", 
         RowBox[{"(", 
          RowBox[{"i", "-", "1"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", "\[Equal]", "1"}], ",", 
         RowBox[{
          RowBox[{"b", "=", 
           RowBox[{"Take", "[", 
            RowBox[{"a", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{
               "numcell", "\[LeftDoubleBracket]", "1", 
                "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], ";"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"b", "=", 
          RowBox[{"Take", "[", 
           RowBox[{"a", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"f", "+", "1"}], ",", 
              RowBox[{"f", "+", 
               RowBox[{
               "numcell", "\[LeftDoubleBracket]", "i", 
                "\[RightDoubleBracket]"}]}]}], "}"}]}], "]"}]}]}], "]"}], ";",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", "\[Equal]", "1"}], ",", 
         RowBox[{
          RowBox[{"ipc", "=", 
           RowBox[{"Take", "[", 
            RowBox[{"ip", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{
               "numcell", "\[LeftDoubleBracket]", "1", 
                "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], ";"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ipc", "=", 
          RowBox[{"Take", "[", 
           RowBox[{"ip", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"f", "+", "1"}], ",", 
              RowBox[{"f", "+", 
               RowBox[{
               "numcell", "\[LeftDoubleBracket]", "i", 
                "\[RightDoubleBracket]"}]}]}], "}"}]}], "]"}]}]}], "]"}], ";",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", "\[GreaterEqual]", "2"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"i", "\[Equal]", "2"}], ",", 
            RowBox[{
             RowBox[{"sipc", "=", 
              RowBox[{"Take", "[", 
               RowBox[{"sa", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{
                  "numacell", "\[LeftDoubleBracket]", "1", 
                   "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], ";"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"sipc", "=", 
             RowBox[{"Take", "[", 
              RowBox[{"sa", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"g", "+", "1"}], ",", 
                 RowBox[{"g", "+", 
                  RowBox[{"numacell", "\[LeftDoubleBracket]", 
                   RowBox[{"i", "-", "1"}], "\[RightDoubleBracket]"}]}]}], 
                "}"}]}], "]"}]}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"nb", "=", 
        RowBox[{"Length", "[", "b", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"pp", "=", 
        RowBox[{"{", "}"}]}], ";", 
       RowBox[{"cc", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"j", "=", "1"}], ",", 
         RowBox[{"j", "\[LessEqual]", "nb"}], ",", 
         RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"x", "=", 
           RowBox[{
            RowBox[{
            "b", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
            "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";", 
          RowBox[{"y", "=", 
           RowBox[{
            RowBox[{
            "b", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
            "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], ";", 
          RowBox[{"z", "=", 
           RowBox[{
            RowBox[{
            "b", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
            "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"pp", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"ColorData", "[", "\"\<LakeColors\>\"", "]"}], "[", 
               RowBox[{
               "ipc", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
               "]"}], ",", 
              RowBox[{"Sphere", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
                RowBox[{"rc", "/", "2"}]}], "]"}]}], "}"}]}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", "\[GreaterEqual]", "2"}], ",", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"j", "=", "1"}], ",", 
            RowBox[{"j", "\[LessEqual]", 
             RowBox[{"numacell", "\[LeftDoubleBracket]", 
              RowBox[{"i", "-", "1"}], "\[RightDoubleBracket]"}]}], ",", 
            RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"x", "=", 
              RowBox[{
               RowBox[{
               "sipc", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}],
                "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";", 
             RowBox[{"y", "=", 
              RowBox[{
               RowBox[{
               "sipc", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}],
                "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], ";", 
             RowBox[{"z", "=", 
              RowBox[{
               RowBox[{
               "sipc", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}],
                "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], ";",
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"AppendTo", "[", 
              RowBox[{"cc", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<LakeColors\>\"", "]"}], "[", 
                  
                  RowBox[{
                   RowBox[{
                   "sipc", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "4", 
                   "\[RightDoubleBracket]"}], "]"}], ",", 
                 RowBox[{"Sphere", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
                   RowBox[{"rc", "/", "2"}]}], "]"}]}], "}"}]}], "]"}], 
             ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"g3", "=", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{"{", 
          RowBox[{"Black", ",", "Thick", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "lxa", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], ",", "0", ",", "Lz"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "lxa", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], ",", 
                RowBox[{"Ly", "+", "sLy"}], ",", "Lz"}], "}"}]}], "}"}], 
            "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "cc", "]"}], ">", "0"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"g1", "=", 
           RowBox[{"Graphics3D", "[", 
            RowBox[{"pp", ",", "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Lxmin", "-", "5"}], ",", 
                  RowBox[{"Lx", "+", "5"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5"}], ",", 
                  RowBox[{"Ly", "+", "sLy"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5"}], ",", 
                  RowBox[{"Lz", "+", "5"}]}], "}"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ImageSize", "\[Rule]", "ims"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ViewPoint", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "Infinity"}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Epilog", "\[Rule]", 
              RowBox[{"Inset", "[", 
               RowBox[{
                RowBox[{"Framed", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{
                    RowBox[{"\"\<t = \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{"t", ",", "pr"}], "]"}], "]"}]}], ",", "eps"}], 
                   "]"}], ",", 
                  RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}], 
                ",", 
                RowBox[{"Scaled", "[", 
                 RowBox[{"{", 
                  RowBox[{"xpinset", ",", "1.15"}], "}"}], "]"}]}], "]"}]}]}],
             "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"g2", "=", 
           RowBox[{"Graphics3D", "[", 
            RowBox[{"cc", ",", "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Lxmin", "-", "5"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5"}], ",", 
                  RowBox[{"Ly", "+", "sLy"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5"}], ",", 
                  RowBox[{"Lz", "+", "5"}]}], "}"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ViewPoint", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "Infinity"}], "}"}]}]}], 
            "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"anime", "=", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"anime", ",", 
             RowBox[{"Show", "[", 
              RowBox[{"g1", ",", "g2", ",", "g3"}], "]"}]}], "]"}]}], ";"}], 
         ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"g1", "=", 
           RowBox[{"Graphics3D", "[", 
            RowBox[{"pp", ",", "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Lxmin", "-", "5"}], ",", 
                  RowBox[{"Lx", "+", "5"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5"}], ",", 
                  RowBox[{"Ly", "+", "sLy"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5"}], ",", 
                  RowBox[{"Lz", "+", "5"}]}], "}"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ImageSize", "\[Rule]", "ims"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ViewPoint", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "Infinity"}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Epilog", "\[Rule]", 
              RowBox[{"Inset", "[", 
               RowBox[{
                RowBox[{"Framed", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{
                    RowBox[{"\"\<t = \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{"t", ",", "pr"}], "]"}], "]"}]}], ",", "eps"}], 
                   "]"}], ",", 
                  RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}], 
                ",", 
                RowBox[{"Scaled", "[", 
                 RowBox[{"{", 
                  RowBox[{"xpinset", ",", "1.15"}], "}"}], "]"}]}], "]"}]}]}],
             "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"anime", "=", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"anime", ",", 
             RowBox[{"Show", "[", 
              RowBox[{"g1", ",", "g3"}], "]"}]}], "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"f", "=", 
        RowBox[{"f", "+", 
         RowBox[{
         "numcell", "\[LeftDoubleBracket]", "i", 
          "\[RightDoubleBracket]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", "\[GreaterEqual]", "2"}], ",", 
         RowBox[{"g", "=", 
          RowBox[{"g", "+", 
           RowBox[{"numacell", "\[LeftDoubleBracket]", 
            RowBox[{"i", "-", "1"}], "\[RightDoubleBracket]"}]}]}]}], "]"}], 
       ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<psm_movie.gif\>\"", ",", "anime", ",", "\"\<GIF\>\""}], 
     "]"}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7119406071924763`*^9, 3.711940607496125*^9}, {
   3.7119407239515133`*^9, 3.7119408517705812`*^9}, 3.711940904670251*^9, {
   3.711951847654667*^9, 3.7119518483135767`*^9}, {3.7167892602044373`*^9, 
   3.71678929789434*^9}, {3.7307873023909273`*^9, 3.730787483190967*^9}, {
   3.730787587685697*^9, 3.73078761620152*^9}, {3.730787667413306*^9, 
   3.730787748452395*^9}, {3.730787790614608*^9, 3.730787928554783*^9}, {
   3.7307880528733263`*^9, 3.7307880561404877`*^9}, {3.73078820887187*^9, 
   3.730788208961885*^9}, {3.73078846392636*^9, 3.730788464027338*^9}, {
   3.730788584283951*^9, 3.730788585460422*^9}, {3.730788706577065*^9, 
   3.730788718115994*^9}, {3.7307887497494373`*^9, 3.730788749857551*^9}, {
   3.7307888792255487`*^9, 3.7307888802478657`*^9}, {3.730788999532391*^9, 
   3.730789003643022*^9}, {3.7307893032237453`*^9, 3.730789463025485*^9}, 
   3.730789570242571*^9, {3.730789603938645*^9, 3.7307896048801823`*^9}, {
   3.730789684995022*^9, 3.730789690817301*^9}, {3.73112511845348*^9, 
   3.731125164632586*^9}, {3.7311252527180758`*^9, 3.731125266549459*^9}, {
   3.731125364552409*^9, 3.7311253699531803`*^9}, {3.73550343187367*^9, 
   3.73550349257023*^9}, {3.737942453558653*^9, 3.737942455396989*^9}, {
   3.737943016387793*^9, 3.7379430221310463`*^9}, {3.737943082346897*^9, 
   3.737943126889291*^9}, {3.737943204762352*^9, 3.737943211093266*^9}, {
   3.7379432514986553`*^9, 3.737943255915564*^9}, {3.738483649462187*^9, 
   3.738483678779788*^9}, {3.738483803774714*^9, 3.738483811359066*^9}, {
   3.741584934066373*^9, 3.74158496184342*^9}, {3.742015946934917*^9, 
   3.742015977865835*^9}, {3.742016150867385*^9, 3.742016159213122*^9}, {
   3.742017900448421*^9, 3.742017925324443*^9}, {3.7437388531562233`*^9, 
   3.743738856937243*^9}, {3.749358226239401*^9, 3.749358236641753*^9}, {
   3.749358278107562*^9, 3.749358282968956*^9}, {3.75168666017805*^9, 
   3.7516866886586113`*^9}, {3.7516917972007723`*^9, 
   3.7516918011616793`*^9}, {3.752007541174778*^9, 3.752007546563645*^9}, {
   3.75359861831421*^9, 3.7535986466808968`*^9}, {3.755487628343976*^9, 
   3.755487656559889*^9}, {3.75868293217248*^9, 3.75868297026722*^9}, {
   3.761978888537286*^9, 3.761978890622748*^9}, {3.761979018551176*^9, 
   3.76197901992805*^9}, {3.7619790940965033`*^9, 3.761979099221319*^9}, {
   3.7624959800483713`*^9, 3.762495982437065*^9}, {3.762496058853018*^9, 
   3.762496061869474*^9}, {3.762666619147485*^9, 3.762666653268791*^9}, {
   3.76275459008883*^9, 3.762754617678838*^9}, {3.763958239247081*^9, 
   3.763958241453309*^9}, {3.763958418259018*^9, 3.763958491106061*^9}, {
   3.763958526504189*^9, 3.763958541660718*^9}, {3.763958651080677*^9, 
   3.763958777039307*^9}, {3.7639588368292*^9, 3.763958837710832*^9}, 
   3.763958887350024*^9, {3.763958944799659*^9, 3.7639589489865828`*^9}, {
   3.763958982312573*^9, 3.763958983364696*^9}, {3.76395901700878*^9, 
   3.763959048291924*^9}, {3.763959143552279*^9, 3.7639591758190937`*^9}, {
   3.763959209370418*^9, 3.763959222588524*^9}, {3.7639592826038*^9, 
   3.763959402635639*^9}, {3.7639594804948587`*^9, 3.763959483645269*^9}, {
   3.764919136332479*^9, 3.764919168463162*^9}, {3.7683549727875137`*^9, 
   3.76835497471535*^9}, {3.768355035900455*^9, 3.768355041017712*^9}, {
   3.7706897254720078`*^9, 3.770689751976788*^9}, {3.7714516775429907`*^9, 
   3.771451704023263*^9}, {3.773010409818736*^9, 3.773010410688425*^9}, {
   3.773790149693017*^9, 3.7737901502445793`*^9}, {3.773790309709804*^9, 
   3.77379038567476*^9}, {3.773790473475374*^9, 3.773790485050755*^9}, {
   3.773790536409639*^9, 3.773790536512763*^9}, {3.773796213232411*^9, 
   3.773796213296749*^9}, {3.774162377663191*^9, 3.774162393273614*^9}, {
   3.774162470007484*^9, 3.774162514987537*^9}, {3.774219084878105*^9, 
   3.774219127814039*^9}, {3.7742255758130293`*^9, 3.774225584326593*^9}, {
   3.794798492416026*^9, 3.794798542754778*^9}, {3.7948118526302433`*^9, 
   3.794811897872528*^9}}]
},
EvaluationCompletionAction->"ShowTiming",
WindowSize->{1009, 552},
WindowMargins->{{121, Automatic}, {Automatic, 40}},
Magnification:>1.5 Inherited,
FrontEndVersion->"10.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (2014\:5e7412\
\:67084\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 13360, 226, 794, "Input"],
Cell[13921, 248, 19473, 432, 2244, "Input"]
}
]
*)

