(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     89630,       1787]
NotebookOptionsPosition[     89172,       1765]
NotebookOutlinePosition[     89570,       1782]
CellTagsIndexPosition[     89527,       1779]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Program", " ", "to", " ", "detect", " ", "FRS", " ", "and", " ", "PLD", 
    " ", "in", " ", "simulation", " ", "data"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"By", " ", "Koichiro", " ", "Uriu"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", "\"\<workingdirectory\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dt", "=", "1.0"}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{"time", " ", "step"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"pr", "=", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tm", "=", "991"}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{"length", " ", "of", " ", "data"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Tp", "=", "30"}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{"period", " ", "of", " ", "oscillation"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"maxsegnum", "=", 
     RowBox[{"Floor", "[", 
      RowBox[{"tm", "/", "Tp"}], "]"}]}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{"maximum", " ", "segment", " ", "number"}], " ", "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Zc", "=", "0.85"}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{"threshold", " ", "for", " ", "order", " ", "parameter"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Lambda]", "=", 
     RowBox[{"Tp", "/", "2"}]}], ";", 
    RowBox[{"\[Eta]", "=", "4"}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{
     "parameters", " ", "for", " ", "determining", " ", "normal", " ", 
      "segments"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Theta]", "=", "0.75"}], ";", 
    RowBox[{"\[CapitalDelta]", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ald", "=", "9"}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"we", " ", "check", " ", "left"}], "-", 
      RowBox[{
      "right", " ", "difference", " ", "from", " ", "segment", " ", "9"}]}], 
     " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"aldi", "=", 
     RowBox[{"Round", "[", "ald", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Z", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"\"\<anterior_phase_order_DAPT.dat\>\"", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"Number", ",", 
         RowBox[{"{", "6", "}"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Zt", "=", 
     RowBox[{"Transpose", "[", "Z", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Zr", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Zt", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{
        "Zt", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], "}"}],
       "]"}]}], ";", 
    RowBox[{"Zr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{"Zr", ",", "tm"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Zl", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Zt", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{
        "Zt", "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}]}], "}"}],
       "]"}]}], ";", 
    RowBox[{"Zl", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{"Zl", ",", "tm"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Psi]r", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Zt", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{
         RowBox[{"Zt", "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}],
          "/", 
         RowBox[{"(", 
          RowBox[{"2", " ", "Pi"}], ")"}]}]}], "}"}], "]"}]}], ";", 
    RowBox[{"\[Psi]r", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{"\[Psi]r", ",", "tm"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Psi]l", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Zt", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{
         RowBox[{"Zt", "\[LeftDoubleBracket]", "6", "\[RightDoubleBracket]"}],
          "/", 
         RowBox[{"(", 
          RowBox[{"2", " ", "Pi"}], ")"}]}]}], "}"}], "]"}]}], ";", 
    RowBox[{"\[Psi]l", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{"\[Psi]l", ",", "tm"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"imax", "=", 
    RowBox[{"Length", "[", "Zr", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"===", "===", 
      RowBox[{"\[Equal]", " ", 
       RowBox[{"function", " ", "for", " ", "FRS", " ", "calculation"}]}], 
      " ", "===", "===", "==="}], "="}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"frsfunc", "[", 
      RowBox[{"\[CurlyPhi]_", ",", "\[Zeta]_", ",", "i_"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "t", ",", "ts", ",", "xs", ",", "\[Tau]", ",", "tl", ",", "xl", ",", 
         "tsl", ",", "flag", ",", "tb", ",", "te", ",", "sx", ",", "sr", ",", 
         "sn", ",", "\[Alpha]", ",", "\[Beta]"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sn", "=", 
         RowBox[{"Floor", "[", 
          RowBox[{"tm", "/", "Tp"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"t", "=", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{"Tp", "/", "2"}], "]"}], "+", "1"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"t", "<", 
           RowBox[{"tm", "-", "1"}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Theta]", ">=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                "\[RightDoubleBracket]"}]}], "&&", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                 RowBox[{"t", "+", "1"}], "\[RightDoubleBracket]"}], 
                "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ">", 
               "\[Theta]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"ts", "=", "t"}], ";", 
              RowBox[{"xs", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                "\[RightDoubleBracket]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"tl", "=", 
               RowBox[{"t", "+", "1"}]}], ";", 
              RowBox[{"xl", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                 RowBox[{"t", "+", "1"}], "\[RightDoubleBracket]"}], 
                "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";",
               "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"\[Alpha]", "=", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"t", "+", "1"}], "\[RightDoubleBracket]"}], 
                   "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                  "-", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                   "\[RightDoubleBracket]"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"xl", "-", "xs"}], ")"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"\[Beta]", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                  "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                   "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], "-", 
                RowBox[{"\[Alpha]", " ", "xs"}]}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"tsl", "=", 
               RowBox[{"Round", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ts", "+", "tl"}], ")"}], "/", "2"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"flag", "=", "1"}], ";", "\[IndentingNewLine]", 
              RowBox[{"tb", "=", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{"tsl", "-", "\[Lambda]"}], ",", "1"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"te", "=", 
               RowBox[{"Min", "[", 
                RowBox[{
                 RowBox[{"tsl", "-", "\[Lambda]", "+", "\[Eta]"}], ",", 
                 "tm"}], "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"te", "<", "1"}], ",", 
                RowBox[{
                 RowBox[{"te", "=", "1"}], ";"}]}], "]"}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"\[Tau]", "=", "tb"}], ",", 
                RowBox[{"\[Tau]", "\[LessEqual]", "te"}], ",", 
                RowBox[{"\[Tau]", "++"}], ",", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "\[Zeta]", "\[LeftDoubleBracket]", "i", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "\[Tau]", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "<", "Zc"}], ",", 
                   RowBox[{
                    RowBox[{"flag", "=", "0"}], ";", 
                    RowBox[{"Break", "[", "]"}], ";"}]}], "]"}], ";"}]}], 
               "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"flag", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"sx", "=", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"\[Theta]", "-", "\[Beta]"}], ")"}], "/", 
                   "\[Alpha]"}]}], ";", 
                 RowBox[{"sr", "=", 
                  RowBox[{"Round", "[", "sx", "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"sr", "-", "sx"}], ">", "\[CapitalDelta]"}], ",", 
                   
                   RowBox[{
                    RowBox[{"sn", "=", 
                    RowBox[{"sr", "-", "1"}]}], ";"}], ",", 
                   RowBox[{
                    RowBox[{"sn", "=", "sr"}], ";"}]}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Break", "[", "]"}], ";"}]}], "\[IndentingNewLine]", 
               "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"t", "=", 
               RowBox[{"tl", "+", 
                RowBox[{"Round", "[", 
                 RowBox[{"Tp", "/", "3"}], "]"}]}]}], ";"}]}], 
            "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"t", "=", 
            RowBox[{"t", "+", "1"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", "sn"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"===", "===", 
      RowBox[{"\[Equal]", " ", 
       RowBox[{
       "function", " ", "for", " ", "approximate", " ", "PLD", " ", 
        "calculation"}]}], " ", "===", "===", "==="}], "="}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pldfunc", "[", 
      RowBox[{"\[CurlyPhi]_", ",", "\[Zeta]_", ",", "i_"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "t", ",", "tp", ",", "ts", ",", "xs", ",", "tl", ",", "\[Tau]", ",", 
         "xl", ",", "tsl", ",", "sx", ",", "sr", ",", "sn", ",", "\[Alpha]", 
         ",", "\[Beta]", ",", "flag", ",", "tb", ",", "te"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"t", "=", "tm"}], ",", 
          RowBox[{"t", "\[GreaterEqual]", "1"}], ",", 
          RowBox[{"t", "=", 
           RowBox[{"t", "-", "1"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                "\[Zeta]", "\[LeftDoubleBracket]", "i", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}], "<", "Zc"}], ",", 
             RowBox[{
              RowBox[{"tp", "=", "t"}], ";", 
              RowBox[{"Break", "[", "]"}], ";"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"t", "=", "tp"}], ";", "\[IndentingNewLine]", 
        RowBox[{"sn", "=", 
         RowBox[{"Floor", "[", 
          RowBox[{"tm", "/", "Tp"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"t", "<", 
           RowBox[{"tm", "-", "1"}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Theta]", "\[GreaterEqual]", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                "\[RightDoubleBracket]"}]}], "&&", 
              RowBox[{"\[Theta]", "<", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                 RowBox[{"t", "+", "1"}], "\[RightDoubleBracket]"}], 
                "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"ts", "=", "t"}], ";", 
              RowBox[{"xs", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                "\[RightDoubleBracket]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"tl", "=", 
               RowBox[{"t", "+", "1"}]}], ";", 
              RowBox[{"xl", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                 RowBox[{"t", "+", "1"}], "\[RightDoubleBracket]"}], 
                "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";",
               "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"\[Alpha]", "=", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"t", "+", "1"}], "\[RightDoubleBracket]"}], 
                   "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                  "-", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                   "\[RightDoubleBracket]"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"xl", "-", "xs"}], ")"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"\[Beta]", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                  "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                   "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], "-", 
                RowBox[{"\[Alpha]", " ", "xs"}]}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"tsl", "=", 
               RowBox[{"Round", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ts", "+", "tl"}], ")"}], "/", "2"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"flag", "=", "1"}], ";", "\[IndentingNewLine]", 
              RowBox[{"tb", "=", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{"tsl", "-", "\[Lambda]"}], ",", "1"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"te", "=", 
               RowBox[{"Min", "[", 
                RowBox[{
                 RowBox[{"tsl", "-", "\[Lambda]", "+", "\[Eta]"}], ",", 
                 "tm"}], "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"te", "<", "1"}], ",", 
                RowBox[{
                 RowBox[{"te", "=", "1"}], ";"}]}], "]"}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"\[Tau]", "=", "tb"}], ",", 
                RowBox[{"\[Tau]", "\[LessEqual]", "te"}], ",", 
                RowBox[{"\[Tau]", "++"}], ",", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "\[Zeta]", "\[LeftDoubleBracket]", "i", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "\[Tau]", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "<", "Zc"}], ",", 
                   RowBox[{
                    RowBox[{"flag", "=", "0"}], ";", 
                    RowBox[{"Break", "[", "]"}], ";"}]}], "]"}], ";"}]}], 
               "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"flag", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"sx", "=", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"\[Theta]", "-", "\[Beta]"}], ")"}], "/", 
                   "\[Alpha]"}]}], ";", 
                 RowBox[{"sr", "=", 
                  RowBox[{"Round", "[", "sx", "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"sr", "-", "sx"}], ">", "\[CapitalDelta]"}], ",", 
                   
                   RowBox[{
                    RowBox[{"sn", "=", 
                    RowBox[{"sr", "-", "1"}]}], ";"}], ",", 
                   RowBox[{
                    RowBox[{"sn", "=", "sr"}], ";"}]}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Break", "[", "]"}], ";"}]}], "\[IndentingNewLine]", 
               "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"t", "=", 
               RowBox[{"tl", "+", 
                RowBox[{"Round", "[", 
                 RowBox[{"Tp", "/", "3"}], "]"}]}]}], ";"}]}], 
            "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"t", "=", 
            RowBox[{"t", "+", "1"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", "sn"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"===", "===", "===", 
         RowBox[{"==", " ", 
          RowBox[{
          "function", " ", "for", " ", "determining", " ", "correct"}]}]}], 
        "&"}], "defective", " ", "segment"}], " ", "===", "===", "==="}], "=",
      "==="}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"segtypefunc", "[", 
      RowBox[{
      "\[CurlyPhi]_", ",", "\[Zeta]_", ",", "i_", ",", "rl_", ",", "pld_"}], 
      "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "t", ",", "ts", ",", "xs", ",", "\[Tau]", ",", "tl", ",", "xl", ",", 
         "tsl", ",", "flag", ",", "tb", ",", "te", ",", "sx", ",", "sr", ",", 
         "sn", ",", "prevseg", ",", "segnum", ",", "\[Alpha]", ",", "\[Beta]",
          ",", "sxp", ",", "l"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"t", "=", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{"Tp", "/", "2"}], "]"}], "+", "1"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"prevseg", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"sxp", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"segnum", "=", 
         RowBox[{"-", "1"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"t", "<", 
           RowBox[{"tm", "-", "1"}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                "\[RightDoubleBracket]"}], "\[LessEqual]", "\[Theta]"}], "&&", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                 RowBox[{"t", "+", "1"}], "\[RightDoubleBracket]"}], 
                "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ">", 
               "\[Theta]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"ts", "=", "t"}], ";", 
              RowBox[{"xs", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                "\[RightDoubleBracket]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"tl", "=", 
               RowBox[{"t", "+", "1"}]}], ";", 
              RowBox[{"xl", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                 RowBox[{"t", "+", "1"}], "\[RightDoubleBracket]"}], 
                "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";",
               "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"\[Alpha]", "=", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"t", "+", "1"}], "\[RightDoubleBracket]"}], 
                   "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                  "-", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                   "\[RightDoubleBracket]"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"xl", "-", "xs"}], ")"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"\[Beta]", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                  "\[CurlyPhi]", "\[LeftDoubleBracket]", "i", 
                   "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "t", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], "-", 
                RowBox[{"\[Alpha]", " ", "xs"}]}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"tsl", "=", 
               RowBox[{"Round", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ts", "+", "tl"}], ")"}], "/", "2"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"flag", "=", "1"}], ";", "\[IndentingNewLine]", 
              RowBox[{"tb", "=", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{"tsl", "-", "\[Lambda]"}], ",", "1"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"te", "=", 
               RowBox[{"Min", "[", 
                RowBox[{
                 RowBox[{"tsl", "-", "\[Lambda]", "+", "\[Eta]"}], ",", 
                 "tm"}], "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"te", "<", "1"}], ",", 
                RowBox[{
                 RowBox[{"te", "=", "1"}], ";"}]}], "]"}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"\[Tau]", "=", "tb"}], ",", 
                RowBox[{"\[Tau]", "\[LessEqual]", "te"}], ",", 
                RowBox[{"\[Tau]", "++"}], ",", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "\[Zeta]", "\[LeftDoubleBracket]", "i", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "\[Tau]", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "<", "Zc"}], ",", 
                   RowBox[{
                    RowBox[{"flag", "=", "0"}], ";", 
                    RowBox[{"Break", "[", "]"}], ";"}]}], "]"}], ";"}]}], 
               "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"flag", "\[Equal]", "1"}], ",", "\[IndentingNewLine]",
                 "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"sx", "=", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"\[Theta]", "-", "\[Beta]"}], ")"}], "/", 
                   "\[Alpha]"}]}], ";", "\[IndentingNewLine]", 
                 "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"prevseg", "\[Equal]", "1"}], "&&", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"sx", "-", "sxp"}], ")"}], "<", "1.3"}]}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"segnum", "=", 
                    RowBox[{"segnum", "+", "1"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"segnum", "\[LessEqual]", 
                    RowBox[{"Floor", "[", 
                    RowBox[{"tm", "/", "Tp"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "segtype", "\[LeftDoubleBracket]", "segnum", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "rl", 
                    "\[RightDoubleBracket]"}], "=", "1"}], ";"}]}], "]"}], 
                    ";"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                   
                   RowBox[{
                    RowBox[{"sr", "=", 
                    RowBox[{"Round", "[", "sx", "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"sr", "-", "sx"}], ">", "\[CapitalDelta]"}], ",", 
                    
                    RowBox[{
                    RowBox[{"sn", "=", 
                    RowBox[{"sr", "-", "1"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"prevseg", "\[Equal]", "0"}], "&&", 
                    RowBox[{
                    RowBox[{"sn", "-", "segnum"}], "\[LessEqual]", "1"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"sn", "=", "sr"}], ";"}]}], "]"}], ";"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"sn", "=", "sr"}], ";"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "segtype", "\[LeftDoubleBracket]", "sn", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "rl", 
                    "\[RightDoubleBracket]"}], "=", "1"}], ";", 
                    RowBox[{"segnum", "=", "sn"}], ";"}]}], 
                  "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
                 "\[IndentingNewLine]", 
                 RowBox[{"(*", 
                  RowBox[{
                   RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<sx = \>\"", ",", "sx", ",", "\"\< sx-sxp = \>\"", 
                    ",", 
                    RowBox[{"sx", "-", "sxp"}], ",", "\"\<: tsl = \>\"", ",", 
                    "tsl", ",", "\"\<: segnum = \>\"", ",", "segnum"}], "]"}],
                    ";"}], "*)"}], "\[IndentingNewLine]", 
                 "\[IndentingNewLine]", 
                 RowBox[{"sxp", "=", "sx"}], ";", "\[IndentingNewLine]", 
                 RowBox[{"prevseg", "=", "1"}], ";"}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"flag", "\[Equal]", "0"}], ",", 
                RowBox[{
                 RowBox[{"prevseg", "=", "0"}], ";"}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"t", "=", 
               RowBox[{"tl", "+", 
                RowBox[{"Round", "[", 
                 RowBox[{"Tp", "/", "3"}], "]"}]}]}], ";"}]}], 
            "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"t", "=", 
            RowBox[{"t", "+", "1"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"l", "=", "segnum"}], ",", 
          RowBox[{"l", "\[LessEqual]", "maxsegnum"}], ",", 
          RowBox[{"l", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"l", ">", "pld"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                "segtype", "\[LeftDoubleBracket]", "l", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "rl", 
                "\[RightDoubleBracket]"}], "=", "1"}], ";"}]}], "]"}], 
           ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"===", "===", "===", "===", " ", 
      RowBox[{
       RowBox[{"calculation", " ", "of", " ", "Left"}], "-", 
       RowBox[{"Right", " ", "differences"}]}], " ", "===", "===", "===", 
      "==="}], "="}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pafunc", "[", "ald_", "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"j", ",", "na", ",", "pa", ",", "nt"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nt", "=", "0"}], ";", 
        RowBox[{"na", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"j", "=", "ald"}], ",", 
          RowBox[{"j", "\[LessEqual]", "maxsegnum"}], ",", 
          RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                "segtype", "\[LeftDoubleBracket]", "j", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                "\[RightDoubleBracket]"}], "*", 
               RowBox[{
                RowBox[{
                "segtype", "\[LeftDoubleBracket]", "j", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "3", 
                "\[RightDoubleBracket]"}]}], "\[Equal]", "0"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"nt", "=", 
               RowBox[{"nt", "+", "1"}]}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                   "segtype", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                   "\[RightDoubleBracket]"}], "+", 
                  RowBox[{
                   RowBox[{
                   "segtype", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "3", 
                   "\[RightDoubleBracket]"}]}], "\[Equal]", "1"}], ",", 
                RowBox[{
                 RowBox[{"na", "=", 
                  RowBox[{"na", "+", "1"}]}], ";"}]}], "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"nt", ">", "0"}], ",", 
          RowBox[{
           RowBox[{"pa", "=", 
            RowBox[{"N", "[", 
             RowBox[{"na", "/", "nt"}], "]"}]}], ";"}], ",", 
          RowBox[{
           RowBox[{"pa", "=", "0"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "pa"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pldr", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pldl", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pldm", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"frsr", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{"FRS", " ", "for", " ", "right", " ", "segments"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"frsl", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{"FRS", " ", "for", " ", "left", " ", "segments"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"frsm", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{
     "FRS", " ", "for", " ", "left", " ", "and", " ", "right", " ", 
      "segments"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"frsres", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{
     "FRS", " ", "resync", " ", "for", " ", "left", " ", "and", " ", "right", 
      " ", "segments"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"def", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "maxsegnum"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rdef", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "maxsegnum"}], "}"}]}], "]"}]}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"fraction", " ", "of", " ", "defective", " ", "segment"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"pam", "=", 
     RowBox[{"{", "}"}]}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"fraction", " ", "of", " ", "left"}], "-", 
      RowBox[{"right", " ", "difference"}]}], " ", "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", "imax"}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"frsr", ",", 
         RowBox[{
          RowBox[{"frsfunc", "[", 
           RowBox[{"\[Psi]r", ",", "Zr", ",", "i"}], "]"}], "-", "1"}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"frsl", ",", 
         RowBox[{
          RowBox[{"frsfunc", "[", 
           RowBox[{"\[Psi]l", ",", "Zl", ",", "i"}], "]"}], "-", "1"}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"frsm", ",", 
         RowBox[{
         "frsr", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], 
        "]"}], ";", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"frsm", ",", 
         RowBox[{
         "frsl", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"approximate", " ", "PLD", " ", "position"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"pldr", ",", 
         RowBox[{
          RowBox[{"pldfunc", "[", 
           RowBox[{"\[Psi]r", ",", "Zr", ",", "i"}], "]"}], "-", "1"}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"pldl", ",", 
         RowBox[{
          RowBox[{"pldfunc", "[", 
           RowBox[{"\[Psi]l", ",", "Zl", ",", "i"}], "]"}], "-", "1"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"segtype", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "maxsegnum"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"segtypefunc", "[", 
        RowBox[{"\[Psi]r", ",", "Zr", ",", "i", ",", "2", ",", 
         RowBox[{
         "pldr", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"segtypefunc", "[", 
        RowBox[{"\[Psi]l", ",", "Zl", ",", "i", ",", "3", ",", 
         RowBox[{
         "pldl", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"PLD", " ", "calculation"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"j", "=", "maxsegnum"}], ",", 
         RowBox[{"j", "\[GreaterEqual]", "1"}], ",", 
         RowBox[{"j", "--"}], ",", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
              "segtype", "\[LeftDoubleBracket]", "j", 
               "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
              "\[RightDoubleBracket]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"AppendTo", "[", 
              RowBox[{"pldm", ",", "j"}], "]"}], ";", 
             RowBox[{"Break", "[", "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"j", "=", "maxsegnum"}], ",", 
         RowBox[{"j", "\[GreaterEqual]", "1"}], ",", 
         RowBox[{"j", "--"}], ",", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
              "segtype", "\[LeftDoubleBracket]", "j", 
               "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "3", 
              "\[RightDoubleBracket]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"AppendTo", "[", 
              RowBox[{"pldm", ",", "j"}], "]"}], ";", 
             RowBox[{"Break", "[", "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"j", "=", "1"}], ",", 
         RowBox[{"j", "\[LessEqual]", "maxsegnum"}], ",", 
         RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"AppendTo", "[", 
           RowBox[{
            RowBox[{
            "def", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
            ",", 
            RowBox[{
             RowBox[{
             "segtype", "\[LeftDoubleBracket]", "j", 
              "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
             "\[RightDoubleBracket]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{
            RowBox[{
            "def", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
            ",", 
            RowBox[{
             RowBox[{
             "segtype", "\[LeftDoubleBracket]", "j", 
              "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "3", 
             "\[RightDoubleBracket]"}]}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"pam", ",", 
         RowBox[{"pafunc", "[", "aldi", "]"}]}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fp", "=", 
     RowBox[{"OpenWrite", "[", 
      RowBox[{"\"\<fraction_defective_segments.dat\>\"", ",", 
       RowBox[{"PageWidth", "\[Rule]", "Infinity"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"j", "=", "1"}], ",", 
      RowBox[{"j", "\[LessEqual]", "maxsegnum"}], ",", 
      RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
        "rdef", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], "=", 
        RowBox[{"N", "[", 
         RowBox[{"1", "-", 
          RowBox[{"Mean", "[", 
           RowBox[{
           "def", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
           "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"WriteString", "[", 
        RowBox[{"fp", ",", "j", ",", "\"\< \>\"", ",", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{
           "rdef", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
           ",", "6", ",", 
           RowBox[{"ExponentFunction", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"Null", "&"}], ")"}]}]}], "]"}], ",", "\"\<\\n\>\""}], 
        "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "fp", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<mean FRS = \>\"", ",", 
      RowBox[{"N", "[", 
       RowBox[{"Mean", "[", "frsm", "]"}], "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<SD FRS = \>\"", ",", 
      RowBox[{"N", "[", 
       RowBox[{"StandardDeviation", "[", "frsm", "]"}], "]"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<mean PLD = \>\"", ",", 
      RowBox[{"N", "[", 
       RowBox[{"Mean", "[", "pldm", "]"}], "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<SD PLD = \>\"", ",", 
      RowBox[{"N", "[", 
       RowBox[{"StandardDeviation", "[", "pldm", "]"}], "]"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<mean Pa = \>\"", ",", 
      RowBox[{"N", "[", 
       RowBox[{"Mean", "[", "pam", "]"}], "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<SD Pa = \>\"", ",", 
      RowBox[{"N", "[", 
       RowBox[{"StandardDeviation", "[", "pam", "]"}], "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mft", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"k", ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "40", ",", "3"}], "}"}]}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mfty", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"k", ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "0.3", ",", "0.05"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Histogram", "[", 
    RowBox[{"frsm", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "33", ",", "1"}], "}"}], ",", "\"\<Probability\>\"", 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.2"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"mfty", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"mft", ",", "None"}], "}"}]}], "}"}]}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Histogram", "[", 
    RowBox[{"pldm", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "33", ",", "1"}], "}"}], ",", "\"\<Probability\>\"", 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.2"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"mfty", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"mft", ",", "None"}], "}"}]}], "}"}]}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"MatrixForm", "[", "rdef", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"OUTPUT", " ", "PLD", " ", "and", " ", "FRS"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fid1", "=", 
     RowBox[{"OpenWrite", "[", 
      RowBox[{"\"\<FRS_sim.dat\>\"", ",", 
       RowBox[{"PageWidth", "\[Rule]", "Infinity"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fid2", "=", 
     RowBox[{"OpenWrite", "[", 
      RowBox[{"\"\<PLD_sim.dat\>\"", ",", 
       RowBox[{"PageWidth", "\[Rule]", "Infinity"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"np", "=", 
     RowBox[{"Length", "[", "pldm", "]"}]}], ";", 
    RowBox[{"nf", "=", 
     RowBox[{"Length", "[", "frsm", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", "nf"}], ",", 
      RowBox[{"i", "++"}], ",", 
      RowBox[{
       RowBox[{"WriteString", "[", 
        RowBox[{"fid1", ",", 
         RowBox[{
         "frsm", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], ",", 
         "\"\<\\n\>\""}], "]"}], ";"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", "np"}], ",", 
      RowBox[{"i", "++"}], ",", 
      RowBox[{
       RowBox[{"WriteString", "[", 
        RowBox[{"fid2", ",", 
         RowBox[{
         "pldm", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], ",", 
         "\"\<\\n\>\""}], "]"}], ";"}]}], "]"}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "fid1", "]"}], ";", 
    RowBox[{"Close", "[", "fid2", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6866326613065166`*^9, 3.6866326772265263`*^9}, {
   3.686632713950632*^9, 3.6866327817782288`*^9}, 3.6866335322493887`*^9, 
   3.6866880591627693`*^9, 3.686688113244289*^9, 3.686688285201228*^9, 
   3.686688327396717*^9, 3.6866891497640038`*^9, 3.686689684311508*^9, 
   3.6866903307009983`*^9, 3.686723645130033*^9, 3.686723721610623*^9, 
   3.6867238204421577`*^9, 3.686723861394081*^9, 3.68687465788778*^9, 
   3.686874735800448*^9, 3.686874915498814*^9, 3.686875023627975*^9, 
   3.6868752554744873`*^9, 3.68713122706374*^9, 3.6871345745375023`*^9, 
   3.687135188601759*^9, 3.68713524004265*^9, 3.687135278812127*^9, {
   3.687135694041461*^9, 3.687135718564742*^9}, 3.687135775426949*^9, 
   3.687135828563298*^9, 3.69457959280022*^9, 3.694580229311522*^9, 
   3.6945806170295353`*^9, 3.69458093285606*^9, 3.6945817437270727`*^9, 
   3.694582015667488*^9, 3.694742786358842*^9, 3.694744333832347*^9, 
   3.694993101797029*^9, 3.695425968296014*^9, 3.695542516614216*^9, 
   3.695790996571315*^9, 3.697333529502133*^9, 3.6974419820172443`*^9, 
   3.6974443364624233`*^9, 3.697444379589452*^9, 3.697444430455122*^9, 
   3.697519185041828*^9, 3.697597379265809*^9, 3.697748334679996*^9, 
   3.697836157926693*^9, 3.697918160162613*^9, 3.698008932774921*^9, 
   3.698095125337225*^9, 3.6981289206225357`*^9, 3.69835421154145*^9, 
   3.70043466500947*^9, {3.7004347457162333`*^9, 3.700434745803966*^9}, 
   3.700509462003558*^9, 3.700510336784615*^9, 3.700604811060017*^9, 
   3.700605049311397*^9, 3.700782605583888*^9, 3.700782690968254*^9, 
   3.700783200912621*^9, {3.7007832553858843`*^9, 3.700783255439233*^9}, 
   3.70078405914961*^9, 3.700784124287559*^9, 3.700861831053259*^9, 
   3.70086780673571*^9, {3.7008679312711067`*^9, 3.700867932026656*^9}, 
   3.700868005044957*^9, {3.700868062350294*^9, 3.700868062429826*^9}, 
   3.700868150110614*^9, 3.7008687420361032`*^9, 3.701820008947712*^9, 
   3.701820246195882*^9, 3.70200503083363*^9, 3.702005279256023*^9, 
   3.702271041562875*^9, 3.702271525806171*^9, 3.7023559524499273`*^9, {
   3.7023561267267942`*^9, 3.702356127194865*^9}, 3.702423701282236*^9, {
   3.702423764086072*^9, 3.70242376467949*^9}, 3.702606939475523*^9, {
   3.70260702097512*^9, 3.702607022173172*^9}, 3.7041689296433067`*^9, 
   3.704169215812875*^9, 3.704229974688559*^9, 3.7042320165379763`*^9, 
   3.70534697737414*^9, 3.705347026043419*^9, {3.705979190485346*^9, 
   3.705979208068396*^9}, {3.7059802075910788`*^9, 3.705980210443902*^9}, 
   3.706220224218862*^9, 3.706220304742117*^9, 3.706652188064686*^9, 
   3.706822485255788*^9, 3.706822690201644*^9, 3.706995969131897*^9, 
   3.7069961840479794`*^9, 3.707454878085719*^9, 3.7080553206953497`*^9, 
   3.70805590329493*^9, 3.708331336226598*^9, 3.708331478713854*^9, 
   3.7086734964137297`*^9, 3.7100191880616503`*^9, 3.710019335833405*^9, 
   3.7100218755532618`*^9, {3.710021977251852*^9, 3.710021985984716*^9}, 
   3.710105278366639*^9, {3.710105350952441*^9, 3.710105356300212*^9}, 
   3.710455985915306*^9, 3.71045611768754*^9, 3.710456238946868*^9, 
   3.710456334128045*^9, 3.7105761097844057`*^9, 3.710576253202819*^9, 
   3.710576309767831*^9, 3.711056775874312*^9, 3.7110568690125237`*^9, 
   3.711501925338696*^9, 3.711502094294818*^9, 3.711502156250375*^9, 
   3.7115023756790447`*^9, 3.711688614193954*^9, 3.711688767946053*^9, 
   3.711688871791308*^9, 3.7116952213931847`*^9, 3.711695405675804*^9, 
   3.711840165473329*^9, 3.711840261651144*^9, 3.711840339369817*^9, 
   3.711849101112546*^9, 3.7120123591433268`*^9, 3.71201245215443*^9, 
   3.712012533655232*^9, 3.712012614205868*^9, 3.712266392338604*^9, 
   3.712266479371379*^9, 3.712356046770443*^9, 3.7123713806800613`*^9, 
   3.712441038322266*^9, 3.712441088565733*^9, 3.71244118002503*^9, 
   3.712894238156343*^9, 3.712894326132328*^9, 3.712894379831751*^9, 
   3.7128944344465113`*^9, 3.712989227921762*^9, 3.7129892780922956`*^9, 
   3.71314627497665*^9, {3.713146323036845*^9, 3.713146326829391*^9}, {
   3.713146765444435*^9, 3.7131467730230007`*^9}, {3.7131468375583067`*^9, 
   3.713146848981123*^9}, 3.713307617819028*^9, {3.7133076828895683`*^9, 
   3.71330768587754*^9}, {3.713307725399291*^9, 3.713307728996459*^9}, {
   3.713307766341159*^9, 3.713307770050705*^9}, 3.713488691043684*^9, 
   3.713489025853188*^9, 3.7134900518527393`*^9, 3.7134901421314774`*^9, 
   3.7136704996954536`*^9, {3.713670540624216*^9, 3.713670540750828*^9}, 
   3.714342776252501*^9, 3.717031210582114*^9, {3.7170316493611*^9, 
   3.7170316750608883`*^9}, {3.717104964790721*^9, 3.717104987302753*^9}, 
   3.717636183994712*^9, {3.717636244883541*^9, 3.717636245010768*^9}, {
   3.717636308419752*^9, 3.717636308760518*^9}, 3.717724254231435*^9, 
   3.717724338179693*^9, {3.717909388461575*^9, 3.717909414066863*^9}, 
   3.7179094848098783`*^9, 3.71790953266372*^9, 3.717909589685667*^9, {
   3.718052975647223*^9, 3.718052978964922*^9}, {3.718053137982986*^9, 
   3.718053138042822*^9}, {3.718053193778247*^9, 3.718053193831565*^9}, 
   3.718332818198226*^9, {3.718332858768729*^9, 3.718332858882051*^9}, 
   3.718332897194891*^9, 3.71860167020087*^9, {3.718603661564703*^9, 
   3.718603661685912*^9}, {3.718603699579685*^9, 3.718603699738751*^9}, {
   3.7186037345432787`*^9, 3.7186037347033577`*^9}, 3.7186037704806843`*^9, 
   3.7186652343454113`*^9, {3.718665277870367*^9, 3.71866527803093*^9}, {
   3.718665310134076*^9, 3.718665310277804*^9}, {3.718665344821069*^9, 
   3.718665344931975*^9}, 3.720404391215798*^9, 3.7207355962130404`*^9, 
   3.720735780515524*^9, 3.720735846161327*^9, 3.7207359138863*^9, {
   3.720844405645396*^9, 3.7208444119840117`*^9}, 3.720844452680449*^9, {
   3.720847281327508*^9, 3.720847281471043*^9}, 3.720847335864147*^9, 
   3.7209312438674183`*^9, 3.720931330066636*^9, 3.721374256282785*^9, {
   3.721374331337184*^9, 3.721374331474348*^9}, 3.7213743966253*^9, 
   3.721374458262535*^9, {3.721376705418317*^9, 3.72137671079346*^9}, {
   3.721376765991728*^9, 3.72137676609273*^9}, {3.721376800476747*^9, 
   3.7213768006268587`*^9}, {3.721376831275776*^9, 3.7213768314816008`*^9}, 
   3.7231628792841454`*^9, 3.723162961197068*^9, 3.72316305890842*^9, 
   3.723167231941145*^9, 3.723427945902442*^9, 3.723596708963511*^9, 
   3.723596781986513*^9, 3.723949119385139*^9, {3.7239491931076307`*^9, 
   3.723949193210616*^9}, 3.724375684192109*^9, 3.724375753971781*^9, 
   3.724375817461638*^9, 3.724638495330474*^9, 3.724638568695262*^9, 
   3.7250782152348833`*^9, 3.725078273719458*^9, 3.725253370283409*^9, 
   3.725253490579465*^9, {3.727400000215303*^9, 3.7274000218885736`*^9}, 
   3.72740009178929*^9, 3.727400165794269*^9, 3.727497129464867*^9, 
   3.727497199294799*^9, 3.7275921674549437`*^9, 3.7275942414871407`*^9, 
   3.72764412673909*^9, 3.727644194782529*^9, 3.7277401119098577`*^9, 
   3.7277401766965427`*^9, {3.727818198996645*^9, 3.727818199188723*^9}, 
   3.7278196679133997`*^9, 3.7286200133277082`*^9, 3.72862008868248*^9, 
   3.728620143397142*^9, {3.728620274567224*^9, 3.728620274633409*^9}, 
   3.7288017702474537`*^9, 3.728801861121924*^9, 3.728801919760028*^9, 
   3.728801989595619*^9, {3.728802041529049*^9, 3.728802041662623*^9}, 
   3.7288027276669493`*^9, 3.728973043807839*^9, 3.728973081136553*^9, {
   3.728973127810296*^9, 3.728973136122232*^9}, 3.72897317744744*^9, 
   3.7289732155353813`*^9, {3.728973251005493*^9, 3.7289732511243553`*^9}, {
   3.729373330937788*^9, 3.729373335438676*^9}, {3.7293734178478622`*^9, 
   3.729373418420731*^9}, {3.729373470738708*^9, 3.729373478340522*^9}, {
   3.729373544621743*^9, 3.729373546628207*^9}, 3.7294113020288877`*^9, {
   3.729735856718264*^9, 3.7297358701539583`*^9}, {3.7297359292218943`*^9, 
   3.729735929386538*^9}, {3.729735975596407*^9, 3.729735975723778*^9}, 
   3.729736021385427*^9, {3.729812182318622*^9, 3.729812189305505*^9}, {
   3.7298122558838253`*^9, 3.729812256018846*^9}, 3.729887607877458*^9, 
   3.7301758675840693`*^9, {3.73017589953022*^9, 3.730175915040811*^9}, 
   3.730176017348995*^9, 3.730176097990264*^9, 3.7301761479441223`*^9, 
   3.730238594720469*^9, {3.730254287772505*^9, 3.7302542879077272`*^9}, {
   3.730254347275921*^9, 3.73025434744932*^9}, 3.730408551999667*^9, {
   3.73040861221581*^9, 3.730408612349525*^9}, {3.7304086822329817`*^9, 
   3.7304086823455667`*^9}, {3.730408733551385*^9, 3.730408733904111*^9}, 
   3.7310183236486187`*^9, 3.731018437258924*^9, 3.731022069318819*^9, {
   3.7310221272026176`*^9, 3.731022127299356*^9}, {3.7310221755588093`*^9, 
   3.731022175687532*^9}, {3.7310222998828783`*^9, 3.7310223038638678`*^9}, {
   3.731022355657269*^9, 3.731022355752969*^9}, {3.7310224005426617`*^9, 
   3.7310224007000933`*^9}, 3.731813005093278*^9, 3.7318130618966713`*^9, {
   3.731813116915638*^9, 3.731813121663986*^9}, 3.731813165393669*^9, {
   3.731813211927156*^9, 3.7318132186210213`*^9}, 3.7318132622361603`*^9, 
   3.73181332381042*^9, {3.7318133682762413`*^9, 3.731813368361622*^9}, {
   3.731813411586946*^9, 3.731813411729216*^9}, 3.731879117225994*^9, {
   3.732838843766262*^9, 3.732838847790926*^9}, {3.732838948254188*^9, 
   3.732838948347937*^9}, {3.73283900448405*^9, 3.73283902162479*^9}, 
   3.732839110940262*^9, {3.732839218066403*^9, 3.7328392215917673`*^9}, 
   3.732839289846479*^9, 3.7328393589126883`*^9, 3.732839422116736*^9, 
   3.732839494104066*^9, 3.7328395484870033`*^9, {3.73467055967384*^9, 
   3.734670566332645*^9}, {3.734670616383787*^9, 3.73467061655658*^9}, {
   3.734670738008252*^9, 3.734670738067271*^9}, {3.734671117624174*^9, 
   3.7346711177151814`*^9}, {3.7346711951777*^9, 3.7346712224366426`*^9}, 
   3.734749688953174*^9, {3.734749724565452*^9, 3.734749726945067*^9}, {
   3.7347511818480177`*^9, 3.734751263143917*^9}, {3.73475130213585*^9, 
   3.734751429652505*^9}, 3.734825642660879*^9, 3.734825939357602*^9, 
   3.734851838996285*^9, 3.734898799826152*^9, 3.734917060237562*^9, {
   3.7349171314791822`*^9, 3.734917131600521*^9}, 3.734985334752507*^9, 
   3.734985377841816*^9, 3.735088683209066*^9, {3.735088720235025*^9, 
   3.735088720361758*^9}, 3.735430526376808*^9, {3.7354305568163137`*^9, 
   3.735430556910811*^9}, {3.735430593047172*^9, 3.735430620312223*^9}, 
   3.73543065541634*^9, 3.7356081934972467`*^9, {3.735608234916621*^9, 
   3.735608264694376*^9}, 3.7356083688819933`*^9, {3.735701352560803*^9, 
   3.735701431250046*^9}, {3.7357015251006813`*^9, 3.735701525218999*^9}, 
   3.735876696415485*^9, {3.735876736099712*^9, 3.735876786238023*^9}, {
   3.7358770231768312`*^9, 3.735877103836051*^9}, 3.73649321090281*^9, {
   3.736493242113364*^9, 3.736493441722212*^9}, {3.741146008262533*^9, 
   3.7411460701696377`*^9}, 3.741323346221346*^9, {3.741323433702786*^9, 
   3.7413234828510933`*^9}, 3.741482167996305*^9, {3.741482236136176*^9, 
   3.7414822881267757`*^9}, 3.742360367608014*^9, 3.7423604868105392`*^9, 
   3.742360574395067*^9, 3.742360653738933*^9, {3.742361489900817*^9, 
   3.7423614899952297`*^9}, {3.742361651405437*^9, 3.7423616515068073`*^9}, {
   3.742361683357992*^9, 3.7423616835218077`*^9}, {3.742361753436199*^9, 
   3.742361753502438*^9}, {3.742362472726487*^9, 3.742362472820839*^9}, {
   3.742362504092379*^9, 3.742362532477625*^9}, {3.742534023102503*^9, 
   3.742534023388805*^9}, {3.7425341867498417`*^9, 3.742534186850767*^9}, {
   3.7425345083123617`*^9, 3.742534508470297*^9}, {3.742535314800885*^9, 
   3.742535314913073*^9}, 3.742711773516531*^9, {3.742711806548654*^9, 
   3.742711806659786*^9}, {3.7427118387618*^9, 3.742711868002037*^9}, {
   3.742794311410366*^9, 3.74279431151143*^9}, 3.74279434490329*^9, {
   3.742945625844756*^9, 3.74294563224262*^9}, {3.742945762858725*^9, 
   3.742945762943605*^9}, 3.743115454063637*^9, 3.743115547567069*^9, 
   3.743115587942271*^9, 3.743115624420698*^9, 3.743201653036797*^9, {
   3.743201760418783*^9, 3.743201817726245*^9}, 3.7464813274480867`*^9, {
   3.7464813632395973`*^9, 3.746481412493597*^9}, {3.7467411547543783`*^9, 
   3.746741161680503*^9}, {3.7467411986224127`*^9, 3.7467412440811453`*^9}, {
   3.748760790193466*^9, 3.748760862850172*^9}, 3.749274940667066*^9, {
   3.749274989974161*^9, 3.749275038121606*^9}, {3.749275169512559*^9, 
   3.749275242050988*^9}, {3.7494239810433064`*^9, 3.749424062840109*^9}, {
   3.749446498781467*^9, 3.7494465276393223`*^9}, {3.74944656487184*^9, 
   3.749446588149672*^9}, 3.74953918069174*^9, {3.7495392142079487`*^9, 
   3.749539214294662*^9}, 3.7497689193472557`*^9, {3.74976895117773*^9, 
   3.749769001174534*^9}, {3.7497708332045727`*^9, 3.74977086144869*^9}, {
   3.749770892095195*^9, 3.749770892196299*^9}, 3.749770924004825*^9, 
   3.749855403280014*^9, {3.7498554360920277`*^9, 3.7498554876654654`*^9}, {
   3.750030038462659*^9, 3.7500301213943787`*^9}, {3.750114187009882*^9, 
   3.750114266219344*^9}, 3.751853848361169*^9, {3.751853879889324*^9, 
   3.7518539293999577`*^9}, {3.75188255323171*^9, 3.751882606305459*^9}, 
   3.751936187484788*^9, 3.751936662447983*^9, 3.7519370160602093`*^9, 
   3.751937601561501*^9, 3.751937641068037*^9, 3.752188393222612*^9, {
   3.752188473943512*^9, 3.7521885248938026`*^9}, {3.7522935718227367`*^9, 
   3.752293575693774*^9}, {3.752293613982512*^9, 3.752293656667705*^9}, {
   3.75290179125977*^9, 3.752901796487548*^9}, {3.752901850079378*^9, 
   3.752901877363212*^9}, {3.7531588203208637`*^9, 3.7531588971094837`*^9}, {
   3.7532389660569153`*^9, 3.7532390215895987`*^9}, 3.753841832457858*^9, {
   3.75384402403419*^9, 3.753844076875896*^9}, 3.754024249631956*^9, {
   3.754024300103216*^9, 3.7540243280682983`*^9}, 3.754114721740449*^9, {
   3.754203877756485*^9, 3.754203960360422*^9}, {3.754290266873171*^9, 
   3.7542903443330927`*^9}, {3.754963957174958*^9, 3.754964034775627*^9}, 
   3.755046185512313*^9, {3.755049231691787*^9, 3.7550492353411827`*^9}, {
   3.7554756661350803`*^9, 3.755475719500828*^9}, 3.755655399707967*^9, {
   3.755655434981718*^9, 3.755655484587819*^9}, {3.755926403817075*^9, 
   3.7559264786559353`*^9}, 3.756010270183187*^9, {3.756010307872449*^9, 
   3.756010360704445*^9}, 3.7564489237490683`*^9, {3.756448953951778*^9, 
   3.7564490006316233`*^9}, {3.7564494737688103`*^9, 3.756449556644084*^9}, {
   3.75644998684158*^9, 3.756449990343657*^9}, {3.756450021638969*^9, 
   3.7564500705747004`*^9}, {3.7564504995673733`*^9, 3.756450571252948*^9}, {
   3.75688250148466*^9, 3.756882577838975*^9}, 3.7604195615929956`*^9, {
   3.7604198629715652`*^9, 3.7604198631240263`*^9}, 3.7607526187287292`*^9, {
   3.760856674858033*^9, 3.760856761150085*^9}, {3.760856803114026*^9, 
   3.760856807934614*^9}, {3.7608569150248737`*^9, 3.760856986406652*^9}, {
   3.7608604522894363`*^9, 3.760860488682786*^9}, {3.7608616585546207`*^9, 
   3.760861658650899*^9}, {3.760909705313426*^9, 3.760909705412778*^9}, {
   3.760911106271007*^9, 3.760911145530702*^9}, {3.760915553099989*^9, 
   3.76091555770387*^9}, 3.760918000772999*^9, {3.7609205407150373`*^9, 
   3.760920540820322*^9}, 3.7609238981165*^9, 3.7609239527763147`*^9, 
   3.7609239854731293`*^9, 3.760924092677126*^9, 3.760924170108399*^9, 
   3.76092430235435*^9, 3.760924407580778*^9, 3.7609246434664097`*^9, 
   3.7609247881195717`*^9, 3.7609971275745564`*^9, {3.7609971601195374`*^9, 
   3.760997209444983*^9}, {3.760997653239596*^9, 3.76099765394279*^9}, {
   3.760999289900464*^9, 3.760999290010275*^9}, {3.760999850926886*^9, 
   3.760999869685739*^9}, {3.761001350299389*^9, 3.7610013898774147`*^9}, {
   3.7610014228160877`*^9, 3.7610014239278717`*^9}, 3.761001494435413*^9, {
   3.761001755851446*^9, 3.7610017817517977`*^9}, {3.761002360500334*^9, 
   3.761002360624929*^9}, {3.761002563911076*^9, 3.761002564203899*^9}, 
   3.761003386292645*^9, {3.761003991716646*^9, 3.761003991828985*^9}, 
   3.761082921523675*^9, 3.7610831918679943`*^9, 3.7610832817819433`*^9, 
   3.761083522808321*^9, 3.761083653808778*^9, 3.761084125845299*^9, {
   3.7610866142297173`*^9, 3.76108661589926*^9}, {3.761255237007804*^9, 
   3.761255241600333*^9}, {3.761336508475257*^9, 3.761336513531006*^9}, {
   3.7613367471513453`*^9, 3.761336804877102*^9}, {3.761336866552698*^9, 
   3.761336888766767*^9}, 3.7613370692693567`*^9, 3.761337264193694*^9, 
   3.7613383076765327`*^9, {3.761338419861525*^9, 3.761338476260672*^9}, {
   3.761450812194955*^9, 3.761450820392507*^9}, {3.761450939137412*^9, 
   3.761450939253881*^9}, 3.761451004276536*^9, 3.761451057371915*^9, {
   3.7614514698469973`*^9, 3.7614515090979853`*^9}, {3.7614519875417843`*^9, 
   3.761452040617072*^9}, {3.76151868283132*^9, 3.761518687058429*^9}, 
   3.7615188955311832`*^9, {3.761519076015335*^9, 3.761519079641321*^9}, {
   3.761519152893174*^9, 3.76151915492345*^9}, {3.761624977611579*^9, 
   3.761625007168901*^9}, {3.761625049369878*^9, 3.761625075917091*^9}, {
   3.761625372919303*^9, 3.761625438677651*^9}, {3.761625505513562*^9, 
   3.7616255166749163`*^9}, {3.7616256508355637`*^9, 3.761625793468553*^9}, {
   3.761625830497881*^9, 3.761625925401938*^9}, 3.761625959803709*^9, {
   3.761626052877502*^9, 3.761626060934564*^9}, {3.761626137288166*^9, 
   3.7616261378875723`*^9}, 3.761626255236093*^9, 3.761626378992483*^9, {
   3.761701325416891*^9, 3.7617013350321617`*^9}, {3.761701465367094*^9, 
   3.7617014655365353`*^9}, {3.7617015189628143`*^9, 3.761701519130476*^9}, 
   3.761701566491082*^9, {3.761883652334444*^9, 3.761883657885096*^9}, 
   3.761884867658586*^9, 3.761884904068183*^9, {3.761885132003119*^9, 
   3.7618851320812263`*^9}, 3.761885197979919*^9, {3.7618852821147327`*^9, 
   3.761885295217805*^9}, {3.761970381483218*^9, 3.7619703890545473`*^9}, {
   3.761970551885952*^9, 3.761970551965246*^9}, 3.76197061464222*^9, 
   3.761970697036813*^9, {3.761971612376121*^9, 3.761971616119644*^9}, {
   3.7619717423318777`*^9, 3.761971744306868*^9}, {3.7619717920656853`*^9, 
   3.761971792152092*^9}, {3.7619718818115253`*^9, 3.761971883418919*^9}, {
   3.762140962167859*^9, 3.762140967832592*^9}, {3.7621411587530947`*^9, 
   3.7621411588043137`*^9}, 3.762141204726981*^9, {3.7621412576933737`*^9, 
   3.762141257843472*^9}, 3.762141303939876*^9, {3.762228379956835*^9, 
   3.762228383389413*^9}, 3.762228519480986*^9, 3.762228586498921*^9, 
   3.762228723448517*^9, {3.76222878540627*^9, 3.7622287857888107`*^9}, 
   3.762228846858039*^9, 3.762228905211038*^9, {3.7624878469572687`*^9, 
   3.762487851582139*^9}, {3.762488003376417*^9, 3.7624880064867353`*^9}, {
   3.7624880614831133`*^9, 3.762488061568758*^9}, {3.762488117192112*^9, 
   3.762488117846949*^9}, {3.762488165695466*^9, 3.762488165765439*^9}, {
   3.7624882179753036`*^9, 3.7624882186594467`*^9}, {3.762489030887941*^9, 
   3.7624890364972363`*^9}, 3.762489166510417*^9, 3.762489214196418*^9, 
   3.762489256017692*^9, 3.762489307522058*^9, {3.762659814120975*^9, 
   3.762659835753932*^9}, 3.762659946502544*^9, 3.7626600113549757`*^9, 
   3.7626600526897984`*^9, {3.7627478711804733`*^9, 3.762747876701551*^9}, 
   3.7627479928745737`*^9, 3.762748037308373*^9, 3.762748095826556*^9, {
   3.762749174556901*^9, 3.7627492043781967`*^9}, {3.762749314743326*^9, 
   3.7627493385067797`*^9}, {3.763082165239444*^9, 3.763082170075371*^9}, 
   3.763082273673225*^9, 3.763082321991033*^9, 3.763082373988907*^9, {
   3.763083762051614*^9, 3.763083768975994*^9}, {3.763087668559885*^9, 
   3.763087674442346*^9}, {3.763190186590715*^9, 3.763190194939728*^9}, 
   3.763190322221698*^9, {3.763191931338935*^9, 3.763191953009597*^9}, {
   3.763191987549868*^9, 3.763192006750092*^9}, 3.7631921276517057`*^9, 
   3.7631921865378847`*^9, {3.763192220759295*^9, 3.763192220875949*^9}, {
   3.76343956944736*^9, 3.763439578582769*^9}, 3.7634404086979637`*^9, 
   3.7634404674446993`*^9, 3.76344053739179*^9, {3.763706603729846*^9, 
   3.7637066181289454`*^9}, {3.7637068942518883`*^9, 3.763706905749988*^9}, 
   3.7637069494696703`*^9, {3.7637070280619907`*^9, 3.763707028698598*^9}, {
   3.763769067381544*^9, 3.763769071836823*^9}, 3.7637692967736483`*^9, 
   3.763769345118787*^9, 3.7637966955718403`*^9, {3.76387871219263*^9, 
   3.763878716284233*^9}, 3.763878864289854*^9, 3.7638789233861647`*^9, {
   3.763878984772855*^9, 3.763878984927197*^9}, {3.763955897552561*^9, 
   3.763955924349474*^9}, 3.763956083398035*^9, 3.763956137354251*^9, 
   3.763956214023986*^9, {3.764026063679389*^9, 3.764026074396874*^9}, {
   3.764026243771443*^9, 3.764026243881207*^9}, 3.76402630069501*^9, 
   3.764026354869322*^9, {3.764297486145481*^9, 3.764297494203237*^9}, 
   3.764297621693308*^9, 3.764297679930366*^9, 3.7642977580723047`*^9, {
   3.764298303694207*^9, 3.764298303809238*^9}, 3.7642983770422697`*^9, 
   3.7642984555354557`*^9, 3.764298540238041*^9, {3.764402361372134*^9, 
   3.7644023657168016`*^9}, 3.764402535574621*^9, 3.764402611792945*^9, 
   3.7644026762186813`*^9, {3.764477065620846*^9, 3.764477070742182*^9}, 
   3.764477220342986*^9, {3.764562476791198*^9, 3.764562481498197*^9}, 
   3.764562648923155*^9, 3.764562717428218*^9, 3.764562799747175*^9, {
   3.76464907285194*^9, 3.764649080225562*^9}, 3.7646492698589478`*^9, 
   3.7646493344441233`*^9, 3.76464939635205*^9, {3.7647283457172947`*^9, 
   3.764728349403369*^9}, 3.764728474563542*^9, 3.764728547918045*^9, 
   3.7647286268997593`*^9, {3.7649197806794643`*^9, 3.7649198042906733`*^9}, 
   3.7649199231814337`*^9, {3.764919955683948*^9, 3.7649199557938128`*^9}, 
   3.764919996594864*^9, {3.764920290739924*^9, 3.764920351849101*^9}, {
   3.7649910768846416`*^9, 3.7649910994541388`*^9}, {3.7649911904504757`*^9, 
   3.7649912155994253`*^9}, 3.7649912621974363`*^9, {3.764993309157686*^9, 
   3.7649933133421373`*^9}, 3.764993375115138*^9, 3.7649934399626503`*^9, 
   3.764993479212031*^9, 3.764993523961912*^9, {3.765076983527688*^9, 
   3.7650769929460793`*^9}, 3.765077128381143*^9, {3.765077179483603*^9, 
   3.765077179584009*^9}, {3.7651663883324623`*^9, 3.7651663990164013`*^9}, 
   3.765166603215715*^9, 3.765166647331399*^9, 3.7651667046987267`*^9, 
   3.7651667564762497`*^9, {3.765250639813727*^9, 3.765250644180315*^9}, 
   3.7652507137541637`*^9, 3.765250785728353*^9, 3.7652508396946583`*^9, 
   3.765250885400998*^9, {3.765863565838223*^9, 3.765863569959647*^9}, 
   3.765863701366168*^9, 3.765864093469111*^9, 3.765869545313459*^9, {
   3.765869596239547*^9, 3.7658695963403387`*^9}, {3.765870665843218*^9, 
   3.765870668640119*^9}, {3.765870723903854*^9, 3.765870724011836*^9}, 
   3.7658708171654577`*^9, 3.7658708656767797`*^9, {3.765870922943953*^9, 
   3.765870923350696*^9}, {3.765871236479127*^9, 3.765871239168558*^9}, {
   3.765871286624699*^9, 3.765871286769123*^9}, 3.76587134258456*^9, 
   3.765871398395805*^9, {3.7658714365867157`*^9, 3.765871436984133*^9}, 
   3.765871481426051*^9, {3.765925098276705*^9, 3.7659251011915607`*^9}, 
   3.765925148832654*^9, 3.7659252101834087`*^9, 3.765925252118082*^9, {
   3.7659253614661627`*^9, 3.765925361608651*^9}, {3.76592563462525*^9, 
   3.765925637153736*^9}, {3.765925692120983*^9, 3.765925692239421*^9}, 
   3.765925738061221*^9, 3.765925785022429*^9, {3.7660120654631243`*^9, 
   3.7660120699597387`*^9}, {3.7660121704148617`*^9, 3.76601217055626*^9}, 
   3.766012245403022*^9, 3.7660122943466043`*^9, {3.766097236824748*^9, 
   3.76609724363375*^9}, 3.7660973825367737`*^9, {3.766097477087179*^9, 
   3.766097479565843*^9}, 3.7660975227475557`*^9, {3.7661862824533033`*^9, 
   3.766186287135049*^9}, 3.76618640111471*^9, 3.766186505538692*^9, 
   3.766267077681602*^9, 3.766267159343299*^9, 3.766267255924303*^9, 
   3.7662682554032516`*^9, {3.766352744572755*^9, 3.7663527483579197`*^9}, 
   3.766352849206892*^9, 3.766352961165012*^9, 3.7663530586499977`*^9, {
   3.766472498020917*^9, 3.766472500656502*^9}, 3.766472617424841*^9, 
   3.766472673963649*^9, 3.766472947803656*^9, {3.766473598677997*^9, 
   3.766473601645265*^9}, 3.7664736491314077`*^9, {3.76654492871992*^9, 
   3.7665449311835537`*^9}, 3.766545031722245*^9, 3.76654509090133*^9, {
   3.766617862078795*^9, 3.7666178655835943`*^9}, 3.766617963972699*^9, 
   3.766618026067728*^9, {3.767501076189434*^9, 3.767501078677291*^9}, 
   3.7675012227853813`*^9, {3.767501795043364*^9, 3.767501797337295*^9}, 
   3.76750185789615*^9, {3.7675019881647263`*^9, 3.767501990851927*^9}, {
   3.767502069947361*^9, 3.767502070225994*^9}, {3.768353127060526*^9, 
   3.768353133313396*^9}, {3.768353443939803*^9, 3.768353497101131*^9}, {
   3.7683537044401617`*^9, 3.768353774273781*^9}, {3.768354004902628*^9, 
   3.7683540295825453`*^9}, {3.768360687018757*^9, 3.768360690567684*^9}, {
   3.768360836913948*^9, 3.768360870061808*^9}, {3.768362929393312*^9, 
   3.7683630100169764`*^9}, {3.768363263634922*^9, 3.7683632909277687`*^9}, 
   3.768364378659745*^9, {3.768445927650215*^9, 3.768445982341642*^9}, {
   3.768446116981814*^9, 3.7684461831834*^9}, {3.769148463174594*^9, 
   3.7691486014985*^9}, {3.769148636977663*^9, 3.769148637453684*^9}, 
   3.769148876415221*^9, {3.769148950106469*^9, 3.769148978448971*^9}, {
   3.769232514167807*^9, 3.769232562070609*^9}, 3.769234573978037*^9, 
   3.7692365941040583`*^9, 3.769236638579527*^9, 3.769236691585565*^9, {
   3.769237005665834*^9, 3.7692370153122463`*^9}, 3.769237072952879*^9, 
   3.7692371840596447`*^9, 3.769237225122677*^9, {3.769239027199717*^9, 
   3.76923906716689*^9}, 3.769239204694243*^9, 3.7692392440043907`*^9, 
   3.7692392771553173`*^9, {3.769239465972308*^9, 3.7692394747954473`*^9}, {
   3.769239568946083*^9, 3.769239569427267*^9}, 3.769239600173493*^9, {
   3.769239642068406*^9, 3.7692396719305553`*^9}, {3.769294368693945*^9, 
   3.7692943792665367`*^9}, {3.769294545310809*^9, 3.7692945454212503`*^9}, 
   3.769294593670808*^9, 3.769294635741806*^9, {3.769294735439793*^9, 
   3.769294743662672*^9}, 3.7692947812617903`*^9, 3.769294814567595*^9, 
   3.769294848483879*^9, {3.769296526738426*^9, 3.769296550187208*^9}, {
   3.769380894873705*^9, 3.769380926698411*^9}, {3.7693810692918997`*^9, 
   3.769381081095044*^9}, 3.769381118088214*^9, 3.7693811838765917`*^9, {
   3.769381221795542*^9, 3.769381221936722*^9}, 3.769381258882292*^9, {
   3.7693813435922623`*^9, 3.769381353461795*^9}, {3.769381872038938*^9, 
   3.7693818809305687`*^9}, 3.769382065985149*^9, {3.7693821732981873`*^9, 
   3.769382176087906*^9}, 3.769382239807823*^9, {3.7693822953938503`*^9, 
   3.769382295679565*^9}, {3.7693824233690357`*^9, 3.7693824519189377`*^9}, 
   3.76938248268605*^9, {3.769463349221817*^9, 3.769463358061232*^9}, {
   3.769463529354628*^9, 3.769463529488366*^9}, 3.7694635759290733`*^9, 
   3.769463616503564*^9, {3.7694734491562033`*^9, 3.769473458684823*^9}, {
   3.769473499174934*^9, 3.7694735100928288`*^9}, 3.769478454625998*^9, {
   3.769549967097577*^9, 3.769549972470291*^9}, {3.7695501091180897`*^9, 
   3.769550109283161*^9}, 3.76955015213235*^9, {3.769550297859893*^9, 
   3.769550302615377*^9}, {3.769552858629641*^9, 3.769552870288088*^9}, {
   3.769722414740048*^9, 3.769722418981082*^9}, {3.769722523220148*^9, 
   3.769722523334772*^9}, 3.769722568150325*^9, 3.769722612709065*^9, {
   3.769801936893497*^9, 3.769801940388669*^9}, {3.769802043702381*^9, 
   3.769802043797587*^9}, {3.7698020850688753`*^9, 3.7698020851925383`*^9}, 
   3.76980213219438*^9, {3.7698161781942043`*^9, 3.7698162059236813`*^9}, {
   3.769888984090474*^9, 3.769888993208872*^9}, {3.769889104403906*^9, 
   3.76988910452001*^9}, 3.769889154688109*^9, 3.769889209878067*^9, {
   3.769987641035473*^9, 3.769987642658668*^9}, 3.769987761908259*^9, 
   3.7699878120740213`*^9, 3.7699878554251137`*^9, {3.7700728634456043`*^9, 
   3.770072867692896*^9}, 3.770073010047862*^9, 3.770073048818125*^9, 
   3.770073093067197*^9, {3.770327273548531*^9, 3.7703272760557756`*^9}, 
   3.770327400133696*^9, 3.770327442346348*^9, 3.770327480393338*^9, {
   3.770327555194229*^9, 3.770327558140807*^9}, 3.77032759843498*^9, 
   3.770327639714559*^9, 3.7703276886891937`*^9, {3.7703277619751377`*^9, 
   3.770327764358761*^9}, {3.770327807638945*^9, 3.7703278077390347`*^9}, {
   3.770327848742858*^9, 3.7703278488498774`*^9}, {3.770327895930848*^9, 
   3.770327917288004*^9}, {3.770407311021723*^9, 3.770407314756136*^9}, 
   3.770407421516122*^9, 3.770407470548347*^9, 3.7704075078740273`*^9, {
   3.770449860847687*^9, 3.770449868347754*^9}, 3.770449938299165*^9, {
   3.770449969098466*^9, 3.770449998797697*^9}, {3.770451649868154*^9, 
   3.770451654208795*^9}, 3.7704517052687807`*^9, {3.770451747300714*^9, 
   3.7704517757042713`*^9}, {3.7705003639729548`*^9, 3.770500373726386*^9}, 
   3.7705005374103928`*^9, 3.7705005866974783`*^9, 3.770500628535581*^9, {
   3.770586260667083*^9, 3.770586264155697*^9}, 3.7705863667560377`*^9, 
   3.77058640850174*^9, 3.770586449194078*^9, {3.770672963675316*^9, 
   3.7706729718022127`*^9}, {3.7706731592598677`*^9, 3.770673159382598*^9}, {
   3.770673800401257*^9, 3.770673800549067*^9}, 3.770673833734083*^9, 
   3.7706738855805283`*^9, {3.7706961467252417`*^9, 3.770696151112322*^9}, {
   3.770696245333955*^9, 3.770696245446419*^9}, {3.770696276793372*^9, 
   3.7706962769016237`*^9}, {3.77069631420774*^9, 3.770696315605721*^9}, {
   3.770696354556951*^9, 3.770696354670383*^9}, {3.770696390611772*^9, 
   3.770696391307727*^9}, {3.7706992566296673`*^9, 3.770699269660603*^9}, {
   3.770699302028699*^9, 3.770699309974257*^9}, 3.770699581677479*^9, {
   3.7706996421961737`*^9, 3.770699652006958*^9}, 3.770700363546873*^9, {
   3.7707004403164454`*^9, 3.770700501602756*^9}, {3.770700565237859*^9, 
   3.7707005777859583`*^9}, {3.770700610072762*^9, 3.770700613478292*^9}, {
   3.770700648116836*^9, 3.7707006526758223`*^9}, {3.7707006898068027`*^9, 
   3.770700695768117*^9}, {3.770759373420129*^9, 3.770759377060306*^9}, {
   3.770759409968938*^9, 3.7707594155044413`*^9}, 3.770759535101489*^9, 
   3.7707595798935347`*^9, {3.7707596235628357`*^9, 3.770759623753886*^9}, {
   3.770932259559348*^9, 3.7709322633616657`*^9}, 3.7709324515323067`*^9, 
   3.7709325048791933`*^9, 3.770932550267126*^9, {3.770940399239222*^9, 
   3.770940403698403*^9}, 3.770940479874001*^9, {3.770940547019635*^9, 
   3.770940547096862*^9}, 3.770940618467523*^9, {3.7710335183955393`*^9, 
   3.7710335256690893`*^9}, 3.7710336593607187`*^9, 3.771033704492672*^9, 
   3.771033752115449*^9, {3.7713758055296793`*^9, 3.771375813914033*^9}, 
   3.771375867196165*^9, {3.7713759078019133`*^9, 3.7713759079045763`*^9}, {
   3.7713759473025217`*^9, 3.771375947407235*^9}, {3.771375987147141*^9, 
   3.7713759896621027`*^9}, 3.7713760301768703`*^9, {3.77144824475369*^9, 
   3.771448252379527*^9}, {3.771448356621255*^9, 3.7714483567399054`*^9}, {
   3.771448406059434*^9, 3.7714484061842127`*^9}, 3.771448449097821*^9, {
   3.771719813033011*^9, 3.771719818731282*^9}, {3.771719925014398*^9, 
   3.7717199251619062`*^9}, {3.771719967454298*^9, 3.771719967568634*^9}, {
   3.771720034392229*^9, 3.771720048345468*^9}, {3.771803818479804*^9, 
   3.771803842613253*^9}, 3.771803884054666*^9, 3.7718039300537*^9, 
   3.771803961420128*^9, {3.7718039957210493`*^9, 3.771803996697043*^9}, 
   3.771804032500852*^9, 3.7718040634309587`*^9, {3.771805931254533*^9, 
   3.77180593536238*^9}, {3.771806048083494*^9, 3.7718060493618803`*^9}, {
   3.7718060862338533`*^9, 3.771806086339945*^9}, {3.771886753030397*^9, 
   3.771886757604693*^9}, 3.771886854644071*^9, 3.771886886886322*^9, 
   3.771886924040539*^9, 3.77188696251056*^9, {3.771890021205752*^9, 
   3.771890026881071*^9}, 3.771890141277801*^9, 3.771890195348806*^9, {
   3.771890251451132*^9, 3.771890261438568*^9}, {3.77189037564701*^9, 
   3.7718903824472103`*^9}, 3.7718904517220917`*^9, {3.7718905405922747`*^9, 
   3.7718905487233067`*^9}, 3.77189059062516*^9, {3.77199101902297*^9, 
   3.771991041956847*^9}, 3.771991119702375*^9, 3.771991153379755*^9, {
   3.771991187545292*^9, 3.771991187660143*^9}, 3.771991224257266*^9, {
   3.771991420594789*^9, 3.7719914276122*^9}, 3.7719914666767073`*^9, 
   3.771991508429235*^9, 3.771991573673356*^9, {3.773704832979126*^9, 
   3.773704837064466*^9}, {3.773705021731648*^9, 3.7737050221467323`*^9}, {
   3.777692800982594*^9, 3.777692804672689*^9}, {3.7776981941564407`*^9, 
   3.7776981942230787`*^9}, {3.777698250424473*^9, 3.777698250502553*^9}, 
   3.777698486953361*^9, 3.777777343436926*^9, {3.7777774344828672`*^9, 
   3.777777451858028*^9}, {3.777777482322331*^9, 3.777777600766563*^9}, {
   3.7777776539951973`*^9, 3.777777725222878*^9}, {3.777777780256171*^9, 
   3.777777841355088*^9}, {3.777857033695881*^9, 3.777857037404131*^9}, {
   3.777949947987157*^9, 3.7779499513396177`*^9}, {3.7779499838977337`*^9, 
   3.777949984013072*^9}, {3.777950145528701*^9, 3.777950145639765*^9}, {
   3.777950486456347*^9, 3.777950489873736*^9}, {3.778642735770196*^9, 
   3.778642849460227*^9}, {3.7786428852375193`*^9, 3.77864303312584*^9}, 
   3.7786430707854443`*^9, {3.778643125834008*^9, 3.778643143464498*^9}, 
   3.77864329630895*^9, {3.7786433333384323`*^9, 3.7786433509885178`*^9}, {
   3.778643844865713*^9, 3.7786438597991867`*^9}, 3.7786440536400213`*^9, {
   3.7787187132768593`*^9, 3.778718782952497*^9}, {3.779141462278232*^9, 
   3.779141483173881*^9}, {3.779141524760337*^9, 3.779141561054617*^9}, {
   3.780979982996441*^9, 3.780980018145775*^9}, {3.7809801141652946`*^9, 
   3.7809801578089647`*^9}, {3.781237869609852*^9, 3.781237878305602*^9}, {
   3.781237945282557*^9, 3.781237994783659*^9}, {3.781238595949871*^9, 
   3.7812386225565653`*^9}, {3.781238675740679*^9, 3.781238721645755*^9}, {
   3.78124017423538*^9, 3.7812401808701267`*^9}, {3.781240212437786*^9, 
   3.781240242034047*^9}, 3.781240315804762*^9, 3.781420265537575*^9, {
   3.781420325464979*^9, 3.781420426006241*^9}, {3.781503450466505*^9, 
   3.781503549762433*^9}, {3.781503582531954*^9, 3.781503634011334*^9}, {
   3.781503698530367*^9, 3.781503715195465*^9}, {3.7815068918861628`*^9, 
   3.781506909774128*^9}, {3.78150694297078*^9, 3.781506965929729*^9}, 
   3.781506996921496*^9, {3.781508324056897*^9, 3.7815084549973183`*^9}, {
   3.781596920829542*^9, 3.7815969251537313`*^9}, {3.781596973133217*^9, 
   3.781597003223895*^9}, {3.781597692554797*^9, 3.781597696059132*^9}, {
   3.781597729305653*^9, 3.781597729437037*^9}, 3.781597760670885*^9, {
   3.7819347623295918`*^9, 3.781934819421792*^9}, {3.781935352415497*^9, 
   3.781935449769722*^9}, {3.7819385035983753`*^9, 3.781938507078648*^9}, {
   3.7819385448715143`*^9, 3.781938629289658*^9}, {3.781938765485681*^9, 
   3.781938802567466*^9}, {3.781938842867323*^9, 3.7819388734369802`*^9}, {
   3.7820163192919207`*^9, 3.782016323498208*^9}, {3.782016361606022*^9, 
   3.782016405145561*^9}, {3.782016699926303*^9, 3.782016769544442*^9}, {
   3.7820169524298573`*^9, 3.782017019330868*^9}, {3.782017207632869*^9, 
   3.7820172692887583`*^9}, {3.7820192762090693`*^9, 3.782019348087275*^9}, {
   3.782020085329238*^9, 3.7820201005314617`*^9}, {3.7820201316249657`*^9, 
   3.7820201953452*^9}, {3.782020274194117*^9, 3.782020362028639*^9}, {
   3.791252037527584*^9, 3.791252075237915*^9}, {3.791252105275255*^9, 
   3.791252105675486*^9}, {3.791252217243536*^9, 3.791252224882812*^9}, {
   3.79125226682308*^9, 3.791252266938013*^9}, {3.791513015776469*^9, 
   3.7915130202640743`*^9}, {3.791513066877633*^9, 3.791513067307373*^9}, {
   3.794540961288199*^9, 3.794540966494842*^9}, {3.794541264151041*^9, 
   3.794541319537079*^9}, {3.794710566119473*^9, 3.7947105899783173`*^9}, {
   3.7947106573219624`*^9, 3.7947106731166162`*^9}, 3.794710710060294*^9, {
   3.7947112392393*^9, 3.794711244274576*^9}, {3.794711328664662*^9, 
   3.794711351757372*^9}, {3.7947116973091993`*^9, 3.794711720247444*^9}, {
   3.794711754021579*^9, 3.7947117793840227`*^9}, {3.7964426948138933`*^9, 
   3.796442720547214*^9}, {3.796442760053018*^9, 3.796442772740658*^9}, {
   3.796442813422063*^9, 3.7964428415354156`*^9}, {3.796443305276712*^9, 
   3.7964433446710463`*^9}, 3.7964433834501877`*^9, {3.796444492538656*^9, 
   3.7964445205525084`*^9}, {3.796445029244927*^9, 3.796445076497448*^9}, {
   3.796447435583413*^9, 3.796447477967819*^9}, {3.796448008406083*^9, 
   3.796448031669694*^9}, {3.796448313582965*^9, 3.796448353879711*^9}, {
   3.796448691732766*^9, 3.79644873209503*^9}, {3.796524763852955*^9, 
   3.796524837425096*^9}, {3.7966184813119707`*^9, 3.796618527974843*^9}, {
   3.796622309141144*^9, 3.796622356923642*^9}, {3.796713533195108*^9, 
   3.796713569030098*^9}, {3.796962897140727*^9, 3.796963040928763*^9}, {
   3.7971301959788933`*^9, 3.797130245424749*^9}, {3.797131942078402*^9, 
   3.797131996849019*^9}, {3.797132049570005*^9, 3.7971320817559967`*^9}, {
   3.797135940137431*^9, 3.7971359922638683`*^9}, {3.797136177173243*^9, 
   3.79713621835884*^9}, {3.8049745248838177`*^9, 3.8049745329075537`*^9}, {
   3.804974615956377*^9, 3.80497471079776*^9}, {3.8049747838075867`*^9, 
   3.804974830032165*^9}, {3.804974905817008*^9, 3.804974908919012*^9}, {
   3.8049749465245047`*^9, 3.8049750624987288`*^9}, {3.804975107107746*^9, 
   3.80497515700071*^9}, 3.804975212169436*^9, {3.805060093867537*^9, 
   3.805060132088538*^9}}]
},
WindowSize->{1036, 647},
WindowMargins->{{Automatic, 66}, {Automatic, 43}},
Magnification:>1.25 Inherited,
FrontEndVersion->"10.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (2014\:5e7412\
\:67084\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[400, 13, 88768, 1750, 5559, "Input"]
}
]
*)

