(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     79165,       1703]
NotebookOptionsPosition[     78735,       1685]
NotebookOutlinePosition[     79174,       1703]
CellTagsIndexPosition[     79131,       1700]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Program", " ", "to", " ", "calculate", " ", "vorticity", " ", "for", " ", 
    "simulationdata"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"By", " ", "Koichiro", " ", "Uriu"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "\"\<workingdirectory\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rc", "=", "11"}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{"cell", " ", "diameter"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"r", "=", "25"}], ";", 
    RowBox[{"(*", 
     RowBox[{"tube", " ", "radius"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"R", "=", "60"}], ";", 
    RowBox[{"(*", 
     RowBox[{"torus", " ", "radius"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Delta]r", "=", "rc"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]x", "=", "5"}], ";", 
    RowBox[{"\[CapitalDelta]y", "=", "2"}], ";", 
    RowBox[{"\[CapitalDelta]z", "=", "2"}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{"lattice", " ", "size"}], " ", "*)"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Rho]", "=", 
     RowBox[{"rc", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Delta]\[Rho]", "=", "14"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n\[Phi]", "=", "6"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Lx", "=", 
     RowBox[{"300", "+", "60", "+", "25"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Ly", "=", 
     RowBox[{"120", "+", "50"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Lz", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"lr", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"2", "*", "r"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "*", "R"}], ",", "Ly"}], "}"}]}], "}"}]}], ";"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lr", "=", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "*", "R"}], ",", "Ly"}], "}"}], "}"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"right", " ", "psm"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"nlr", "=", 
     RowBox[{"Length", "[", "lr", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"yslice", " ", "position"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yslice", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
          "lr", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
          "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
           "lr", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "+", 
          "20"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
           "lr", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "-", 
          "20"}], ",", 
         RowBox[{
          RowBox[{
          "lr", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
          "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "}"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nyslice", "=", 
     RowBox[{"Length", "[", "yslice", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"zslice", " ", "position"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slice", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lz", "-", "20"}], ",", "Lz"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"slice", "=", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lz", "-", "20"}], ",", "Lz"}], "}"}], "}"}]}], ";"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nslice", "=", 
     RowBox[{"Length", "[", "slice", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dt", "=", "1.0"}], ";", 
    RowBox[{"(*", 
     RowBox[{"time", " ", "step"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"pr", "=", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"loading", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"\"\<cell_phase.dat\>\"", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"Number", ",", 
         RowBox[{"{", "4", "}"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ncell", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"\"\<cell_number_v2.dat\>\"", ",", "Number"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lxa", "=", 
     RowBox[{"ReadList", "[", 
      RowBox[{"\"\<PSM_length.dat\>\"", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"Number", ",", 
         RowBox[{"{", "3", "}"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"imax", "=", 
     RowBox[{"Length", "[", "ncell", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"a", "=", 
      RowBox[{"Partition", "[", 
       RowBox[{"a", ",", "numcell"}], "]"}]}], ";", 
     RowBox[{"imax", "=", 
      RowBox[{"Length", "[", "a", "]"}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"imax", "=", "601"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vt", "=", 
     RowBox[{"Transpose", "[", "v", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ip", "=", 
     RowBox[{"vt", "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"vt", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"vt", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{
        "vt", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], "}"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R0", "=", "0.75"}], ";", 
    RowBox[{"(*", 
     RowBox[{"threshold", " ", "for", " ", "correlation"}], "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Function", " ", "for", " ", "mean", " ", "phase"}], " ", "*)"}],
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"meanphase", "[", "list_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", "avecos", ",", "avesin", ",", "tan", ",", "q"}], 
        "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"avecos", "=", 
         RowBox[{"Mean", "[", 
          RowBox[{"Cos", "[", "list", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"avesin", "=", 
         RowBox[{"Mean", "[", 
          RowBox[{"Sin", "[", "list", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"q", "=", 
         RowBox[{"ArcTan", "[", 
          RowBox[{"avecos", ",", "avesin"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"q", "<", "0"}], ",", 
          RowBox[{"q", "=", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "Pi"}]}]}]}], "]"}], ";", "q"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Function", " ", "for", " ", "rearrangement"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"permutcw", "[", 
      RowBox[{"mmin_", ",", "n_", ",", "j_", ",", "\[Phi]_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", "\[CurlyPhi]"}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{
        RowBox[{"\[CurlyPhi]", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ";", 
        RowBox[{
         RowBox[{
         "\[CurlyPhi]", "\[LeftDoubleBracket]", "1", 
          "\[RightDoubleBracket]"}], "=", 
         RowBox[{
          RowBox[{
          "\[Phi]", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
          "\[LeftDoubleBracket]", "mmin", "\[RightDoubleBracket]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"m", "=", "1"}], ",", 
          RowBox[{"m", "\[LessEqual]", 
           RowBox[{"n", "-", "1"}]}], ",", 
          RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"mmin", "+", "m"}], "<=", "n"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"\[CurlyPhi]", "\[LeftDoubleBracket]", 
                RowBox[{"m", "+", "1"}], "\[RightDoubleBracket]"}], "=", 
               RowBox[{
                RowBox[{
                "\[Phi]", "\[LeftDoubleBracket]", "j", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                RowBox[{"mmin", "+", "m"}], "\[RightDoubleBracket]"}]}], 
              ";"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"\[CurlyPhi]", "\[LeftDoubleBracket]", 
                RowBox[{"m", "+", "1"}], "\[RightDoubleBracket]"}], "=", 
               RowBox[{
                RowBox[{
                "\[Phi]", "\[LeftDoubleBracket]", "j", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                RowBox[{"mmin", "+", "m", "-", "n"}], 
                "\[RightDoubleBracket]"}]}], ";"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "\[CurlyPhi]"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"permutccw", "[", 
      RowBox[{"mmin_", ",", "n_", ",", "j_", ",", "\[Phi]_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", "\[CurlyPhi]"}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{
        RowBox[{"\[CurlyPhi]", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ";", 
        RowBox[{
         RowBox[{
         "\[CurlyPhi]", "\[LeftDoubleBracket]", "1", 
          "\[RightDoubleBracket]"}], "=", 
         RowBox[{
          RowBox[{
          "\[Phi]", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
          "\[LeftDoubleBracket]", "mmin", "\[RightDoubleBracket]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"m", "=", "1"}], ",", 
          RowBox[{"m", "\[LessEqual]", 
           RowBox[{"n", "-", "1"}]}], ",", 
          RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"mmin", "-", "m"}], "\[GreaterEqual]", "1"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"\[CurlyPhi]", "\[LeftDoubleBracket]", 
                RowBox[{"m", "+", "1"}], "\[RightDoubleBracket]"}], "=", 
               RowBox[{
                RowBox[{
                "\[Phi]", "\[LeftDoubleBracket]", "j", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                RowBox[{"mmin", "-", "m"}], "\[RightDoubleBracket]"}]}], 
              ";"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"\[CurlyPhi]", "\[LeftDoubleBracket]", 
                RowBox[{"m", "+", "1"}], "\[RightDoubleBracket]"}], "=", 
               RowBox[{
                RowBox[{
                "\[Phi]", "\[LeftDoubleBracket]", "j", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                RowBox[{"mmin", "-", "m", "+", "n"}], 
                "\[RightDoubleBracket]"}]}], ";"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "\[CurlyPhi]"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"calculation", " ", "of", " ", "correlation"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"correlation", "[", 
      RowBox[{"n_", ",", "\[CurlyPhi]_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "xave", ",", "\[CurlyPhi]ave", ",", "l", ",", "\[Sigma]x", ",", 
         "\[Sigma]\[CurlyPhi]", ",", "c", ",", "m"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"xave", "=", 
         RowBox[{"Mean", "[", 
          RowBox[{"Table", "[", 
           RowBox[{"l", ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "1", ",", "n"}], "}"}]}], "]"}], "]"}]}], ";", 
        
        RowBox[{"\[CurlyPhi]ave", "=", 
         RowBox[{"Mean", "[", "\[CurlyPhi]", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Sigma]x", "=", 
         RowBox[{"StandardDeviation", "[", 
          RowBox[{"Table", "[", 
           RowBox[{"l", ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "1", ",", "n"}], "}"}]}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Sigma]\[CurlyPhi]", "=", 
         RowBox[{"StandardDeviation", "[", "\[CurlyPhi]", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"c", "=", "0"}], ";", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"m", "=", "1"}], ",", 
          RowBox[{"m", "\[LessEqual]", "n"}], ",", 
          RowBox[{"m", "++"}], ",", 
          RowBox[{
           RowBox[{"c", "=", 
            RowBox[{"c", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"m", "-", "xave"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                "\[CurlyPhi]", "\[LeftDoubleBracket]", "m", 
                 "\[RightDoubleBracket]"}], "-", "\[CurlyPhi]ave"}], 
               ")"}]}]}]}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"c", "=", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"n", "*", "\[Sigma]x", "*", "\[Sigma]\[CurlyPhi]"}], 
           ")"}]}]}], ";", "c"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "pick", " ", "up", " ", "phases", " ", "from", " ", "the", " ", "forcal", 
     " ", "Z", " ", "plane"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"inttophase", "[", 
      RowBox[{
      "a_", ",", "ip_", ",", "i_", ",", "numcell_", ",", "zmin_", ",", 
       "zmax_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "as", ",", "j", ",", "x", ",", "y", ",", "z", ",", "si", ",", 
         "\[Theta]"}], "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"as", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"j", "=", "1"}], ",", 
          RowBox[{"j", "\[LessEqual]", "numcell"}], ",", 
          RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x", "=", 
            RowBox[{
             RowBox[{
             "a", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
             "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";", 
           RowBox[{"y", "=", 
            RowBox[{
             RowBox[{
             "a", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
             "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], ";", 
           RowBox[{"z", "=", 
            RowBox[{
             RowBox[{
             "a", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
             "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], ";", 
           RowBox[{"\[Theta]", "=", 
            RowBox[{
            "ip", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"zmin", "\[LessEqual]", "z"}], "&&", 
              RowBox[{"z", "\[LessEqual]", "zmax"}]}], ",", 
             RowBox[{
              RowBox[{"AppendTo", "[", 
               RowBox[{"as", ",", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "\[Theta]"}], "}"}]}], "]"}], 
              ";"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "as"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "pick", " ", "up", " ", "phases", " ", "from", " ", "the", " ", "forcal", 
     " ", "Y", " ", "plane"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"phaseYplane", "[", 
      RowBox[{
      "a_", ",", "ip_", ",", "i_", ",", "numcell_", ",", "ymin_", ",", 
       "ymax_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "as", ",", "j", ",", "x", ",", "y", ",", "z", ",", "si", ",", 
         "\[Theta]"}], "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"as", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"j", "=", "1"}], ",", 
          RowBox[{"j", "\[LessEqual]", "numcell"}], ",", 
          RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x", "=", 
            RowBox[{
             RowBox[{
             "a", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
             "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";", 
           RowBox[{"y", "=", 
            RowBox[{
             RowBox[{
             "a", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
             "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], ";", 
           RowBox[{"z", "=", 
            RowBox[{
             RowBox[{
             "a", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
             "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], ";", 
           RowBox[{"\[Theta]", "=", 
            RowBox[{
            "ip", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"ymin", "\[LessEqual]", "y"}], "&&", 
              RowBox[{"y", "\[LessEqual]", "ymax"}]}], ",", 
             RowBox[{
              RowBox[{"AppendTo", "[", 
               RowBox[{"as", ",", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "z", ",", "\[Theta]"}], "}"}]}], "]"}], 
              ";"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "as"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plot", " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"plotfunc", "[", 
      RowBox[{"vor_", ",", "imax_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "g", "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"g", "=", 
         RowBox[{"ListDensityPlot", "[", 
          RowBox[{"vor", ",", "\[IndentingNewLine]", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "imax"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "320"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"BarLegend", "[", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ColorFunction", "\[Rule]", 
            RowBox[{"ColorData", "[", 
             RowBox[{"{", 
              RowBox[{"\"\<SunsetColors\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"AspectRatio", "\[Rule]", "0.5"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ImageSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"360", ",", "240"}], "}"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", 
                  "500", ",", "600", ",", "700"}], "}"}], ",", "None"}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", 
                  "500", ",", "600", ",", "700"}], "}"}], ",", "None"}], 
               "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"FrameStyle", "\[Rule]", 
            RowBox[{"Directive", "[", "Black", "]"}]}]}], 
          "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"g5", "=", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"0.66", "*", "x"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "0", ",", "imax"}], "}"}], ",", 
           RowBox[{"PlotRange", "->", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "imax"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "650"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "White"}], ",", 
           RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
           RowBox[{"FillingStyle", "\[Rule]", "Black"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Show", "[", 
          RowBox[{"g", ",", "g5"}], "]"}], "*)"}], 
        RowBox[{"(*", " ", 
         RowBox[{"for", " ", "PSM", " ", "length", " ", "change"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Show", "[", "g", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"projection", "[", 
      RowBox[{"gr_", ",", "as_", ",", "ngrx_", ",", "ngry_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "grx", ",", "\[Phi]", ",", "gry", ",", "x", ",", "y", ",", "k", ",", 
         "ds", ",", "\[Phi]k", ",", "m", ",", "j", ",", "nas", ",", 
         "\[Phi]min", ",", "mmin", ",", "\[CurlyPhi]cw", ",", 
         "\[CurlyPhi]ccw", ",", "v", ",", "mmax", ",", "ccw", ",", "cccw", 
         ",", "q"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nas", "=", 
         RowBox[{"Length", "[", "as", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"grx", "=", "1"}], ",", 
          RowBox[{"grx", "\[LessEqual]", "ngrx"}], ",", 
          RowBox[{"grx", "++"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"\[Phi]", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"l", ",", "1", ",", "ngry"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "1", ",", "n\[Phi]"}], "}"}]}], "]"}]}], ";",
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"gry", "=", "1"}], ",", 
             RowBox[{"gry", "\[LessEqual]", "ngry"}], ",", 
             RowBox[{"gry", "++"}], ",", "\[IndentingNewLine]", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"x", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "gr", "\[LeftDoubleBracket]", "grx", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "gry", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                "\[RightDoubleBracket]"}]}], ";", 
              RowBox[{"y", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "gr", "\[LeftDoubleBracket]", "grx", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "gry", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                "\[RightDoubleBracket]"}]}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"(*", " ", 
               RowBox[{
               "calculation", " ", "of", " ", "mean", " ", "phase", " ", 
                "for", " ", "each", " ", "\[Phi]"}], " ", "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"k", "=", "1"}], ",", 
                RowBox[{"k", "\[LessEqual]", "nas"}], ",", 
                RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "as", "\[LeftDoubleBracket]", "k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", "x"}], "]"}], 
                    "\[LessEqual]", 
                    RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}]}], ",", 
                   "\[IndentingNewLine]", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"ds", "=", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "as", "\[LeftDoubleBracket]", "k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", "x"}], ")"}], "^", "2"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "as", "\[LeftDoubleBracket]", "k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "-", "y"}], ")"}], "^", 
                    "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"\[Rho]", "\[LessEqual]", "ds"}], "&&", 
                    RowBox[{"ds", "\[LessEqual]", 
                    RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}]}]}], ",", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"\[Phi]k", "=", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "as", "\[LeftDoubleBracket]", "k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", "x"}], ")"}], "/", "ds"}],
                     ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "as", "\[LeftDoubleBracket]", "k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "-", "y"}], ")"}], "/", 
                    "ds"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"\[Phi]k", "<", "0"}], ",", 
                    RowBox[{"\[Phi]k", "=", 
                    RowBox[{"\[Phi]k", "+", 
                    RowBox[{"2", "*", "Pi"}]}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"m", "=", "0"}], ",", 
                    RowBox[{"m", "\[LessEqual]", 
                    RowBox[{"n\[Phi]", "-", "1"}]}], ",", 
                    RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"2", "*", "Pi", "*", 
                    RowBox[{"m", "/", "n\[Phi]"}]}], "\[LessEqual]", 
                    "\[Phi]k"}], "&&", 
                    RowBox[{"\[Phi]k", "<=", 
                    RowBox[{"2", "*", "Pi", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "/", "n\[Phi]"}]}]}]}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "gry", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"m", "+", "1"}], "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    "as", "\[LeftDoubleBracket]", "k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "3", 
                    "\[RightDoubleBracket]"}]}], "]"}], ";", 
                    RowBox[{"Break", "[", "]"}], ";"}]}], 
                    "\[IndentingNewLine]", "]"}], ";"}]}], 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
                    ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    "]"}], ";"}]}], "\[IndentingNewLine]", 
                  "\[IndentingNewLine]", "]"}], ";"}]}], 
               "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"j", "=", "gry"}], ";", "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"m", "=", "1"}], ",", 
                RowBox[{"m", "\[LessEqual]", "n\[Phi]"}], ",", 
                RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "m", 
                    "\[RightDoubleBracket]"}], "]"}], ">", "0"}], ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "m", 
                    "\[RightDoubleBracket]"}], "=", 
                    RowBox[{"meanphase", "[", 
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "m", 
                    "\[RightDoubleBracket]"}], "]"}]}], ";"}], ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "m", 
                    "\[RightDoubleBracket]"}], "=", 
                    RowBox[{"-", "1"}]}], ";"}]}], "]"}], ";"}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"\[Phi]min", "=", 
               RowBox[{"4", "*", "Pi"}]}], ";", 
              RowBox[{"mmin", "=", "1"}], ";", "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"m", "=", "1"}], ",", 
                RowBox[{"m", "\[LessEqual]", "n\[Phi]"}], ",", 
                RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "m", 
                    "\[RightDoubleBracket]"}], "\[LessEqual]", "\[Phi]min"}], 
                   ",", 
                   RowBox[{
                    RowBox[{"\[Phi]min", "=", 
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "m", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"mmin", "=", "m"}], ";"}]}], "]"}], ";"}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"(*", " ", "permutation", " ", "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{"\[CurlyPhi]cw", "=", 
               RowBox[{"permutcw", "[", 
                RowBox[{"mmin", ",", "n\[Phi]", ",", "j", ",", "\[Phi]"}], 
                "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"\[CurlyPhi]ccw", "=", 
               RowBox[{"permutccw", "[", 
                RowBox[{"mmin", ",", "n\[Phi]", ",", "j", ",", "\[Phi]"}], 
                "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"\[Phi]min", ">", "0"}], ",", "\[IndentingNewLine]", 
                RowBox[{"(*", 
                 RowBox[{"clock", " ", "wise"}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"mmin", "\[Equal]", "1"}], ",", 
                   RowBox[{
                    RowBox[{"mmax", "=", "n\[Phi]"}], ";"}], ",", 
                   RowBox[{
                    RowBox[{"mmax", "=", 
                    RowBox[{"mmin", "-", "1"}]}], ";"}]}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"ccw", "=", 
                  RowBox[{"correlation", "[", 
                   RowBox[{"n\[Phi]", ",", "\[CurlyPhi]cw"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"v", "=", 
                  RowBox[{"N", "[", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "mmax",
                     "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "mmin",
                     "\[RightDoubleBracket]"}]}], "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "Pi"}], ")"}]}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"ccw", ">", "R0"}], ",", 
                   RowBox[{
                    RowBox[{"q", "=", "v"}], ";"}], " ", ",", 
                   RowBox[{
                    RowBox[{"q", "=", "0"}], ";"}]}], "]"}], ";", 
                 RowBox[{"(*", "thresholding", "*)"}], "\[IndentingNewLine]", 
                 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"q", ">", 
                    RowBox[{
                    RowBox[{
                    "vortcw", "\[LeftDoubleBracket]", "grx", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "3", 
                    "\[RightDoubleBracket]"}]}], ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "vortcw", "\[LeftDoubleBracket]", "grx", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "3", 
                    "\[RightDoubleBracket]"}], "=", "q"}], ";"}]}], "]"}], 
                 ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 RowBox[{"(*", 
                  RowBox[{"counter", " ", "clock", " ", "wise"}], "*)"}], 
                 "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"mmin", "\[Equal]", "n\[Phi]"}], ",", 
                   RowBox[{
                    RowBox[{"mmax", "=", "1"}], ";"}], ",", 
                   RowBox[{
                    RowBox[{"mmax", "=", 
                    RowBox[{"mmin", "+", "1"}]}], ";"}]}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"cccw", "=", 
                  RowBox[{"correlation", "[", 
                   RowBox[{"n\[Phi]", ",", "\[CurlyPhi]ccw"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"v", "=", 
                  RowBox[{"N", "[", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "mmax",
                     "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    RowBox[{
                    "\[Phi]", "\[LeftDoubleBracket]", "j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "mmin",
                     "\[RightDoubleBracket]"}]}], "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "Pi"}], ")"}]}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"cccw", ">", "R0"}], ",", 
                   RowBox[{
                    RowBox[{"q", "=", "v"}], ";"}], ",", 
                   RowBox[{
                    RowBox[{"q", "=", "0"}], ";"}]}], "]"}], ";", 
                 RowBox[{"(*", "thresholding", "*)"}], "\[IndentingNewLine]", 
                 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"q", ">", 
                    RowBox[{
                    RowBox[{
                    "vortccw", "\[LeftDoubleBracket]", "grx", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "3", 
                    "\[RightDoubleBracket]"}]}], ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "vortccw", "\[LeftDoubleBracket]", "grx", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "3", 
                    "\[RightDoubleBracket]"}], "=", "q"}], ";"}]}], "]"}], 
                 ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}],
               ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
           ";"}]}], 
         RowBox[{"(*", " ", 
          RowBox[{"end", " ", "of", " ", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"gry", "=", "1"}], ",", 
             RowBox[{"gry", "\[LessEqual]", "ngry"}], ",", 
             RowBox[{"gry", "++"}], ","}], " "}]}], "*)"}], 
         "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}]}], 
      RowBox[{"(*", " ", 
       RowBox[{"end", " ", "of", " ", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"grx", "=", "1"}], ",", 
          RowBox[{"grx", "\[LessEqual]", "ngrx"}], ",", 
          RowBox[{"grx", "++"}], ","}], " "}]}], "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.703920673283646*^9, 3.703920706483222*^9}, {
   3.704405301160741*^9, 3.704405363047023*^9}, {3.704405470761257*^9, 
   3.704405470912669*^9}, {3.704406090617378*^9, 3.704406091392035*^9}, {
   3.7044107476586533`*^9, 3.704410748503662*^9}, {3.704410863422865*^9, 
   3.704410864526165*^9}, {3.704410954036009*^9, 3.704410954572073*^9}, {
   3.704426683054594*^9, 3.7044266833535357`*^9}, {3.704427425608712*^9, 
   3.704427428413403*^9}, 3.7044307646398573`*^9, {3.7044309947204723`*^9, 
   3.704431007141247*^9}, {3.704431097035046*^9, 3.704431104655798*^9}, {
   3.704435095959976*^9, 3.7044351044133387`*^9}, {3.7045004940113*^9, 
   3.70450065221852*^9}, {3.704500697396883*^9, 3.70450069774885*^9}, {
   3.704518037399036*^9, 3.7045180642302713`*^9}, {3.704586341102112*^9, 
   3.704586413249288*^9}, {3.704586484359621*^9, 3.704586486223095*^9}, {
   3.7045867195756807`*^9, 3.704586729461708*^9}, {3.704586765974702*^9, 
   3.704586766077856*^9}, {3.704586805553935*^9, 3.704586840806858*^9}, {
   3.7045869046062727`*^9, 3.704586905508686*^9}, {3.704586941824033*^9, 
   3.704586941894245*^9}, {3.7045871120628138`*^9, 3.704587112116466*^9}, {
   3.704587205012644*^9, 3.704587205175975*^9}, {3.7045873648874397`*^9, 
   3.7045873670219593`*^9}, {3.704587422970582*^9, 3.7045874255478067`*^9}, {
   3.704587463086788*^9, 3.704587489796281*^9}, {3.7045875247260017`*^9, 
   3.7045875248142548`*^9}, {3.704587580821725*^9, 3.704587591818203*^9}, 
   3.704592327602709*^9, {3.704667773794339*^9, 3.704667809406713*^9}, {
   3.704667892975109*^9, 3.704667893021975*^9}, {3.704668054954771*^9, 
   3.7046680557616873`*^9}, {3.704668128320279*^9, 3.7046681286148243`*^9}, {
   3.705213321951838*^9, 3.705213365652173*^9}, {3.705375868919729*^9, 
   3.7053758870259733`*^9}, {3.705376938791834*^9, 3.7053769539017057`*^9}, {
   3.70537838959379*^9, 3.705378395639983*^9}, {3.7053790120820513`*^9, 
   3.705379020069265*^9}, {3.705387521469584*^9, 3.705387537959099*^9}, {
   3.7053892023898*^9, 3.7053892072202473`*^9}, {3.705466503353541*^9, 
   3.705466520078533*^9}, {3.7059821369214*^9, 3.70598215100105*^9}, {
   3.7060392000959272`*^9, 3.706039214575514*^9}, {3.706042170244268*^9, 
   3.706042170371561*^9}, {3.7060923148751163`*^9, 3.7060923149499617`*^9}, {
   3.706247344147008*^9, 3.706247364643654*^9}, {3.706247770059724*^9, 
   3.70624777459238*^9}, {3.706248173953136*^9, 3.706248178788083*^9}, {
   3.706253911590864*^9, 3.706253939113308*^9}, {3.706254657545512*^9, 
   3.7062546636727457`*^9}, {3.7062555517304707`*^9, 3.706255558701723*^9}, {
   3.706302562875277*^9, 3.706302589745586*^9}, 3.706303544496977*^9, {
   3.706323524842416*^9, 3.706323546226411*^9}, 3.706324184872366*^9, {
   3.706329602440035*^9, 3.706329624450658*^9}, 3.7063303715429697`*^9, {
   3.706346542040739*^9, 3.7063465539528103`*^9}, {3.7063861258736763`*^9, 
   3.706386136865041*^9}, {3.706405886876423*^9, 3.7064059127741528`*^9}, {
   3.706589026542453*^9, 3.706589050204616*^9}, {3.706589095494876*^9, 
   3.7065891142309217`*^9}, {3.706589444544633*^9, 3.706589463635991*^9}, {
   3.706589513328561*^9, 3.7065895134327307`*^9}, {3.715145421510784*^9, 
   3.715145506773486*^9}, {3.715145555138973*^9, 3.715145628234169*^9}, {
   3.715145686569903*^9, 3.715145691953577*^9}, 3.71514572217597*^9, 
   3.7151457586788263`*^9, {3.715145863035377*^9, 3.715145863098164*^9}, 
   3.715146010979452*^9, {3.715146076579818*^9, 3.715146104281872*^9}, {
   3.715146146068351*^9, 3.71514614639578*^9}, {3.7151461903829823`*^9, 
   3.715146190467415*^9}, {3.715146239367594*^9, 3.715146281967907*^9}, {
   3.715146985723222*^9, 3.715147076118794*^9}, {3.715147164872064*^9, 
   3.715147212568688*^9}, {3.715149108331367*^9, 3.715149148856842*^9}, {
   3.715149180441575*^9, 3.715149183603128*^9}, 3.7151492233423147`*^9, {
   3.715149952129222*^9, 3.71514996304591*^9}, {3.7151509453048353`*^9, 
   3.715151071479463*^9}, {3.7151511047186937`*^9, 3.7151512104742928`*^9}, {
   3.715151274849552*^9, 3.715151480950886*^9}, {3.715151593783949*^9, 
   3.715151593869969*^9}, 3.715151657263906*^9, {3.715151880228532*^9, 
   3.715151884420579*^9}, {3.715151994443304*^9, 3.7151520297659197`*^9}, {
   3.71515235872031*^9, 3.7151523754053783`*^9}, {3.715153225766185*^9, 
   3.715153256990336*^9}, {3.715153343871229*^9, 3.7151533560185623`*^9}, {
   3.715153523804574*^9, 3.715153547501902*^9}, {3.71515373408947*^9, 
   3.715153736403014*^9}, {3.715153846664957*^9, 3.715153880272689*^9}, {
   3.715234037675416*^9, 3.715234136390231*^9}, {3.7152342038786*^9, 
   3.715234210740808*^9}, {3.715234903304339*^9, 3.715234924960245*^9}, {
   3.715234974517107*^9, 3.715235010530583*^9}, {3.715235044889984*^9, 
   3.715235101662665*^9}, {3.715235144929852*^9, 3.715235147456869*^9}, {
   3.715235440259807*^9, 3.715235477424366*^9}, {3.715235734907919*^9, 
   3.715235756161409*^9}, {3.715236152790104*^9, 3.715236211952428*^9}, {
   3.715236254659957*^9, 3.7152363738720922`*^9}, {3.715236600070409*^9, 
   3.715236714060183*^9}, {3.715236769560207*^9, 3.7152367953166513`*^9}, {
   3.715237013128186*^9, 3.715237084054138*^9}, {3.7152371702921047`*^9, 
   3.715237196024877*^9}, {3.71523725584138*^9, 3.7152374379173193`*^9}, {
   3.715237475541931*^9, 3.715237477323881*^9}, {3.715237529360404*^9, 
   3.715237529534683*^9}, {3.715237608249049*^9, 3.715237643045982*^9}, {
   3.715237776858254*^9, 3.715237867777976*^9}, {3.7152411926073112`*^9, 
   3.715241194108626*^9}, {3.715241271853709*^9, 3.7152412743072863`*^9}, {
   3.71524132453939*^9, 3.715241329304281*^9}, {3.715241380661137*^9, 
   3.715241405100601*^9}, {3.715292015128831*^9, 3.715292022770482*^9}, {
   3.7152924056874447`*^9, 3.7152924112420073`*^9}, {3.715292905383897*^9, 
   3.715292909364859*^9}, {3.715292946973056*^9, 3.715292995025629*^9}, {
   3.7152930737098207`*^9, 3.715293106068757*^9}, {3.715293175136932*^9, 
   3.715293178193124*^9}, {3.7152932778079967`*^9, 3.71529329281948*^9}, {
   3.715293551840939*^9, 3.715293555790242*^9}, {3.715293617292836*^9, 
   3.715293621772682*^9}, {3.715295101177462*^9, 3.715295104552903*^9}, {
   3.715295189453079*^9, 3.7152951930532312`*^9}, {3.715295369106921*^9, 
   3.715295374224443*^9}, {3.7155542776908484`*^9, 3.715554282762055*^9}, {
   3.7155546348915863`*^9, 3.715554648799527*^9}, {3.715554749215873*^9, 
   3.715554759157175*^9}, {3.7155548819557667`*^9, 3.715554882304823*^9}, {
   3.715555168478736*^9, 3.715555171924416*^9}, {3.715555210223913*^9, 
   3.7155552498388987`*^9}, {3.715555330674733*^9, 3.7155553620909348`*^9}, {
   3.715555431632133*^9, 3.715555474405978*^9}, 3.715555535747705*^9, {
   3.715555611153125*^9, 3.715555620361117*^9}, {3.715555724834444*^9, 
   3.715555783525804*^9}, {3.715555817121044*^9, 3.715555841911236*^9}, {
   3.715556067669739*^9, 3.715556111337343*^9}, {3.715556509581563*^9, 
   3.715556519297716*^9}, 3.715556641489766*^9, {3.7155567334800377`*^9, 
   3.715556852929895*^9}, {3.715556886669449*^9, 3.715557028252529*^9}, {
   3.715557521519041*^9, 3.715557524548236*^9}, {3.715557757804319*^9, 
   3.715557763446659*^9}, {3.715557883389835*^9, 3.715557886320423*^9}, {
   3.715561087739847*^9, 3.7155610911391497`*^9}, {3.715566977633586*^9, 
   3.715566977931975*^9}, {3.7155670312412643`*^9, 3.715567054099*^9}, {
   3.715567107978794*^9, 3.715567150850398*^9}, {3.715567215462082*^9, 
   3.715567220216878*^9}, {3.715568030813163*^9, 3.715568055651904*^9}, {
   3.715568299746883*^9, 3.7155683019454517`*^9}, {3.715568636843951*^9, 
   3.715568640096509*^9}, {3.715568853811722*^9, 3.715568857007765*^9}, {
   3.715569116007135*^9, 3.715569120132471*^9}, {3.7155693175554533`*^9, 
   3.7155693246211233`*^9}, {3.715569646918714*^9, 3.71556966882731*^9}, {
   3.71556993405583*^9, 3.715569947975779*^9}, {3.715571958091552*^9, 
   3.7155719618255053`*^9}, {3.715572166211464*^9, 3.715572219563805*^9}, {
   3.715572381624477*^9, 3.715572384278387*^9}, {3.715572629487846*^9, 
   3.7155726331086493`*^9}, {3.715572974769212*^9, 3.715572978819759*^9}, {
   3.715573502067994*^9, 3.715573524697328*^9}, 3.715573562868143*^9, {
   3.7155736334265413`*^9, 3.715573637128271*^9}, {3.7155737209344482`*^9, 
   3.71557372410826*^9}, {3.715583020567827*^9, 3.715583023454122*^9}, {
   3.7155831969655523`*^9, 3.715583221582754*^9}, {3.715583919545116*^9, 
   3.715583936262298*^9}, {3.715663275958514*^9, 3.715663363881448*^9}, {
   3.7156634140386972`*^9, 3.715663432312261*^9}, {3.715663601985105*^9, 
   3.715663615775576*^9}, 3.715664035716845*^9, 3.715664185487091*^9, {
   3.715664629830697*^9, 3.715664635373158*^9}, {3.715664697875587*^9, 
   3.7156646979795227`*^9}, {3.7156647729625874`*^9, 3.715664776841151*^9}, {
   3.715667267521406*^9, 3.715667289822958*^9}, {3.7156675711136217`*^9, 
   3.71566758031851*^9}, {3.7156682545235367`*^9, 3.715668305436438*^9}, {
   3.715668363819756*^9, 3.715668376690024*^9}, 3.715824466329829*^9, {
   3.715824531968399*^9, 3.7158245589644957`*^9}, {3.715824641389061*^9, 
   3.715824680990985*^9}, {3.7158247318806143`*^9, 3.715824770548006*^9}, {
   3.71582485200342*^9, 3.7158248753329687`*^9}, {3.7158249481947327`*^9, 
   3.7158249545845623`*^9}, {3.715825052290537*^9, 3.715825055429637*^9}, {
   3.7158252849577*^9, 3.7158252850694313`*^9}, {3.715825488820025*^9, 
   3.71582553908994*^9}, {3.715826037825673*^9, 3.715826040679751*^9}, {
   3.715828145959448*^9, 3.7158281503029823`*^9}, {3.721012197860692*^9, 
   3.7210122196082487`*^9}, {3.721012334787047*^9, 3.721012349200521*^9}, {
   3.721012929106003*^9, 3.721012947350339*^9}, {3.721013000734489*^9, 
   3.721013018764546*^9}, {3.721013140407679*^9, 3.72101315803756*^9}, {
   3.721013365829303*^9, 3.72101337135611*^9}, {3.7210228520017767`*^9, 
   3.721022852431838*^9}, {3.721023281793976*^9, 3.721023282264381*^9}, {
   3.7222285802115602`*^9, 3.722228580350205*^9}, {3.738625573864479*^9, 
   3.7386255791467657`*^9}, {3.738625933945466*^9, 3.7386259731972523`*^9}, {
   3.738626028554759*^9, 3.73862621789951*^9}, {3.738626293634972*^9, 
   3.738626311747676*^9}, {3.7386263781994867`*^9, 3.738626382371421*^9}, {
   3.7386264365553007`*^9, 3.738626592486803*^9}, {3.738626649261796*^9, 
   3.738626798570313*^9}, {3.7386280373873053`*^9, 3.73862805742354*^9}, {
   3.738710002926478*^9, 3.738710029066862*^9}, {3.7387100849010477`*^9, 
   3.738710205956745*^9}, {3.73871072054906*^9, 3.738710740582128*^9}, {
   3.738710800603437*^9, 3.738710804720476*^9}, {3.7387108450762243`*^9, 
   3.7387108993238363`*^9}, 3.7387115254236603`*^9, {3.7387124084485683`*^9, 
   3.7387124085506907`*^9}, {3.74070396083578*^9, 3.74070397896036*^9}, {
   3.74070641534381*^9, 3.740706434988205*^9}, {3.742110295100013*^9, 
   3.7421102958463182`*^9}, {3.74211039232437*^9, 3.742110403571356*^9}, {
   3.7421104340276318`*^9, 3.742110445035355*^9}, {3.742110497007289*^9, 
   3.7421105353180847`*^9}, {3.7421105935068293`*^9, 3.742110622215053*^9}, {
   3.742110662052435*^9, 3.742110695606738*^9}, {3.742111936882732*^9, 
   3.742111938652997*^9}, {3.742112161837949*^9, 3.7421121621691236`*^9}, {
   3.742112229862471*^9, 3.742112259296385*^9}, {3.742112333553417*^9, 
   3.742112341013233*^9}, 3.742194934836945*^9, {3.74227245517845*^9, 
   3.742272469922003*^9}, {3.74227323425002*^9, 3.742273234320078*^9}, {
   3.7715461384029827`*^9, 3.771546158544175*^9}, {3.7715461932453814`*^9, 
   3.7715462022522097`*^9}, 3.771546234616699*^9, 3.771546277395185*^9, 
   3.771546313352919*^9, {3.771546407469046*^9, 3.771546409044898*^9}, {
   3.771546575935582*^9, 3.771546623497603*^9}, {3.771546732998044*^9, 
   3.771546747074795*^9}, {3.7715468919347267`*^9, 3.771546968863616*^9}, {
   3.7715470900325937`*^9, 3.7715470953571157`*^9}, {3.771549519106041*^9, 
   3.771549535210053*^9}, 3.771549579141548*^9, {3.771549705386619*^9, 
   3.771549714991355*^9}, {3.7715498504992313`*^9, 3.7715499440796337`*^9}, {
   3.771550175017785*^9, 3.771550258056491*^9}, {3.771550316582509*^9, 
   3.771550318389436*^9}, {3.771550356665448*^9, 3.771550408411762*^9}, {
   3.771550469340198*^9, 3.7715504953342943`*^9}, 3.771550657992529*^9, {
   3.771550848328397*^9, 3.771550857157196*^9}, {3.771550894126645*^9, 
   3.771550894242627*^9}, {3.7715509694961567`*^9, 3.77155098282866*^9}, {
   3.771551031319128*^9, 3.7715510324034033`*^9}, {3.771551889791954*^9, 
   3.771551904111792*^9}, {3.7730110864316263`*^9, 3.7730110969366217`*^9}, {
   3.773011207041523*^9, 3.773011317447945*^9}, {3.773011393513517*^9, 
   3.773011397670834*^9}, {3.7730321564026537`*^9, 3.7730322854076967`*^9}, {
   3.773032333523273*^9, 3.773032354274225*^9}, {3.7730324804358187`*^9, 
   3.773032492025669*^9}, {3.773032624306816*^9, 3.7730327815181713`*^9}, 
   3.7730329564765453`*^9, {3.77303303382553*^9, 3.773033206571432*^9}, {
   3.77303329171465*^9, 3.773033299713088*^9}, {3.773033336495734*^9, 
   3.773033385077568*^9}, {3.7730334210313177`*^9, 3.773033509837401*^9}, {
   3.773033726460668*^9, 3.7730338354694223`*^9}, {3.773033870648637*^9, 
   3.773033896385977*^9}, {3.773037461370748*^9, 3.77303748665222*^9}, {
   3.773037658250723*^9, 3.773037680341255*^9}, {3.77303771651476*^9, 
   3.773037884614464*^9}, {3.7730379166057243`*^9, 3.77303803380613*^9}, {
   3.773038276864955*^9, 3.773038277285882*^9}, {3.773039857437172*^9, 
   3.773039860249387*^9}, {3.773040250784793*^9, 3.77304041459589*^9}, {
   3.773040447658033*^9, 3.77304053080866*^9}, {3.77304056821699*^9, 
   3.773040631897664*^9}, {3.7730407293821983`*^9, 3.773040736518297*^9}, {
   3.773086808803184*^9, 3.77308682011635*^9}, {3.773114237226513*^9, 
   3.773114451112443*^9}, {3.77311471735625*^9, 3.7731147725176773`*^9}, {
   3.773114835753828*^9, 3.7731149726114063`*^9}, {3.7731151038151712`*^9, 
   3.773115109644916*^9}, {3.773118579324399*^9, 3.7731185842069187`*^9}, {
   3.775792261527781*^9, 3.7757922619978943`*^9}, {3.775792295419044*^9, 
   3.7757923126797323`*^9}, {3.775792521749763*^9, 3.775792588511032*^9}, {
   3.7757926875152617`*^9, 3.775792688191513*^9}, {3.775792753336152*^9, 
   3.77579282658855*^9}, {3.775792921454612*^9, 3.7757929291877403`*^9}, 
   3.775792997073175*^9, 3.7757930586266203`*^9, {3.775793107873659*^9, 
   3.7757931134926*^9}, 3.775793230390688*^9, {3.7757934121145277`*^9, 
   3.7757934363611603`*^9}, {3.775793483696372*^9, 3.7757934855126257`*^9}, 
   3.7757935282174664`*^9, {3.775884156614067*^9, 3.775884186977152*^9}, {
   3.775884221035289*^9, 3.77588424972226*^9}, {3.7758842819533157`*^9, 
   3.77588440968325*^9}, {3.7758844448917627`*^9, 3.775884487987311*^9}, {
   3.775884518250886*^9, 3.7758845190873337`*^9}, {3.775884563790029*^9, 
   3.775884577744516*^9}, {3.775884611210017*^9, 3.775884615820294*^9}, {
   3.775884850521481*^9, 3.775884854513843*^9}, {3.77588494544799*^9, 
   3.7758849643161917`*^9}, {3.775885066794438*^9, 3.775885104961974*^9}, {
   3.775885207186331*^9, 3.775885208857853*^9}, {3.775885331127701*^9, 
   3.77588536073794*^9}, {3.7759604103584948`*^9, 3.775960437826185*^9}, {
   3.776050679771391*^9, 3.77605070151122*^9}, {3.77605089136412*^9, 
   3.7760509408697567`*^9}, 3.776051064323505*^9, {3.7761208034626904`*^9, 
   3.776120812904924*^9}, {3.776129375613945*^9, 3.776129403563553*^9}, {
   3.77654257826845*^9, 3.776542620651349*^9}, 3.776542660999049*^9, {
   3.777866189950396*^9, 3.777866203765287*^9}, {3.777866241759121*^9, 
   3.777866255843267*^9}, {3.777866927426016*^9, 3.7778669948849773`*^9}, {
   3.777867069662991*^9, 3.777867090572133*^9}, {3.777867238407646*^9, 
   3.777867245741309*^9}, {3.777867281703923*^9, 3.777867397738422*^9}, {
   3.777867466269046*^9, 3.7778675289152117`*^9}, {3.7778675929910383`*^9, 
   3.7778676318384666`*^9}, {3.7778676631897573`*^9, 3.777867664996111*^9}, {
   3.777867742859836*^9, 3.777867753861002*^9}, {3.777867796313457*^9, 
   3.7778679727440243`*^9}, {3.777868011708623*^9, 3.777868024523026*^9}, {
   3.777868498891354*^9, 3.77786854396556*^9}, 3.777868707870282*^9, {
   3.77786876312149*^9, 3.7778687686976833`*^9}, {3.777869163813754*^9, 
   3.777869169903603*^9}, 3.777869341336142*^9, {3.77786937511954*^9, 
   3.777869390759791*^9}, {3.777875085429991*^9, 3.7778750877909317`*^9}, {
   3.7778751281320343`*^9, 3.777875129769226*^9}, {3.777875192336081*^9, 
   3.777875210773068*^9}, 3.7778752714355707`*^9, {3.777875456227579*^9, 
   3.777875456335327*^9}, {3.777875595683847*^9, 3.77787559577003*^9}, 
   3.777879665309235*^9, {3.777934947356806*^9, 3.777934947461276*^9}, {
   3.7779524849330273`*^9, 3.777952487181937*^9}, {3.777952569723338*^9, 
   3.777952597063107*^9}, 3.777961235343356*^9, 3.7779669164692383`*^9, {
   3.77801651951344*^9, 3.7780165247393923`*^9}, 3.778022471821343*^9, 
   3.778031349041174*^9, {3.778038015935131*^9, 3.778038074505041*^9}, {
   3.7780381402413263`*^9, 3.778038156324809*^9}, {3.778038200516223*^9, 
   3.778038214892398*^9}, {3.778038320125539*^9, 3.778038334089396*^9}, {
   3.778038412688527*^9, 3.778038530087446*^9}, {3.778038602588892*^9, 
   3.7780386029699297`*^9}, {3.778207260061844*^9, 3.778207262207142*^9}, {
   3.778207311437747*^9, 3.7782073181698112`*^9}, {3.778207368229116*^9, 
   3.77820739919993*^9}, 3.778207534541006*^9, {3.778207683098962*^9, 
   3.778207683745551*^9}, 3.7782077807413397`*^9, {3.778207817923884*^9, 
   3.778207840741441*^9}, {3.778207923493882*^9, 3.778208143636413*^9}, {
   3.778208207517769*^9, 3.778208214162985*^9}, {3.7782084227113333`*^9, 
   3.778208450598092*^9}, {3.7782085368742237`*^9, 3.778208689007769*^9}, {
   3.778208755028535*^9, 3.7782087888743267`*^9}, {3.778208852760873*^9, 
   3.7782090365809803`*^9}, {3.778209217813438*^9, 3.7782092689239187`*^9}, 
   3.7782093406199636`*^9, {3.7782094617093*^9, 3.778209526579748*^9}, 
   3.778209790318712*^9, {3.7782165884437313`*^9, 3.778216596528002*^9}, 
   3.778219105064733*^9, {3.7783000726725082`*^9, 3.7783000748272247`*^9}, {
   3.7783002209880867`*^9, 3.7783003040376*^9}, {3.778300661082693*^9, 
   3.7783007469602547`*^9}, {3.7783008195931807`*^9, 
   3.7783008258788033`*^9}, {3.778300892464241*^9, 3.778300903857972*^9}, 
   3.778300974302425*^9, {3.7783010147729273`*^9, 3.778301014864627*^9}, 
   3.778301113924378*^9, {3.778301529203361*^9, 3.77830156310843*^9}, 
   3.778301620042948*^9, 3.7783053606893177`*^9, {3.7783840436494303`*^9, 
   3.778384058725945*^9}, {3.778384112343298*^9, 3.778384113909574*^9}, {
   3.77847372690092*^9, 3.778473731335516*^9}, {3.778531913024205*^9, 
   3.7785319155148163`*^9}, 3.778550382790452*^9, {3.780709363341881*^9, 
   3.780709383991519*^9}, {3.7807094171166973`*^9, 3.7807094172324963`*^9}, {
   3.804976458675008*^9, 3.804976519692237*^9}, {3.804976763728889*^9, 
   3.804976767700845*^9}, {3.804976803907865*^9, 3.804976857248579*^9}, {
   3.804976908043935*^9, 3.8049769824183397`*^9}, {3.8049773787106524`*^9, 
   3.8049773841860933`*^9}, {3.8049870783446093`*^9, 3.804987080175417*^9}, {
   3.8049871425473623`*^9, 3.80498715267015*^9}, {3.805058020779303*^9, 
   3.805058051152691*^9}, {3.805060212027219*^9, 3.805060244253846*^9}},
 ExpressionUUID -> "ef30aa17-cd45-40f1-808a-20471b96ca85"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"main", " ", "part"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"yy", "=", "1"}], ",", 
      RowBox[{"yy", "\[LessEqual]", "nlr"}], ",", 
      RowBox[{"yy", "++"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", " ", "=", " ", "0"}], ";", 
       RowBox[{"g", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"ppcw", "=", 
        RowBox[{"{", "}"}]}], ";", 
       RowBox[{"ppccw", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", "imax"}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"t", "=", 
           RowBox[{"dt", "*", 
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}]}]}], ";", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<t = \>\"", ",", "t"}], "]"}], ";"}], "*)"}], 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"i", "\[Equal]", "1"}], ",", 
            RowBox[{
             RowBox[{"b", "=", 
              RowBox[{"Take", "[", 
               RowBox[{"a", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{
                  "ncell", "\[LeftDoubleBracket]", "1", 
                   "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], ";"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"b", "=", 
             RowBox[{"Take", "[", 
              RowBox[{"a", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"f", "+", "1"}], ",", 
                 RowBox[{"f", "+", 
                  RowBox[{
                  "ncell", "\[LeftDoubleBracket]", "i", 
                   "\[RightDoubleBracket]"}]}]}], "}"}]}], "]"}]}]}], "]"}], 
          ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"i", "\[Equal]", "1"}], ",", 
            RowBox[{
             RowBox[{"ipc", "=", 
              RowBox[{"Take", "[", 
               RowBox[{"ip", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{
                  "ncell", "\[LeftDoubleBracket]", "1", 
                   "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], ";"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ipc", "=", 
             RowBox[{"Take", "[", 
              RowBox[{"ip", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"f", "+", "1"}], ",", 
                 RowBox[{"f", "+", 
                  RowBox[{
                  "ncell", "\[LeftDoubleBracket]", "i", 
                   "\[RightDoubleBracket]"}]}]}], "}"}]}], "]"}]}]}], "]"}], 
          ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"nb", "=", 
           RowBox[{"Length", "[", "b", "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"vortcw", "=", 
           RowBox[{"N", "[", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"t", ",", "x", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ",", 
                RowBox[{"Lx", "-", 
                 RowBox[{"(", 
                  RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ")"}]}], ",", 
                "\[CapitalDelta]x"}], "}"}]}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"vortccw", "=", 
           RowBox[{"N", "[", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"t", ",", "x", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ",", 
                RowBox[{"Lx", "-", 
                 RowBox[{"(", 
                  RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ")"}]}], ",", 
                "\[CapitalDelta]x"}], "}"}]}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"grid", " ", "for", " ", "x"}], "-", 
            RowBox[{"y", " ", "plane"}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"gr", "=", 
           RowBox[{"N", "[", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ",", 
                RowBox[{"Lx", "-", 
                 RowBox[{"(", 
                  RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ")"}]}], ",", 
                "\[CapitalDelta]x"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"y", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                  "lr", "\[LeftDoubleBracket]", "yy", 
                   "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], "+", "\[Rho]", "+", 
                 "\[Delta]\[Rho]"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                  "lr", "\[LeftDoubleBracket]", "yy", 
                   "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}], "-", 
                 RowBox[{"(", 
                  RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ")"}]}], ",", 
                "\[CapitalDelta]y"}], "}"}]}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"ngrx", "=", 
           RowBox[{"Length", "[", "gr", "]"}]}], ";", 
          RowBox[{"ngry", "=", 
           RowBox[{"Length", "[", 
            RowBox[{
            "gr", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Z", " ", "projection"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"ss", "=", "1"}], ",", 
            RowBox[{"ss", "\[LessEqual]", "nslice"}], ",", 
            RowBox[{"ss", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"as", "=", 
              RowBox[{"inttophase", "[", 
               RowBox[{"b", ",", "ipc", ",", "i", ",", "nb", ",", 
                RowBox[{
                 RowBox[{
                 "slice", "\[LeftDoubleBracket]", "ss", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                 "\[RightDoubleBracket]"}], ",", 
                RowBox[{
                 RowBox[{
                 "slice", "\[LeftDoubleBracket]", "ss", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"projection", "[", 
              RowBox[{"gr", ",", "as", ",", "ngrx", ",", "ngry"}], "]"}], 
             ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"grid", " ", "for", " ", "x"}], "-", 
            RowBox[{"z", " ", "plane"}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"gr", "=", 
           RowBox[{"N", "[", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "z"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ",", 
                RowBox[{"Lx", "-", 
                 RowBox[{"(", 
                  RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ")"}]}], ",", 
                "\[CapitalDelta]x"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"z", ",", 
                RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ",", 
                RowBox[{"Lz", "-", 
                 RowBox[{"(", 
                  RowBox[{"\[Rho]", "+", "\[Delta]\[Rho]"}], ")"}]}], ",", 
                "\[CapitalDelta]z"}], "}"}]}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"ngrz", "=", 
           RowBox[{"Length", "[", 
            RowBox[{
            "gr", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Y", " ", "projection"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"ss", "=", "1"}], ",", 
            RowBox[{"ss", "\[LessEqual]", "nyslice"}], ",", 
            RowBox[{"ss", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"as", "=", 
              RowBox[{"phaseYplane", "[", 
               RowBox[{"b", ",", "ipc", ",", "i", ",", "nb", ",", 
                RowBox[{
                 RowBox[{
                 "yslice", "\[LeftDoubleBracket]", "ss", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                 "\[RightDoubleBracket]"}], ",", 
                RowBox[{
                 RowBox[{
                 "yslice", "\[LeftDoubleBracket]", "ss", 
                  "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"projection", "[", 
              RowBox[{"gr", ",", "as", ",", "ngrx", ",", "ngrz"}], "]"}], 
             ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"ppcw", ",", "vortcw"}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"ppccw", ",", "vortccw"}], "]"}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"f", "=", 
           RowBox[{"f", "+", 
            RowBox[{
            "ncell", "\[LeftDoubleBracket]", "i", 
             "\[RightDoubleBracket]"}]}]}], ";"}]}], "\[IndentingNewLine]", 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ppcw", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"ppcw", ",", "1"}], "]"}]}], ";", 
       RowBox[{"ppccw", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"ppccw", ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"plotfunc", "[", 
         RowBox[{"ppcw", ",", "imax"}], "]"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"plotfunc", "[", 
         RowBox[{"ppccw", ",", "imax"}], "]"}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.777952585075543*^9, 3.777952586945981*^9}, {
   3.778209012850075*^9, 3.778209024209416*^9}, 3.778209110640643*^9, {
   3.778209175423993*^9, 3.77820917752404*^9}, {3.778209249602976*^9, 
   3.77820925004952*^9}, {3.778209551623007*^9, 3.778209563095044*^9}, {
   3.778209596912991*^9, 3.778209628926425*^9}, {3.7782096937631702`*^9, 
   3.778209723907412*^9}, {3.778219020421681*^9, 3.778219043159814*^9}, {
   3.778300059346002*^9, 3.778300062437909*^9}, {3.778300427959622*^9, 
   3.77830060281205*^9}, {3.77830087246244*^9, 3.7783008758915033`*^9}, 
   3.778300913614091*^9, {3.77830095963667*^9, 3.778300989736466*^9}, {
   3.804976581626463*^9, 
   3.8049765820624323`*^9}},ExpressionUUID->"abccfaa2-8c3d-4146-a413-\
07b8087d0ad9"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Output", " ", "calculated", " ", "data"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pr", "=", 
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"np", "=", 
     RowBox[{"Length", "[", "ppcw", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fp", "=", 
     RowBox[{"OpenWrite", "[", 
      RowBox[{"\"\<t_x_vorticity_R_cw.dat\>\"", ",", 
       RowBox[{"PageWidth", "\[Rule]", "Infinity"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", "np"}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"WriteString", "[", 
        RowBox[{"fp", ",", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
            "ppcw", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
            "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
           "pr"}], "]"}], ",", "\"\<\\t\>\"", ",", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
            "ppcw", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
            "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
           "pr"}], "]"}], ",", "\"\<\\t\>\"", ",", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
            "ppcw", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
            "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], ",", 
           "pr"}], "]"}], ",", "\"\<\\n\>\""}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "fp", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"np", "=", 
     RowBox[{"Length", "[", "ppccw", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fp", "=", 
     RowBox[{"OpenWrite", "[", 
      RowBox[{"\"\<t_x_vorticity_R_ccw.dat\>\"", ",", 
       RowBox[{"PageWidth", "\[Rule]", "Infinity"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", "np"}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"WriteString", "[", 
        RowBox[{"fp", ",", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
            "ppccw", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
            "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
           "pr"}], "]"}], ",", "\"\<\\t\>\"", ",", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
            "ppccw", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
            "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
           "pr"}], "]"}], ",", "\"\<\\t\>\"", ",", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
            "ppccw", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
            "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], ",", 
           "pr"}], "]"}], ",", "\"\<\\n\>\""}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "fp", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7730147086109667`*^9, 3.773014713110589*^9}, {
  3.77303401034534*^9, 3.7730340620467052`*^9}, {3.777966835358502*^9, 
  3.777966867258156*^9}, {3.778382272914538*^9, 
  3.7783822781371117`*^9}},ExpressionUUID->"04cf83f1-4de5-479a-a0dc-\
da8bf0246845"]
},
EvaluationCompletionAction->"ShowTiming",
WindowSize->{884, 583},
WindowMargins->{{170, Automatic}, {Automatic, 59}},
Magnification:>1.5 Inherited,
FrontEndVersion->"10.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (2014\:5e7412\
\:67084\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 62067, 1282, 5719, "Input"],
Cell[62628, 1304, 12171, 278, 1469, "Input"],
Cell[74802, 1584, 3929, 99, 853, "Input"]
}
]
*)

