load Fig1-SourceData1
birdnames = {'wh08' 'wh09' 'rd49' 'bu86' 'gr57' 'gr58' 'gr54' 'rd82' 'gr58_example'};
nbirds = length(birdnames);

for i = 1:8 %nbirds
    
    figure('name',birdnames{i},'position',[100 100 500 320])
    subplot(1,2,1)
    
    lv_barplotwithdata(1,summary_baseline{i}.meanpost_y,0,1)
    lv_barplotwithdata(2,summary_baseline{i}.meanpost_g,2,1)
    
    allmean(1,i) = nanmean(summary_baseline{i}.meanpost_y);
    allmean(2,i) = nanmean(summary_baseline{i}.meanpost_g);
    allsem(1,i) = nanstd(summary_baseline{i}.meanpost_y)./sqrt(sum(~isnan(summary_baseline{i}.meanpost_y)));
    allsem(2,i) = nanstd(summary_baseline{i}.meanpost_g)./sqrt(sum(~isnan(summary_baseline{i}.meanpost_g)));
    alln(1,i) = sum(~isnan(summary_baseline{i}.meanpost_y));
    alln(2,i) = sum(~isnan(summary_baseline{i}.meanpost_g));
    
    set(gca,'xlim',[0 3],'ylim',[0 1],'xtick',[1 2],'xticklabel',{'Y' 'G'},'ytick',0:0.2:1)
    title('bl')
    
    if i == 6
        p = ranksum(summary_baseline{i}.meanpost_g,summary_baseline{i}.meanpost_y) %example bird test
    end
    
    subplot(1,2,2)
    
    lv_barplotwithdata(1,summary_post{i}.meanpost_y,1,1)
    lv_barplotwithdata(2,summary_post{i}.meanpost_g,3,1)
    
    allmean(3,i) = nanmean(summary_post{i}.meanpost_y);
    allmean(4,i) = nanmean(summary_post{i}.meanpost_g);
    allsem(3,i) = nanstd(summary_post{i}.meanpost_y)./sqrt(sum(~isnan(summary_post{i}.meanpost_y)));
    allsem(4,i) = nanstd(summary_post{i}.meanpost_g)./sqrt(sum(~isnan(summary_post{i}.meanpost_g)));
    alln(3,i) = sum(~isnan(summary_post{i}.meanpost_y));
    alln(4,i) = sum(~isnan(summary_post{i}.meanpost_g));
    
    set(gca,'xlim',[0 3],'ylim',[0 1],'xtick',[1 2],'xticklabel',{'Y' 'G'},'ytick',0:0.2:1)
    title('post')
    
    if i ==6
        p = ranksum(summary_post{i}.meanpost_g,summary_post{i}.meanpost_y) % example bird test
    end
    
end

allmean(:,6)
allsem(:,6)
alln(:,6)

%% Figure 1H

diffbl = allmean(2,:)-allmean(1,:);
diffpost = allmean(4,:)-allmean(3,:);
signrankpval = signrank(diffbl,diffpost)
meandiffbaseline = mean(diffbl)
meandiffpost = mean(diffpost)
semdiffbaseline = std(diffbl)./sqrt(8)
semdiffpost = std(diffpost)./sqrt(8)
figure('position',[100 100 220 320])
plot([diffbl;diffpost],'ko-','markersize',8,'linewidth',2)
set(gca,'xlim',[0.5,2.5],'xtick',1:2,'xticklabel',{'Baseline' 'Training'},'ytick',0:0.1:0.5)


%% Example bird baseline and single context training: gr58 20181113-20181120
load Fig1-SourceData2.mat

% note: syllables in song files have different label names than example
%spectrograms in paper, where syllables around the targeted branch point 
% are called abcd for easier reading
n_ab = cellfun(@(x) length(regexp(x,'nnab')),all_trans.syl_order);
n_ad = cellfun(@(x) length(regexp(x,'nnad')),all_trans.syl_order);
n_ax = n_ab+n_ad;

isnotsong = n_ax<1;
n_ax(isnotsong)=nan;

ng = all_trans.ng;
songday = all_trans.songday;

ng(isnotsong) = [];
songday(isnotsong) = [];
n_ab(isnotsong)=[];
n_ad(isnotsong)=[];
n_ax(isnotsong)=[];

switchix = find(diff(ng));

ctxt1 = 1:switchix(1);
ctxt2 = switchix(1)+1:switchix(2);


zhalfalpha = 1.96; %95conf zhalfalpha = 2.576 %99%

% train 1
train1_n_ab = grpstats(n_ab(ctxt1),songday(ctxt1),'sum');
train1_n_ad = grpstats(n_ad(ctxt1),songday(ctxt1),'sum');
train1_n_ax = grpstats(n_ax(ctxt1),songday(ctxt1),'sum');

figure('position',[100 100 800 300])
subplot(1,3,2)
hold on
phat = train1_n_ab./train1_n_ax;
ci1 = phat - zhalfalpha.*sqrt(phat.*(1-phat)./train1_n_ax);
ci2 = phat + zhalfalpha.*sqrt(phat.*(1-phat)./train1_n_ax);
shadeplot_abs(1:4,phat',ci1,ci2,4,'x',1)


phat = train1_n_ad./train1_n_ax;
ci1 = phat - zhalfalpha.*sqrt(phat.*(1-phat)./train1_n_ax);
ci2 = phat + zhalfalpha.*sqrt(phat.*(1-phat)./train1_n_ax);
shadeplot_abs(1:4,phat',ci1,ci2,1,'x',1)


% train 2
train2_n_ab = grpstats(n_ab(ctxt2),songday(ctxt2),'sum');
train2_n_ad = grpstats(n_ad(ctxt2),songday(ctxt2),'sum');
train2_n_ax = grpstats(n_ax(ctxt2),songday(ctxt2),'sum');
set(gca,'xlim',[0.5 4.5],'ylim',[0 1])
subplot(1,3,3)
hold on
phat = train2_n_ab./train2_n_ax;
ci1 = phat - zhalfalpha.*sqrt(phat.*(1-phat)./train2_n_ax);
ci2 = phat + zhalfalpha.*sqrt(phat.*(1-phat)./train2_n_ax);
shadeplot_abs(1:4,phat',ci1,ci2,4,'x',1)


phat = train2_n_ad./train2_n_ax;
ci1 = phat - zhalfalpha.*sqrt(phat.*(1-phat)./train2_n_ax);
ci2 = phat + zhalfalpha.*sqrt(phat.*(1-phat)./train2_n_ax);
shadeplot_abs(1:4,phat',ci1,ci2,1,'x',1)
set(gca,'xlim',[0.5 4.5],'ylim',[0 1])


%% baseline

load Fig1-SourceData3.mat

n_ab = cellfun(@(x) length(regexp(x,'nnab')),all_trans.syl_order);
n_ad = cellfun(@(x) length(regexp(x,'nnad')),all_trans.syl_order);
n_ax = n_ab+n_ad;
isnotsong = n_ax<1;
n_ax(isnotsong)=nan;


ng = all_trans.ng;
songday = all_trans.songday;

ng(isnotsong) = [];
songday(isnotsong) = [];
n_ab(isnotsong)=[];
n_ad(isnotsong)=[];
n_ax(isnotsong)=[];




bl_n_ab = grpstats(n_ab,songday,'sum');
bl_n_ad = grpstats(n_ad,songday,'sum');
bl_n_ax = grpstats(n_ax,songday,'sum');

subplot(1,3,1)
hold on
phat = bl_n_ab./bl_n_ax;
ci1 = phat - zhalfalpha.*sqrt(phat.*(1-phat)./bl_n_ax);
ci2 = phat + zhalfalpha.*sqrt(phat.*(1-phat)./bl_n_ax);
shadeplot_abs(1:length(phat),phat',ci1,ci2,4,'x',1)
temp2bl = phat(end);
temp2ci1 = ci1(end);
temp2ci2 = ci2(end);

phat = bl_n_ad./bl_n_ax;
ci1 = phat - zhalfalpha.*sqrt(phat.*(1-phat)./bl_n_ax);
ci2 = phat + zhalfalpha.*sqrt(phat.*(1-phat)./bl_n_ax);
shadeplot_abs(1:length(phat),phat',ci1,ci2,1,'x',1)


set(gca,'xlim',[0.5 5.5],'ylim',[0 1])


grpstats(n_ad,songday,'sum')
grpstats(n_ab,songday,'sum')
grpstats(n_ax,songday,'sum')


