plotsigns = {'o' 'x' '*' '+' '>' '<' 'h' 'd'};
birdnames = {'wh08' 'wh09' 'rd49' 'bu86' 'gr57' 'gr58' 'gr54' 'rd82'};
nbirds = length(birdnames);
load Fig2-SourceData1.mat %formerly switches_summary.mat
%% Fig 2 C,D

%plot absolute switch for first song WN
figure('position',[100 100 800 320])
axx(1) = subplot(1,3,1);
hold on
for i = 1:nbirds
plot(1:2,alln1_prepost_3to1(i,:),plotsigns{i},'linestyle','-','linewidth',2,'markersize',10)
end
% title([' green to orange WN'])
set(gca,'xtick',1:2,'xticklabel',{'g ' 'y '},'xlim',[0 3])
axx(2) = subplot(1,3,2);
hold on
for i = 1:nbirds
plot(1:2,alln1_prepost_1to3(i,:),plotsigns{i},'linestyle','-','linewidth',2,'markersize',10)
end
% title([' orange to green WN'])
set(gca,'xtick',1:2,'xticklabel',{'y ' 'g '},'xlim',[0 3])
legend(birdnames,'location','northeast')
set(gcf,'paperpositionmode','auto')

signrankp_n1_3to1 = signrank(alln1_prepost_3to1(:,1),alln1_prepost_3to1(:,2))
signrankp_n1_1to3 = signrank(alln1_prepost_1to3(:,1),alln1_prepost_1to3(:,2))

set(gca,'xtick',1:2,'xticklabel',{'y ' 'g '},'xlim',[0 3])
legend(birdnames,'location','northeast')
linkaxes(axx)
set(gcf,'paperpositionmode','auto')
set(axx(1),'ylim',[0.1 1],'ytick',0.2:0.2:1)
set(axx(2),'ytick',0.2:0.2:1)


%% Fig 2 E,F

%quantify first jump n5
figure('position',[100 100 500 320])
ax(1) = subplot(1,2,1);
lv_barplotfillwithdata(0.5,alln5_wntown(:,1),3,1)
ax(2) = subplot(1,2,2);
lv_barplotfillwithdata(0.5,alln5_wntown(:,2),1,1)
linkaxes(ax)
set(ax(1),'ylim',[-.85 .85],'xlim',[0.35 0.65],'xtick',0.5)
set(ax(2),'xtick',0.5)
set(gcf,'paperpositionmode','auto')


%% Fig 3 E,F

%plot absolute switch for first song - probes
figure('position',[100 100 800 320])
axx(1) = subplot(1,3,1);
hold on
for i = 1:nbirds
plot(1:2,alln1_prepost_2to0(i,:),plotsigns{i},'linestyle','-','linewidth',2,'markersize',10)
end
% title([' green to orange probe'])
set(gca,'xtick',1:2,'xticklabel',{'g ' 'y '},'xlim',[0 3])
axx(2) = subplot(1,3,2);
hold on
for i = 1:nbirds
plot(1:2,alln1_prepost_0to2(i,:),plotsigns{i},'linestyle','-','linewidth',2,'markersize',10)
end
% title([' orange to green probe'])
set(gca,'xtick',1:2,'xticklabel',{'y ' 'g '},'xlim',[0 3])
legend(birdnames,'location','northeast')
linkaxes(axx)
set(gcf,'paperpositionmode','auto')
set(axx(1),'ylim',[0.1 1],'ytick',0.2:0.2:1)
set(axx(2),'ytick',0.2:0.2:1)

%% Fig 3 G,H

%quantify first jump n5
figure('position',[100 100 500 320])
ax(1) = subplot(1,2,1);
lv_barplotfillwithdata(0.5,alln5_probeprobe(:,1),2,1)
ax(2) = subplot(1,2,2);
lv_barplotfillwithdata(0.5,alln5_probeprobe(:,2),0,1)
linkaxes(ax)
set(ax(1),'ylim',[-.85 .85],'xlim',[0.35 0.65],'xtick',0.5)
set(ax(2),'xtick',0.5)
set(gcf,'paperpositionmode','auto')


