plotsigns = {'o' '<'  '>'  'd'  '*'};
birdnames = {'wh08' 'gr58'  'gr57'  'rd82' 'rd49'};
mlcm = [0    0.4470    0.7410; 0.8500    0.3250    0.0980; 0.9290    0.6940    0.1250;    0.4940    0.1840    0.5560; 0.4660    0.6740    0.1880; 0.3010    0.7450    0.9330; 0.6350    0.0780    0.1840]; %matlab color matrix, to match colors of same birds in other plots with matlab default colors
nbirds = length(birdnames);
load Fig2-SourceData2.mat %formerly acquisition_summary


for i = 1:nbirds
    
    dat = birds{i}.acqui_fit.interc2;
    xnonan = [find(~isnan(dat))]';
    nonan = [dat(~isnan(dat))]';
    ff = fit(xnonan,nonan,'poly1');
    t1_slopeofinterc2(i) = ff.p1;
    
    
    dat = birds{i}.acqui_fit.slope2;
    xnonan = [find(~isnan(dat))]';
    nonan = [dat(~isnan(dat))]';
    ff = fit(xnonan,nonan,'poly1');
    t1_slopeofslopes2(i) = ff.p1;
  
    
end


%% Figure 2L
figure
hold on
for i = 1:5
    plot(1,t1_slopeofslopes2(i),plotsigns{i},'markersize',10,'linewidth',2,'color',mlcm(i,:))
    %     plot(2,t2_slopeofslopes2(i),plotsigns{i},'markersize',10,'linewidth',2,'color',mlcm(i,:))
    plot(3,t1_slopeofinterc2(i),plotsigns{i},'markersize',10,'linewidth',2,'color',mlcm(i,:))
    %     plot(4,t2_slopeofinterc2(i),plotsigns{i},'markersize',10,'linewidth',2,'color',mlcm(i,:))
    
end
bar(1,nanmean(t1_slopeofslopes2),'linewidth',2,'facecolor','none','edgecolor','k')
% bar(2,nanmean(t2_slopeofslopes2),'linewidth',2,'facecolor','none','edgecolor','k')
bar(3,nanmean(t1_slopeofinterc2),'linewidth',2,'facecolor','none','edgecolor','k')
% bar(4,nanmean(t2_slopeofinterc2),'linewidth',2,'facecolor','none','edgecolor','k')