load Fig4-SourceData1.mat
tt=birdtab;
%%
figure('position',[100 100 200 200],'paperpositionmode','auto')
plot(tt.age,tt.effectsize,'ko','markersize',10,'linewidth',2) 
[a,p]=corr(tt.age,tt.effectsize)
xlabel('age')
ylabel('context difference')
hold on
xl = get(gca,'xlim');
text(xl(2) - 0.1*(xl(2)-xl(1)),0.45,num2str(a),'color','r')
box off
set(gca,'fontname','arial','fontsize',8)






figure('position',[100 100 200 200],'paperpositionmode','auto')
plot(tt.effectsize*100,tt.proprelevant,'ko','markersize',10,'linewidth',2) %16
xlabel('context difference')
ylabel('proportion at relevant branch point')
box off
set(gca,'fontname','arial','fontsize',8)




figure('position',[100 100 200 200],'paperpositionmode','auto')
plot(tt.transent,tt.effectsize,'ko','markersize',10,'linewidth',2) %10
[a,p]=corr(tt.transent,tt.effectsize)
xlabel('transition entropy of song')
ylabel('context difference')
hold on
xl = get(gca,'xlim');
text(xl(2) - 0.1*(xl(2)-xl(1)),0.45,num2str(a),'color','r')
box off
set(gca,'fontname','arial','fontsize',8)





meanterelevant = cellfun(@(x) mean(x),tt.terelevantbp);
meandist = cellfun(@(x) mean(x),tt.distrelevantbp);


figure('position',[100 100 200 200],'paperpositionmode','auto')
plot(meanterelevant,tt.effectsize,'ko','markersize',10,'linewidth',2) 
[a,p]=corr(meanterelevant,tt.effectsize)
xlabel('transition entropy at BPs')
ylabel('context difference')
hold on
xl = get(gca,'xlim');
text(xl(2) - 0.1*(xl(2)-xl(1)),0.45,num2str(a),'color','r')
box off
set(gca,'fontname','arial','fontsize',8)

figure('position',[100 100 200 200],'paperpositionmode','auto')
plot(meandist,tt.effectsize,'ko','markersize',10,'linewidth',2) 
[a,p]=corr(meandist,tt.effectsize)
xlabel('target distance from BPs')
ylabel('context difference')
hold on
xl = get(gca,'xlim');
text(xl(2) - 0.1*(xl(2)-xl(1)),0.45,num2str(a),'color','r')
box off
set(gca,'fontname','arial','fontsize',8)


