plotsigns = {'o' 'x' '+' };
birdnames = {'wh08' 'wh09' 'bu86' };
nbirds = length(birdnames);
load Fig5-SourceData1.mat %formerly neutralcontext_summary.mat
%% Fig 5 B,C


%plot absolute switch for neutral to probes n1
figure('position',[100 100 800 320])
axx(1) = subplot(1,3,1);
hold on
for i = 1:nbirds
plot(1:2,alln1_prepost_4to0(i,:),plotsigns{i},'linestyle','-','linewidth',2,'markersize',10)
end
% title(['white to y probe'])
set(gca,'xtick',1:2,'xticklabel',{'n ' 'y '},'xlim',[0 3])
axx(2) = subplot(1,3,2);
hold on
for i = 1:nbirds
plot(1:2,alln1_prepost_4to2(i,:),plotsigns{i},'linestyle','-','linewidth',2,'markersize',10)
end
% title(['white to green probe'])
set(gca,'xtick',1:2,'xticklabel',{'n ' 'g '},'xlim',[0 3])
legend(birdnames,'location','northeast')
set(gcf,'paperpositionmode','auto')

linkaxes(axx)
set(gcf,'paperpositionmode','auto')
set(axx(1),'ylim',[0.25 0.75],'ytick',0.2:0.1:1)
set(axx(2),'ytick',0.2:0.1:1)

%% Fig 4D

figure('position',[100 100 400 320])
hold on
lv_barplotfillwithdata(0.2,alln5_4toall(:,1),0,1)
set(gca,'xlim',[0 1],'xtick',0.2:0.2:0.8)

lv_barplotfillwithdata(0.4,alln5_4toall(:,2),1,1)
set(gca,'xlim',[0 1],'xtick',0.2:0.2:0.8)

lv_barplotfillwithdata(0.6,alln5_4toall(:,3),2,1)
set(gca,'xlim',[0 1],'xtick',0.2:0.2:0.8)

lv_barplotfillwithdata(0.8,alln5_4toall(:,4),3,1)
set(gca,'xlim',[0 1],'xtick',0.2:0.2:0.8,'xticklabel',{'Y probe' 'Y WN' 'G probe' 'G WN'})

set(gca,'ylim',[-.3 .3])
set(gcf,'paperpositionmode','auto')
