function k_prior_sample_test;
% Usage: k_prior_sample_test;
% Tests sampling from the prior distribution on k.

% Change Log:
%
%     1.2          10:oct:19    jc2062   As first received from jc2062.
%     1.14         14:oct:19    rfs34    Now uses setpriorcoords.m .

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.k_prior_sample_test.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

% Tests sampling from k_prior. 

Nsamples = 1e4;

priorcoords = setpriorcoords;
[a_J, a_p, b_p, a_m, b_m, m_r, b_r, a_k, b_k, c_k, l_k] = priorcoords{:};
r_r = 1 / b_r;
   
xx = -5:0.1:5;
a = a_k;
b = b_k;
c = c_k;
l = l_k;

ll = zeros([1, Nsamples]);
for i = 1 : Nsamples,
    ll(i) = k_prior_sample(1, a, b, c, l, 10);
    fprintf('\r...done %d...      ', i);
end
fprintf('\rFinished.             \n');

densityvhist(xx, exp(log_k_density(xx, a, b, c, l, 0)), ll);
xlabel('k');
ylabel('P(k) scaled or histogram');
title('Comparison of prior density and histogram for k parameter');


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
