function y = m_sample(J, r, k, x, m_a, m_b)
% Usage: y = m_sample(J, r, k, x, m_a, m_b)
% This function resamples m from the posterior, given the other parameters,
%  of which m_a and m_b are the parameters of the prior
%  (for the form of which see log_m_density.m).
% Note that only x that are not Inf are considered.
% Method is by ARS (see ars.m).

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.5          11:oct:19    rfs34    Dimension made explicit in last sum, and an
%                                        action point added.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.m_sample.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

    % Conjugate prior for m of the form detailed in log_m_density.m
    
    M = size(x,1);
    y1 = x.^repmat(k,M,1);
    
    N = sum(x ~= Inf, 1);
    
    z1 = log(y1);
    z1(x == Inf) = 0;
    X1 = sum(z1, 1);
    
    z2 = repmat(r.^k, M, 1).*y1;
    z2(x == Inf) = 0;
    X2 = sum(z2, 1);
    
    z3 = repmat(log(r).*k, M, 1);
    z3(x == Inf) = 0;
    X3 = sum(z3, 1);
    
    
    b = m_b + N;
    a = m_a + m_b - X1 + X2 - X3 -b;
    y = zeros(1,J);
    
    for i = 1:J
       if isinf(a(i)), % Then the distribution is a all at infinity.
           y(i) = 1e100;
        else
           % Construct suitable input parameters for ars.
           points = [b(i)/(5*a(i)),b(i)/(2*a(i)), b(i)/a(i)];
           logf = @(x) log_m_density(x, a(i), b(i));
           gradlogf = @(x) log_m_derivative(x,a(i),b(i));
           y(i) = ars(logf, gradlogf, points, 0, Inf);
        end
    end
end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
