function y = piecewise_exponential_density(xx, points, vals, grads, bounds);
% Usage: y = piecewise_exponential_density(xx, points, vals, grads, bounds);
% Returns the unnormalised density of the piecewise exponential distribution
%  at the points xx, where:
%   bounds gives the changeover points from each piece to the next;
%   points is a list of x values one in each piece;
%   vals are the unnormalised log-densities at points;
%   grads are the gradients of log-densities at points.

% Change Log:
%
%     1.1          14:oct:19    rfs34    First version.
%     1.12         14:oct:19    rfs34    Version number harmonisation.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.piecewise_exponential_density.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

Npieces = length(bounds) - 1;

vals = vals - max(vals);

for npiece = 1 : Npieces,
   inpiece = (bounds(npiece) <= xx) & (xx <= bounds(npiece + 1));
   y(inpiece) = exp(vals(npiece) + grads(npiece) * (xx(inpiece) - points(npiece)));
end

return;


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



