function y = r_sample(J, m, r, k, x, r_m, r_r)
% Usage: y = r_sample(J, m, r, k, x, r_m, r_r)
% Resamples r, the (list of) scale parameter(s), from the 
%  posterior given the other parameters.
% The factor due to the prior is Gamma in r, while that due to
%  the likelihood is Gamma in r^k. 
% Therefore we propose from the Gamma in r^k, which is 
%  likely to be tight, and calculate the Hastings ratio
%  which then arises only from the prior.

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.15         14:oct:19    rfs34    Two dimension mismatch bugs fixed.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.r_sample.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls


M = size(x,1);
N = sum(x ~= Inf, 1);

z = x;
x = x .^ k(ones(M, 1), :);

a = m .* N;
b = m(ones(M, 1), :) .* x;
b(x == Inf) = 0;
b = sum(b, 1);

y = zeros(1,J);

for i = 1:J

   if a(i) == 0,
      y(i) = gamrnd(r_m, 1 / r_r);
   else % i.e. if there is some data on the subject

      s = gamrnd(a(i), 1/b(i));
      s = s.^(1./k(i));
      u = rand;
      
      br = 0;
      for j = 1:10
          if u < gampdf(s, r_m + 1, 1/r_r)/gampdf(r(i), r_m + 1, 1/r_r)
              br = 1;
              break
          end
          s = gamrnd(a(i), 1/b(i));
          s = s.^(1./k(i));
          u = rand;
      end
      if br == 0
          y(i) = r(i);
      else
          y(i) = s;
      end

   end % if a(i) == 0 or not
end % for i = 1 : J

end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
