function y = truncated_gamma(m,r,a,pos)
% Usage: y = truncated_gamma(m,r,a,pos)
% Takes a sample from the Gamma distribution with
%  parameters m and r, either restricted to the range
%  [a, Inf) (if pos is 1), or to the range
%  (-Inf, a) (if pos is 0).

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.5          11:oct:19    rfs34    Removed one of the ponts passed to ars 
%                                        as unsuitable, and added action points.
%     1.21         16:oct:19    rfs34    Starting to deal with potential to get stuck.
%     1.22         16:oct:19    rfs34    Fixed potential to get stuck.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.truncated_gamma.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

if pos == 1
    if m >= 1
        logf = @(x) log_r_prior(x, m, r);
        gradlogf = @(x) -r + ((m-1)./x);
        if gradlogf(a) > 0
            points = [0.5*(a + ((m-1)/r)), ((m-1)/r)+1];
        else
            points = [a+1];
        end
        y = ars(logf, gradlogf, points, a, Inf);
    else % i.e. if m < 1
       % Different method needed because then the distribution is not log-concave.
       accprobgamma = gammainc(a .* r, m, 'upper');
       accprobpoly = exp((log(a) + log(r)) .* (1 - m) + log(accprobgamma) + gammaln(m) + r .* a);
       accprob = max(accprobgamma, 10 * accprobpoly); % Estimating Gamma takes 10 times longer.
       if accprob < 0.01 && accprobgamma > 0,
          warning(sprintf('Low weighted acceptance probability of %g in truncated_gamma.m', accprob));
       end
       if accprobgamma <= 10 * accprobpoly,
          % Then rejecting based on a Gamma proposal will take
          %  a long time.

          % Therefore sample from an exponential of scale r starting at a, 
          %  then reject according to y^(m-1) / a^(m-1).
          y = - log(rand) / r + a;
          u = rand;
          while u > (y / a) .^ (m - 1);
             y = - log(rand) / r + a;
             u = rand;
          end
       else
          % Rejection based on a Gamma proposal.
          y = gamrnd(m,1/r);
          while y < a
              y = gamrnd(m, 1/r);
          end
       end          
    end
end
if pos == 0
    if m > 1
        logf = @(x) log_r_prior(x,m,r);
        gradlogf = @(x) -r + ((m-1)./x);
        if gamcdf(a,m,1/r) == 1
            y = gamrnd(m,1/r);
        elseif gradlogf(a) < 0
            points = [(0.5*(m-1))/r,0.5*(a + ((m-1)/r))];
            % RFS: I omitted((m-1)/r)+1 as it might (very probably) be bigger than a.
            
            y = ars(logf, gradlogf, points, 0, a);
        else
            points = [0.5*a];
            y = ars(logf, gradlogf, points, 0, a);
        end
    else
       accprobgamma = gammainc(a .* r, m);
       accprobpoly = (1 - exp(- a .* r)) ./ (r .* a);
       accprob = max(accprobgamma, 10 * accprobpoly);
       if accprob < 0.01 && accprobgamma >= 0,
          warning(sprintf('Low weighted acceptance probability of %g in truncated_gamma.m', accprob));
       end
       if accprobgamma > 10 * accprobpoly,
          y = gamrnd(m,1/r);
          while y > a
             y = gamrnd(m, 1/r);
          end
       else
          u = rand;
          y = a .* u .^ (1 ./ m);
          u = rand;
          while u > exp(- r .* y),
             u = rand;
             y = a .* u .^ (1 ./ m);
             u = rand;
          end
       end
    end
end

return;

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
