function J_prior_test(a_J);
% Usage: J_prior_test(a_J);
% Visualises and compares the exponential prior on J, the number of
%  modes of death. 
% The actually prevalent value of a_J is set in setpriorcoords.m .
% Note that the distribution assumed here is not what you 
%  might expect, namely it is 
%  P(J) = a_J * (1 - a_J) ^ J.

% Change Log:
%
%     1.2          10:oct:19    jc2062   As first received from jc2062.
%     1.3          11:oct:19    rfs34    Made into a function with a_J a parameter.
%     1.7          12:oct:19    rfs34    Comparison plot added.
%     1.12         14:oct:19    rfs34    Axis labels and titles added.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.J_prior_test.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

% Checking histograms for different choices of the prior on J.

xx = [1 : 10];
yy = a_J * (1 - a_J) .^ (xx - 1);

ll = zeros([1 1000]);
for i = 1:1000
    ll(i) = geornd(a_J)+1;
end

densityvhist(xx, yy, ll, xx);
xlabel('J');
ylabel('scaled P(J) or bin count');
title('Comparison of prior samples and probability for J (number of modes)');

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



