function y = J_sample(J, p, m, r, k, x, adherences, deaths, priorcoords)
% Usage: y = J_sample(J, p, m, r, k, x, adherences, deaths, priorcoords)
% This function resamples J, the number of modes of death.
% It proceeds by considering incrementing or decrementing the
%  number of modes to which currently nothing is adherent,
%  using the proposal probabilities which then make the 
%  whole thing keep detailed balance IF it is preceded and 
%  followed palindromically by randomly reordering the empty modes
%  and resampling one of them (which we don't actually bother to do,
%  since detailed balance of the marginal in J is kept anyhow,
%  and effectively reordering the modes and resampling them
%  is informally effected by the other procedures in place).
% Note that y is a cell array containing all the updated parameters
%  (as the length of several of them may have changed).

% Change Log:
%
%     1.1          28:sep:19    jc2062   As received from JC2062.
%     1.2          10:oct:19    jc2062   As first received from jc2062.
%     1.3          11:oct:19    rfs34    Fixed misuse of a_J instead of 1-a_J
%                                        and insufficient probability of
%                                        reducing J.
%     1.15         14:oct:19    rfs34    Replaced prod by all for logicals.
%     1.20         16:oct:19    rfs34    Changed convention on cheat or not in 
%                                        generate_params_and_data.m .
%     1.43         23:oct:19    rfs34    Comments only changed.
%     1.47         09:nov:19    rfs34    Fixed bug whereby it was possible to end up with J=0.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.J_sample.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

N = size(x,1);

a_J = priorcoords{1};

% RFS: 1-a_J needed here because of unusual parameterisation of geornd.
u = general_discrete([1, 1 - a_J]);

% RFS: The following could be speeded up by instead writing:
% used = hist(adherences, [-1 : J]) > 0;
% used = used(3 : end);

adherence_grid = zeros(N, J);
for i = 1:N
    if adherences(i) > 0
        adherence_grid(i, adherences(i)) = 1;
    end
end
used = sum(adherence_grid, 1);

% RFS: The changes below ensure that if we consider removing a mode, 
%      then we always remove an empty mode (if there is one).
%      The way it was before, if there was one empty mode and J=5, 
%      we only had a 1/5 chance of reducing, with no such restriction
%      on increasing. Discuss - I could be wrong on this !!

indempty = find(used == 0);
Jempty = length(indempty);

if u == 1
    if Jempty > 0 && J > 1,
        remove = indempty(randi([1, Jempty]));
        if used(remove) == 0
            J = J - 1;
            p(remove) = [];
            k(remove) = [];
            m(remove) = [];
            r(remove) = [];
            x(:,remove) = [];
            adherences(adherences > remove) = adherences(adherences > remove) - 1;
            
        end
    end
end

if u == 2
    newdata = generate_params_and_data(N, priorcoords, 0, {0, 1}, {2}, {2}, {2}, {2}, 0);
    newx = newdata{end-1};
    keep = all(newx >= deaths);
    if keep == 1
        J = J + 1;
        x = horzcat(x,newx);
        p = horzcat(p,newdata{2});
        m = horzcat(m,newdata{3}(:,keep));
        r = horzcat(r,newdata{4}(:,keep));
        k = horzcat(k,newdata{5}(:,keep));
    end

end
y = {J, p, m, r, k, x, adherences};
end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



