function y = adherence_sample(J, p, m, r, k, x, deaths, adherences)
% Usage: y = adherence_sample(J, p, m, r, k, x, deaths, adherences)
% This function resamples the adherences, which say which
%  mode of death is responsible for each observed death.
% Since the observed death times are known, this necessarily 
%  involves also changing the x values.
% In this particular implementation, all the x values are discarded
%  to start with, and the adherences are resampled in the marginal
%  having integrated x out. The x values are then sampled from
%  scratch in the conditional given the adherences.

% Change Log:
%
%     1.1          28:sep:19    jc2062   As received from JC2062.
%     1.2          10:oct:19    jc2062   As first received from jc2062.
%     1.23         17:oct:19    rfs34    Two bugs fixed as annotated.
%     1.36         21:oct:19    rfs34    Now fixed the stupid mistake I made 
%                                        when doing the previous fix.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.adherence_sample.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

    M = size(x);
    M = M(1);
    ndeaths = deaths;
    ndeaths(deaths == Inf) = 0;
    weights = zeros([M J]);
    for j = 1:J
        if k(j) < 0
            % RFS: Note that the form below both incorporates the required factor of
            %      abs(k) * x ^ (k - 1) that arises when transforming the density,
            %      but also avoids numerical underflow by summing
            %      a non-negative and a positive quantity in the denominator.
            weights(:,j) = (p(j) .* abs(k(j)) .* ndeaths .^ (k(j) - 1) ...
                            .* gampdf(ndeaths.^k(j), m(j), 1/(m(j)*(r(j)^k(j))))) ...
                           ./ ((1 - p(j)) + p(j) .* gamcdf(ndeaths.^k(j), m(j), 1/(m(j)*(r(j)^k(j)))));
        else
            weights(:,j) = (p(j) .* abs(k(j)) .* ndeaths .^ (k(j) - 1) ...
                            .* gampdf(ndeaths.^k(j), m(j), 1/(m(j)*(r(j)^k(j))))) ...
                           ./ ((1 - p(j)) + p(j) .* gamcdf(ndeaths.^k(j), m(j), 1/(m(j)*(r(j)^k(j))), 'upper'));
        end
    end
    nadherences = zeros(M,1);
    for npatient = 1:M
        if adherences(npatient) ~= 0
            nadherences(npatient) = general_discrete(weights(npatient,:));
        end
    end
    nadherences(deaths == Inf) = -1;
    x = x_sample(J, p, m, r, k, x, deaths, nadherences);
    y = {x, nadherences};
end


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



