function densityvhist(xx, yy, xsamples, forcebins);
% Usage: densityvhist(xx, yy, xsamples, forcebins);
% Given a constant multiple of a probability density function 
% represented by yy on a uniformly spaced 1-d grid xx, 
%  and some xsamples, 
%  restricts the xsamples to those in the range of xx,
%  then plots curve multiplied by the appropriate
%  value to match the histogram of xsamples.
% If forcebins is passed, it is taken to be the row vector
%  of bin centres; otherwise these are constructed automatically.

% Change Log:
%
%     1.1          12:oct:19    rfs34    First version.
%     1.7          12:oct:19    rfs34    Version number harmonisation; 
%                                        added forcebins option.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.densityvhist.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

if nargin < 4,
   forcebins = [];
end

xl = xx(1);
xr = xx(end);
xsamples = xsamples(xsamples >= xl & xsamples <= xr);

Nsamples = length(xsamples);

if isempty(forcebins),
   Nbins = max(10, ceil(sqrt(Nsamples)));
   bins = xx(1) + (0.5 + [0 : (Nbins - 1)]) * (xr - xl) / Nbins;
else
   bins = forcebins;
   Nbins = length(bins);
end

deltax = xx(2) - xx(1);
binwidth = bins(2) - bins(1);

normfactor = 1 / (sum(yy) * deltax);
multiplier = normfactor * binwidth * Nsamples;

clf;
hold on;
hist(xsamples, bins);
plot(xx, yy * multiplier, 'g');
hold off;

return;


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



