function y = generate_params_and_data(N, priorcoords, lost_rate, j_sam, p_sam, m_sam, r_sam, k_sam, ...
                                      shortcut, adh_sam, x_sam, deaths, censored);
% Usage: y = generate_params_and_data(N, priorcoords, lost_rate, j_sam, p_sam, m_sam, r_sam, k_sam, ...
%                                     shortcut, adh_sam, x_sam, deaths, censored);
% The v_sam variables specifiy whether to sample variable v.
% If the first element of the cell is 2, the variable will be sampled as
%  normal.
% If it is 0 or 1, then the second element of the cell is used.
% If shortcut is passed and non-zero then x, deaths, and adherences are 
%  not sampled.
%
% The censoring distribution is also sampled, from the same type
%  of distribution as any other mode of death, except p is fixed to the
%  parameter lost_rate, the probability of being censored, while
%  the other parameters are drawn from their respective priors.
%
% adherence_indices contains the numbers corresponding to the modes
%  death. If zero, the death time was censored. If it is -1, the death
%  time was infinite (this will only happen with synthetic data).

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.4          11:oct:19    rfs34    Important bug fixed.
%     1.7          12:oct:19    rfs34    shortcut option added.
%     1.14         14:oct:19    rfs34    Dimension mismatches fixed.
%     1.15         14:oct:19    rfs34    Several trivial bugs fixed.
%     1.20         16:oct:19    rfs34    Changed convention on whether or not to cheat,
%                                        and added adh_sam and x_sam to the control list.
%     1.21         16:oct:19    rfs34    Trivial typo fixed.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.generate_params_and_data.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

if nargin < 9,
   shortcut = [];
end
if nargin < 10,
   adh_sam = {};
end
if nargin < 11,
   x_sam = {};
end
obsunknown = nargin < 12;

if isempty(shortcut),
   shortcut = 0;
end
if isempty(adh_sam),
   adh_sam = {2};
end
if isempty(x_sam),
   x_sam = {2};
end

[a_J, a_p, b_p, a_m, b_m, a_r, b_r, a_k, b_k, c_k, l_k] = priorcoords{:};

if j_sam{1} == 2,
    J = geornd(a_J)+1;
else
    J = j_sam{2};
end

% Note that in addition to the J modes that will be generated, an additional "mode"
% will be added at position J+1 that controls the censoring time (a nice way of doing it).

if p_sam{1} == 2,
    p = betarnd(a_p, b_p, [1 J]);
    p = horzcat(p, lost_rate);
else
    if j_sam{1} == 2,
       error('Makes no sense to fix parameters without fixing J');
    end
    p = p_sam{2};
    p = horzcat(p, lost_rate);
end

if r_sam{1} == 2,
    r = gamrnd(a_r,b_r, [1 J+1]);
else
    if j_sam{1} == 2,
       error('Makes no sense to fix parameters without fixing J');
    end
    r = r_sam{2};
    r = horzcat(r, gamrnd(a_r, b_r));
end

if m_sam{1} == 2,
    logf = @(x) log_m_density(x,a_m,b_m);
    gradlogf = @(x) log_m_derivative(x, a_m, b_m);
    m = zeros([1 J+1]);
    points = [b_m/(2*a_m), b_m/a_m];
    for i = 1:J+1
        m(i) = ars(logf, gradlogf,points,0,Inf);
    end
else
    if j_sam{1} == 2,
       error('Makes no sense to fix parameters without fixing J');
    end
    m = m_sam{2};
    logf = @(x) log_m_density(x,a_m,b_m);
    gradlogf = @(x) log_m_derivative(x, a_m, b_m);
    points = [b_m/(2*a_m), b_m/a_m];
    m = horzcat(m, ars(logf, gradlogf, points, 0, Inf));
end

if k_sam{1} == 2,
    k = k_prior_sample(J+1, a_k, b_k, c_k, l_k, 10);
else
    if j_sam{1} == 2,
       error('Makes no sense to fix parameters without fixing J');
    end
    k = k_sam{2};
    k = horzcat(k, k_prior_sample(1, a_k, b_k, c_k, l_k, 10));
end

if ~shortcut,

   if adh_sam{1} < 2,
      if j_sam{1} == 2,
         error('Makes no sense to fix parameters without fixing J');
      end
      adherence_indices = adh_sam{2};

      if x_sam{1} < 2,
         x = x_sam{2};
      else

         % First sample the adherent xs, hence deaths, unless already known.
         if obsunknown,
            deaths = NaN(N, 1);
            for n = 1 : N,
               thisadh = adherence_indices(n);
               if thisadh >= 0,
                  if thisadh == 0,
                     thisadh = J + 1;
                  end
                  thism = m(thisadh);
                  thisr = r(thisadh);
                  thisk = k(thisadh);
                  thisp = p(thisadh);
                  thisq = gamrnd(thism, 1 ./ (thism .* thisr .^ thisk));
                  thisx = thisq .^ (1 ./ thisk);
                  thisu = rand;
                  if thisu > thisp,
                     thisx = Inf;
                  end
                  x(n, thisadh) = thisx;
                  deaths(n) = thisx;
               else % i.e. if thisadh == -1
                  deaths(n) = Inf;
               end % if thisadh > 0 or not
            end % for n = 1 : N
         end % if obsunknown or not

         % Then sample the non-adherent xs, constraining them to be bigger than deaths.
         for n = 1 : N,
            for j = 1 : J,
               if adherence_indices(n) == -1,
                  x(n, j) = Inf;
               elseif j ~= adherence_indices(n),
                  thism = m(j);
                  thisr = r(j);
                  thisk = k(j);
                  thisp = p(j);
                  thisu = rand;
                  if thisu <= thisp,
                     if k(j) > 0,
                        thisq = truncated_gamma(thism, thisr, deaths(n) .^ thisk, 1);
                     else
                        thisq = truncated_gamma(thism, thisr, deaths(n) .^ thisk, 0);
                     end
                     x(n, j) = thisq .^ (1 ./ thisk);
                  else
                     x(n, j) = Inf;
                  end
               end % various values of thisadh
            end % for j = 1 : J
         end % for n = 1 : N

      end % if cheating on x or not   

   else % i.e. if sampling adherences
      if obsunknown,
         if x_sam{1} == 2,
            q = gamrnd(repmat(m, N, 1), 1./(repmat(m.*(r.^k), N, 1)));
         
            x = q .^ (1. ./ k(ones([N, 1]), :));
            u = rand(N,J+1);
            x(u > p(ones(N, 1), :)) = Inf;
         else
            warning('When not sampling x you are not really sampling adherences');
            x = x_sam{2};
         end
      
         [deaths,adherence_indices] = min(x,[],2);

      else % i.e. if we know deaths and censored info

         if x_sam{1} == 2,

            x = NaN(N, J); 
            adherence_indices = double(~censored);
            adherence_indices(isinf(deaths)) = -1;
            y = adherence_sample(J, p, m, r, k, x, deaths, adherence_indices);
            [x, adherence_indices] = y{:};

         else
           warning('When not sampling x you are not really sampling adherences');
         end

      end % whether or not obsunknown
   end % if cheating on adherences or not

   adherence_indices(adherence_indices == J+1) = 0;
   adherence_indices(deaths == Inf) = -1;

end % if ~shortcut or not

p = p(1:J);
m = m(1:J);
r = r(1:J);
k = k(1:J);
       
if shortcut,
   y = {J,p,m,r,k};
else
   x = x(:,1:J);
   y = {J,p,m,r,k, adherence_indices, x, deaths};
end

end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
