function y = log_k_derivative(k,a, b, c, l)
% Usage: y = log_k_derivative(k,a, b, c, l)
% Returns the gradient of the log density returned by
%  log_k_density.
% Note that zero entries in b (and the corresponding entries in c)
%  are ignored (they are used to flag entries corresponding to
%  infinite death times).

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.log_k_derivative.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

    b = reshape(cell2mat(b), [l 1]);
    c = reshape(cell2mat(c), [l 1]);

    M = size(k);
    M = M(2);

    kl = repmat(k, l, 1);
    b = repmat(b, 1, M);
    c = repmat(c, 1, M);
    
    dd = log(b).*(b.^kl);
    dd(b==0) = 0;
    ee = c.*log(b);
    ee(b==0) = 0;
    
    y = (a./k) -sum(c.*dd, 1) +sum(ee, 1);
end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
