function y = log_proposal_r_density(r, a, r_r)
% Usage: y = log_proposal_r_density(r, a, r_r)
% Returns the unnormalised log prior density for r, 
%  a standard Gamma density with parameters a and r_r.
% (As far as RFS can see, this duplicates log_r_prior.m .)

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.5          11:oct:19    rfs34    Horrible bug fixed, and third parameter (which induces
%                                        another horrible bug) removed.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.log_proposal_r_density.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

y = ((a - 1).*log(r)) - (r_r.*r);

end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
