function piecewise_exponential_test;
% Usage: piecewise_exponential_test;
% Runs three standard tests of random sampling from the 
%  piecewise exponential distribution.

% Change Log:
%
%     1.2          10:oct:19    jc2062   As first received from jc2062.
%     1.5          11:oct:19    rfs34    Action point added.
%     1.6          11:oct:19    rfs34    Made into a function.
%     1.12         14:oct:19    rfs34    Plots annotated and comparisons added.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.piecewise_exponential_test.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

Nsamples = 10000;

% Testing code for the piecewise_exponential function.

deltax = 0.01;
points = [0.5, 1.5]
vals = [0, 1]
grads = [0, 0]
bounds = [0 1 2]
xx = [bounds(1) : deltax : bounds(end)];

l = zeros([1, Nsamples]);
for i = 1:Nsamples
    a = piecewise_exponential(points, vals, grads, bounds);
    l(i) = a(1);
end

figure;
densityvhist(xx, piecewise_exponential_density(xx, points, vals, grads, bounds), l);
xlabel('x');
ylabel('Scaled P(x) or bin count');
title('Comparison of piecewise exponential density and samples');

pause;

points = [-1, 1]
vals = [-0.5, -0.5]
grads = [1,-1]
bounds = [-Inf, 0, Inf]
xx = [-10 : deltax : 10];

l = zeros([1, Nsamples]);
for i = 1:Nsamples
    a = piecewise_exponential(points, vals, grads, bounds);
    l(i) = a(1);
end

densityvhist(xx, piecewise_exponential_density(xx, points, vals, grads, bounds), l);
xlabel('x');
ylabel('Scaled P(x) or bin count');
title('Comparison of piecewise exponential density and samples');

pause;

points = [-1 0 1]
vals = [-1 3 -1]
grads = [1 0 -1]
bounds = [-Inf -0.5 0.5 Inf]
xx = [-10 : deltax : 10];

l = zeros([1, Nsamples]);
for i = 1:Nsamples
    a = piecewise_exponential(points, vals, grads, bounds);
    l(i) = a(1);
end

densityvhist(xx, piecewise_exponential_density(xx, points, vals, grads, bounds), l);
xlabel('x');
ylabel('Scaled P(x) or bin count');
title('Comparison of piecewise exponential density and samples');




% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
