function plot_adh_trajectories(savesetid, savedir, npatient);
% Usage: plot_adh_trajectories(savesetid, savedir, npatient);
% This function is only used for debugging; 
%  it plots the adherence trajectories as sampling proceeds,
%  from a record of all the samples collected, and compares
%  it with the truth if that is available (i.e. if the run
%  of MAIN giving rise to the saveset was a synthetic run).

% Change Log:
%
%     1.1          16:oct:19    rfs      First version.
%     1.22         16:oct:19    rfs      Version number harmonisation.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.plot_adh_trajectories.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

if nargin < 2,
   savedir = '';
end
if nargin < 3,
   npatient = [];
end

if isempty(savedir),
   savedir = '.';
end
if isempty(npatient),
   npatient = 1;
end

ch = get(0, 'Children');
if isempty(ch),
   nfigfirst = 1;
else
   nfigfirst = max(ch) + 1;
end

nfig = nfigfirst;

load(sprintf('%s/save.%s.mat', savedir, savesetid), 'postsamples', 'truesample');

Npostsamples = length(postsamples);
nn = [1 : Npostsamples].';

npatient = npatient - 1;
Npatients = length(truesample.adh);

postadhs = NaN(Npatients, Npostsamples);
postadhs = cat(2, postsamples(nn).adh);

while npatient < Npatients,
   npatient = npatient + 1;

   figure(nfig);
   clf;
   plot(nn, postadhs(npatient, :), '.-', ...
        nn([1, end]), repmat(truesample.adh(npatient), [1, 2]), 'gx-');
   xlabel('Sample number');
   ylabel('Adherence');
   title(sprintf('Adherence trajectory for patient %d', npatient));

   pause;

end % while npatient < Npatients

return;


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



