function plot_x_trajectories(savesetid, savedir, npatient);
% Usage: plot_x_trajectories(savesetid, savedir, npatient);
% This function plots the trajectories of the various 
%  seen or unseen x values corresponding to hypothetical
%  times of death under the various modes.

% Change Log:
%
%     1.1          16:oct:19    rfs      First version.
%     1.22         17:oct:19    rfs      Version number harmonisation.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.plot_x_trajectories.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

if nargin < 2,
   savedir = '';
end
if nargin < 3,
   npatient = [];
end

if isempty(savedir),
   savedir = '.';
end
if isempty(npatient),
   npatient = 1;
end

ch = get(0, 'Children');
if isempty(ch),
   nfigfirst = 1;
else
   nfigfirst = max(ch) + 1;
end

nfig = nfigfirst;

cols = repmat('rgbcmyk', [1, 2]);

load(sprintf('%s/save.%s.mat', savedir, savesetid), 'postsamples', 'truesample');

Npostsamples = length(postsamples);
nn = [1 : Npostsamples].';

npatient = npatient - 1;
Npatients = length(truesample.adh);

Js = cell(length(postsamples), 1);
[Js{:}] = postsamples.J;
Js = cat(1, Js{:});
Jmax = max([Js; truesample.J]);

postxs = NaN([Npatients, Jmax, Npostsamples]);

for npostsample = 1 : Npostsamples,
   J = Js(npostsample);
   postxs(:, 1 : J, npostsample) = postsamples(npostsample).x;
end

while npatient < Npatients,
   npatient = npatient + 1;

   figure(nfig);
   clf;
   hold on;
   for j = 1 : Jmax,
      plot(nn, squeeze(postxs(npatient, j, :)), [cols(j), '-']);
   end
   for j = 1 : truesample.J,
      plot(nn([1, end]), repmat(truesample.x(npatient, j), [1, 2]), [cols(j), 'x:']);
   end
   hold off;
   xlabel('Sample number');
   ylabel('x');
   title(sprintf('x trajectories for patient %d', npatient));

   pause;

end % while npatient < Npatients

return;


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



