function plotcurves(m, r, k, p, rl, xx);
% Usage: plotcurves(m, r, k, p, rl, xx);
% Plots the lifetime distribution and hazard rates corresponding
%  to particular parameter values.
% rl is the right limit in time to plot.
% xx is a uniform grid of x values.

% Change Log:
%
%     1.1          30:oct:19    rfs      First version.
%     1.44         30:oct:19    rfs      Version number harmonisation.
%     1.45         30:oct:19    rfs      Added survival curve.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.plotcurves.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

if nargin < 5,
   rl = [];
end
if nargin < 6,
   xx = [];
end

if isempty(rl),
   rl = 400;
end
if isempty(xx),
   xx = [0.1 : 0.1 : rl].';
end

logPy = (m .* log(m .* r .^ k) - gammaln(m) + log(abs(k))) + (k .* m - 1) .* log(xx) - (xx .* r) .^ k .* m;

if k > 0,
   Cy = (1-p) + p .* gammainc(m .* (xx .* r) .^ k, m, 'upper');
else
   Cy = (1-p) + p .* gammainc(m .* (xx .* r) .^ k, m, 'lower');
end

haz = [NaN; - diff(log(Cy))] / (xx(2) - xx(1));

figure(1);
plot(xx, Cy, 'b');
xlabel('Time t (days)');
ylabel('Probability(lifetime < t)');
title(sprintf('Survival probability against time for p=%g,m=%g,r=%g,k=%g', p, m, r, k));
xaxis(0, rl);
ax = axis;
ax(3 : 4) = [-0.01, 1.01];
axis(ax);

figure(2);
plot(xx, p .* exp(logPy), 'b');
xlabel('Time (days)');
ylabel('Probability density of lifetime (days ^ {-1})');
title(sprintf('Probability density of lifetime for p=%g,m=%g,r=%g,k=%g', p, m, r, k));
xaxis(0, rl);

figure(3);
plot(xx, haz, 'b');
xlabel('Time (days)');
ylabel('Hazard rate (days^{-1})')
title(sprintf('Hazard rate for p=%g,m=%g,r=%g,k=%g', p, m, r, k));
xaxis(0, rl);
ax = axis;
ax(3) = 0;
axis(ax);

return;


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



