function plotting;
% Usage: plotting;
% Plos some of the prior distributions on the simple parameters.

% Change Log:
%
%     1.2          10:oct:19    jc2062   As first received from jc2062.
%     1.5          11:oct:19    rfs34    Priors adjusted to match MAIN.m, third parameter 
%                                        removed from density on r, and fourth subplot added 
%                                        as a temporarily measure.
%     1.12         14:oct:19    rfs34    Plots given titles etc.
%     1.13         14:oct:19    rfs34    Now uses setpriorcoords.m .
%     1.43         23:oct:19    rfs34    Comments only changed.
%     1.56         13:dec:19    rfs34    Plotting of prior on p made finer-grained, 
%                                        and normalisation factors added.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.plotting.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

% Set up the parameters of the priors.
priorcoords = setpriorcoords;
[a_J, a_p, b_p, a_m, b_m, m_r, b_r, a_k, b_k, c_k, l_k] = priorcoords{:};
r_r = 1 / b_r;

% Plotting prior on k

figure(1);

xx = -10:0.01:10;
yy = exp(log_k_density(xx, a_k, b_k, c_k, l_k, 0));
sumyy = 0.01 * sum(yy);
yy = yy / sumyy;
plot(xx, yy);
xlabel('k');
ylabel('P(k)');
title('Prior on k');

% Plotting prior on m

figure(2);

xx = 0:0.01:10;
yy = exp(log_m_density(xx, a_m, b_m));
sumyy = 0.01 * sum(yy(~isnan(yy)));
yy = yy / sumyy;
plot(xx, yy);
xlabel('m');
ylabel('P(m)');
title('Prior on m');

% Plotting prior on p

figure(3);

xx = 0:0.01:1;
plot(xx, exp(log_p_density(xx, a_p, b_p)) * (gamma(a_p + b_p) / (gamma(a_p) * gamma(b_p))));
ax = axis;
ax(3) = 0;
axis(ax);
xlabel('p');
ylabel('P(p)');
title('Prior on p');

% Plotting density on r

figure(4);

xx = 0:0.001:0.1;
plot(xx, exp(log_proposal_r_density(xx, m_r, r_r)) .* (r_r .^ m_r ./ gamma(m_r)));
xlabel('r (days^{-1})');
ylabel('P(r) (days)');
title('Prior on r');


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
