function sequence(nfig, nstartsample, numimmune);
% Usage: sequence(nfig, nstartsample, numimmune);
% This function takes a figure in which a number of lines are plotted
%  in a single axis, and, keeping the nimmune most recently plotted 
%  always visible, makes the remainder visible in sequence
%  starting with the nstartsample from oldest.
% numimmune defaults to 1 unless the most recently plotted
%  line is black, in which case it defaults to 2.
% Press any key to move on to next frame.

% Change Log:
%
%     1.1          15:oct:19    rfs      First version.
%     1.17         15:oct:19    rfs      Version number harmonisation.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.sequence.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

if nargin < 2,
   nstartsample = [];
end
if nargin < 3,
   numimmune = [];
end

if isempty(nstartsample),
   nstartsample = 1;
end

figure(nfig);
axi = gca;

ch = get(axi, 'Children');

if isempty(numimmune),
   numimmune = 1 + all(get(ch(1), 'Color') == 0);
end

Nch = length(ch);

for nch = 1 + numimmune : Nch,
   set(ch(nch), 'Visible', 'off');
end

for nch = Nch - nstartsample + 1 : -1 : 1 + numimmune
   if nch < Nch,
      set(ch(nch + 1), 'Visible', 'off');
   end
   set(ch(nch), 'Visible', 'on');
   pause;
end

return;


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



