function priorcoords = setpriorcoords;
% Usage: priorcoords = setpriorcoords;
% Returns priorcoords as a cell array containing 
%  {a_J, a_p, b_p, a_m, b_m, m_r, b_r, a_k, b_k, c_k, l_k}
%  having first checked that the parameter values are reasonable.

% Change Log:
%
%     1.1          14:oct:19    rfs34    First version.
%     1.13         14:oct:19    rfs34    Version number harmonisation.
%     1.19         15:oct:19    rfs34    Switched to more gingernut-like priors.
%     1.24         17:oct:19    rfs34    Switched back to intended priors.
%     1.38         21:oct:19    rfs34    Reduced timescale of priors by a factor of 3.
%     1.43         23:oct:19    rfs34    Comments only changed.
%     1.46         04:nov:19    rfs34    Changed to prior mutually agreed at meeting on 4/11/2019.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.setpriorcoords.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

% Declare prior constants. Letter after the underscore specifies which
% prior the constant is needed for.
%
% The forms of the priors are specified at the start of the corresponding
% sampling routine.

if 1,
   % This is the set of priors agreed at the meeting
   % between rfs34, lr404, gmmtroll, and lw538 on 4/11/2019.
   a_J = 0.2; % NB P(J) = a_J * (1 - a_J) ^ J.
   a_p = 0.5;
   b_p = 0.5;
   a_m = 1;
   b_m = 1;
   m_r = 0.5; 
   r_r = 30; % days 
   b_r = 1 / r_r;
   a_k = 1;
   b_k = {0.2, 0.2};
   c_k = {0.5, 0.5};
   l_k = 2;
elseif 0,
   % These are the priors RFS suggested after realising that 
   %  his first suggestion gave too long a timescale..
   a_J = 0.2; % NB P(J) = a_J * (1 - a_J) ^ J.
   a_p = 1; % RFS here suggesting a flat prior on p.
   b_p = 1;
   a_m = 1;
   b_m = 1;
   m_r = 0.5; 
   r_r = 30; % days % RFS: setting r_r to 2 days and m_r to 2 would give a timescale
                    %      of just 1 day, too short in my view.
   b_r = 1 / r_r;
   a_k = 2;
   b_k = {1 2};
   c_k = {1 2};
   l_k = 2;
elseif 0,
   % This is a more gingernut-like set, capable of envisaging sudden bursts of late deaths.
   a_J = 0.3; % NB P(J) = a_J * (1 - a_J) ^ J.
   a_p = 0.5;
   b_p = 0.5;
   a_m = 0.5;
   b_m = 1e-4;
   m_r = 0.5; 
   r_r = 100; % days % RFS: setting r_r to 2 days and m_r to 2 would give a timescale
                     %      of just 1 day, too short in my view.
   b_r = 1 / r_r;
   a_k = 2;
   b_k = {0.4, 0.5};
   c_k = {0.5, 0.5};
   l_k = 2;
end

% Constraints on prior parameters.
% RFS: I feel that violating these makes it not worth continuing, 
%      hence errors rather than warnings.

% 0 < a_J < 1

if or(a_J <= 0, a_J >= 1)
    error('a_J not in (0,1)');
end

% a_p, b_p > 0

if or(a_p <= 0, b_p <= 0)
    error('p parameters not > 0');
end

% a_m ,b _m > 0

if or(a_m <= 0, b_m <= 0)
    error('m parameters not > 0; b can in principle be in (-1,0] but that would need code modifications due to non-log-concavity');
end

% RFS: m_r > 1 shouldn't be needed (and only was due to another bug).
% m_r > 0

if m_r <= 0
   error('m_r not > 0');
end

% r_r > 0

if r_r <= 0
    error('r_r not > 0');
end

% b_k, c_k all positive and same length

if ~isempty(find(cell2mat(b_k) <= 0))
    error('Not all b_k parameters are positive');
end

if ~isempty(find(cell2mat(c_k) <= 0))
    error('Not all c_k parameters are positive');
end

if length(cell2mat(b_k)) ~= length(cell2mat(c_k))
    error('b_k and c_k not of the same length');
end

if length(cell2mat(b_k)) ~= l_k
    error('l_k not set correctly');
end

% RFS: Note passing b_r not r_r, as that is what is expected 
%      by recipients.
priorcoords = {a_J, a_p, b_p, a_m, b_m, m_r, b_r, a_k, b_k, c_k, l_k};

return;


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
