function truncated_gamma_test(m, r, a, uppernotlower);
% Usage: truncated_gamma_test(m, r, a, uppernotlower);
% Does a standard test of sampling from the truncated Gamma distribution
%  whose parameters are m, r, and a; if uppernotlower is 1
%  then sampling is from the range (a, Inf) and otherwise it 
%  is from (0, a).

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.5          11:oct:19    rfs34    Action points added.
%     1.12         14:oct:19    rfs34    Actions done.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.truncated_gamma_test.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

Nsamples = 10000;

if uppernotlower,
   xx = 0.001 : 0.001 : 15 * a;
else
   xx = 0.001: 0.001 : 3 * a;
end

if uppernotlower,
   yy = (1/gamcdf(1,m,1/r,'upper'))*250*gampdf(xx, m, 1/r);
   yy(xx < a) = 0;
else
   yy = (1/gamcdf(1,m,1/r,'lower'))*250*gampdf(xx, m, 1/r);
   yy(xx > a) = 0;
end

l = NaN(1, Nsamples);
for j = 1 : Nsamples,
    l(j) = truncated_gamma(m,r,a,uppernotlower);
end

densityvhist(xx, yy, l);
xlabel('m');
ylabel('Scaled P(m) or bin count');
title('Comparison of scaled density and bin count for truncated \Gamma distribution');

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
