function y = x_sample(J, p, m, r, k, x, deaths, adherences)
% Usage: y = x_sample(J, p, m, r, k, x, deaths, adherences)
% Resamples x from the posterior given the other parameters. 

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As  received from jc2062.
%     1.5          11:oct:19    rfs34    Action point added.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.x_sample.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

    % RFS: Action needed to replace iterators and limits with more sensible names.
    M = size(x);
    M = M(1);
    q = zeros(size(x));
    for j = 1:J
        nm = m(j); nr = r(j); nk = k(j); np = p(j);
        for i = 1:M
            if nk > 0
    
                if or(deaths(i) == Inf, general_discrete([np*gamcdf(deaths(i).^nk, nm,1./(nm.*(nr.^nk)), 'upper'), 1 - np]) == 2)
                    q(i,j) = Inf;
                else
                    q(i,j) = (truncated_gamma(nm,nm*(nr^nk),deaths(i).^nk,1)).^(1./nk);
                end
            end
            if nk < 0
                if or(deaths(i) == Inf, general_discrete([np*gamcdf(deaths(i).^nk, nm,1./(nm.*(nr.^nk))), 1 - np]) == 2)
                    q(i,j) = Inf;
                else
                    q(i,j) = (truncated_gamma(nm,nm*(nr^nk),deaths(i).^nk,0)).^(1./nk);
                end
            end
        end
    end
    for i = 1:M
        if adherences(i) > 0
            q(i,adherences(i)) = deaths(i);
        end
    end
    y = q;

end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
