function ars_test(knotm);
% Usage: ars_test(knotm);
% ARS test: checking histograms for m_density and k_density (both branches
% separately). Set knotm to 1 for the k version and 0 for the m version.

% Change Log:
%
%     1.2          10:oct:19    jc2062   As first received from jc2062.
%     1.4          11:oct:19    rfs34    Made a function with a parameter to switch
%                                        between two distributions.
%     1.10         12:oct:19    rfs34    Actions complete.
%     1.12         14:oct:19    rfs34    Titles and axis labels added.
%     1.14         14:oct:19    rfs34    Now uses setpriorcoords.m .

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.ars_test.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

priorcoords = setpriorcoords;
[a_J, a_p, b_p, a_m, b_m, m_r, b_r, a_k, b_k, c_k, l_k] = priorcoords{:};
r_r = 1 / b_r;

if ~knotm,

   % Histogram of samples for m_density
   
   xx = 0.01:0.01:10;
   a = a_m;
   b = b_m;
   
   logf = @(x) log_m_density(x, a, b);
   gradlogf = @(x) log_m_derivative(x, a, b);
   points = [b/(5*a),b/(2*a), b/a];
   
   l = zeros([1, 10000]);
   for i = 1:10000
       l(i) = ars(logf, gradlogf, points, 0, Inf);
   end
   
   densityvhist(xx, exp(log_m_density(xx, a, b)), l);
   xlabel('m');
   ylabel('Scaled P(m) or bin count');
   title('Comparison of scaled density and histogram for prior on m');

else % i.e. if knotm

   % Histogram of samples for k_density
   
   xx = -6:0.1:4;
   a = a_k;
   b = b_k;
   c = c_k;

   logf = @(x) log_k_density(x, a, b, c, l_k, 0);
   gradlogf = @(x) log_k_derivative(x, a, b, c, l_k);
   
   p_points = [1,2];
   n_points = [-2, -1];
   
   while log_k_derivative(p_points(1), a, b, c, l_k) <= 0
       p_points = [p_points(1)/2, p_points];
   end
   while log_k_derivative(p_points(end), a, b, c, l_k) >= 0
       p_points = [p_points, 2*p_points(end)];
   end
   
   while log_k_derivative(n_points(1), a, b, c, l_k) <= 0
       n_points = [n_points(1)*2, n_points];
   end
   while log_k_derivative(n_points(end), a, b, c, l_k) >= 0
       n_points = [n_points, 0.5*n_points(end)];
   end
   
   points = [n_points, p_points];

   l = zeros([1 10000]);
   thisl = 1;
   for i = 1:10000
       u = rand;
       logdenshere = log_k_density(thisl, a, b, c, l_k, 0);
       logdensthere = log_k_density(-thisl, a, b, c, l_k, 0);
       if u < exp(logdensthere - logdenshere),
          thisl = - thisl;
       end
       if thisl > 0
          l(i) = ars(logf, gradlogf, p_points, 0, Inf);
       else
          l(i) = ars(logf, gradlogf, n_points, -Inf, 0);
       end
       thisl = l(i);
   end
   
   densityvhist(xx, exp(log_k_density(xx, a, b, c, l_k, 0)), l);
   xlabel('k');
   ylabel('Scaled P(k) or bin count');
   title('Comparison of scaled density and histogram for prior on k');

end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
