function y = k_prior_sample(J, a_k, b_k, c_k, l, no)
% Usage: y = k_prior_sample(J, a_k, b_k, c_k, l, no)
% Samples k for the various modes given the other parameters. 
% Uses MCMC, alternating resampling the sign of k with its
%  absolute value. 
% no gives the number of iterations of MCMC to use.

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.14         14:oct:19    rfs34    Trivial bugs fixed.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.k_prior_sample.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

b_k = reshape(cell2mat(b_k), [l 1]);
c_k = reshape(cell2mat(c_k), [l 1]);

b_k = repmat(b_k, 1, J);
c_k = repmat(c_k, 1, J);

a = repmat(a_k, 1, J);
b = num2cell(b_k,1);
c = num2cell(c_k,1);

for i = 1:J
    a_k = a(i);
    b_k = b(i);
    c_k = c(i);
    
    logf = @(x) log_k_density(x, a_k, b_k, c_k, l, 0);
    gradlogf = @(x) log_k_derivative(x, a_k, b_k, c_k, l);
    
    % Come up with some suitable points to initiate ARS with
    % (see ars.m).

    p_points = [1,2];
    n_points = [-2, -1];
    
    while log_k_derivative(p_points(1), a_k, b_k, c_k, l) <= 0
        p_points = [p_points(1)/2, p_points];
    end
    while log_k_derivative(p_points(end), a_k, b_k, c_k, l) >= 0
        p_points = [p_points, 2*p_points(end)];
    end
    
    while log_k_derivative(n_points(1), a_k, b_k, c_k, l) <= 0
        n_points = [n_points(1)*2, n_points];
    end
    while log_k_derivative(n_points(end), a_k, b_k, c_k, l) >= 0
        n_points = [n_points, 0.5*n_points(end)];
    end
    
    k = 2*rand - 1;

    % Do MCMC.
    for j = 1:no

        % First resample sign(k).
        logchoice = [logf(-abs(k)), logf(abs(k))];
        maxchoice = max(logchoice);
        if maxchoice == -Inf,
           warning('All possibilities zero going in to general_discrete');
        end
        if maxchoice == Inf,
           error('Some possibility has infinite probability going in to general_discrete');
        end
        logchoice = logchoice - maxchoice;
        z = general_discrete(exp(logchoice));

        % Then resample abs(k).
        if z == 1
            k = ars(logf, gradlogf, n_points, -Inf, 0);
        else
            k = ars(logf, gradlogf, p_points, 0, Inf);
        end
    end
    y(i) = k;
end
end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
