function y = k_sample(J, m, r, k, x, priorcoords)
% Usage: y = k_sample(J, m, r, k, x, priorcoords)
% Prior for k of the form:
%  P(scalar k) proportional to 
%   abs(k) .^ a .* prod(b .^ (c .* k) .* exp(- b .* c))
%  for positive scalar integer a, and vectors b and c 
%  of positive reals of the same length as each other.
% This function samples from the posterior given the 
%  various input parameters.

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.21         16:oct:19    rfs34    Fixed nasty bug due to underflow.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.k_sample.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

l = priorcoords{end};
c_k = priorcoords{end-1};
b_k = priorcoords{end-2};
a_k = priorcoords{end-3};

b_k = reshape(cell2mat(b_k), [l 1]);
c_k = reshape(cell2mat(c_k), [l 1]);

b_k = repmat(b_k, 1, J);
c_k = repmat(c_k, 1, J);

M = size(x);
M = M(1);

N = sum(x ~= Inf, 1);

% Infinite x get treated as if they are not part of the input,
%  as they come from the (1-p) option.

y1 = x;
y1(x == Inf) = 0;

a = a_k + N;

X1 = y1 .* repmat(r, M, 1);

b = [b_k;X1];

c = [c_k; repmat(m, M, 1)];

l = size(c, 1);

b = num2cell(b,1);
c = num2cell(c,1);

for i = 1:J
    a_k = a(i);
    b_k = b(i);
    c_k = c(i);
    
    logf = @(x) log_k_density(x, a_k, b_k, c_k, l, 0);
    gradlogf = @(x) log_k_derivative(x, a_k, b_k, c_k, l);
    
    p_points = [1,2];
    n_points = [-2, -1];
    
    while log_k_derivative(p_points(1), a_k, b_k, c_k, l) <= 0
        p_points = [p_points(1)/2, p_points];
    end
    while log_k_derivative(p_points(end), a_k, b_k, c_k, l) >= 0
        p_points = [p_points, 2*p_points(end)];
    end
    
    while log_k_derivative(n_points(1), a_k, b_k, c_k, l) <= 0
        n_points = [n_points(1)*2, n_points];
    end
    while log_k_derivative(n_points(end), a_k, b_k, c_k, l) >= 0
        n_points = [n_points, 0.5*n_points(end)];
    end

    logchoice = [logf(-abs(k(i))), logf(abs(k(i)))];
    maxlogchoice = max(logchoice);
    if maxlogchoice == -Inf,
       warning('Discrete choice being asked for between 0 and 0 probabilities')
    elseif maxlogchoice == Inf,
       error('Infinite log probabilities encountered');
    end
    logchoice = logchoice - maxlogchoice;
    
    z = general_discrete(exp(logchoice));

    if z == 1
        k(i) = ars(logf, gradlogf, n_points, -Inf, 0);
    else
        k(i) = ars(logf, gradlogf, p_points, 0, Inf);
    end

end

y = k;

end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
