function plot_trajectories(savesetid, savedir, nfigfirst);
% Usage: plot_trajectories(savesetid, savedir, nfigfirst);
% Plots the trajectories of the parameters
%  J, p, m, r, k in the figures numbered from nfigfirst onwards.
% Purpose is debugging and as a check of convergence of the MCMC.

% Change Log:
%
%     1.1          14:oct:19    rfs      First version.
%     1.13         14:oct:19    rfs      Version number harmonisation.
%     1.15         14:oct:19    rfs      Numerous bugs fixed; now appears to be working.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.plot_trajectories.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

if nargin < 2,
   savedir = '';
end
if nargin < 3,
   nfigfirst = [];
end

if isempty(savedir),
   savedir = '.';
end
if isempty(nfigfirst),
   ch = get(0, 'Children');
   if isempty(ch),
      nfigfirst = 1;
   else
      nfigfirst = max(ch) + 1;
   end
end

nfig = nfigfirst - 1;

load(sprintf('%s/save.%s.mat', savedir, savesetid), 'postsamples', 'truesample');

Npostsamples = length(postsamples);
nn = [1 : Npostsamples].';

Js = cell(length(postsamples), 1);
[Js{:}] = postsamples.J;
Js = cat(1, Js{:});
Jmax = max([Js; truesample.J]);

cols = repmat('rgbcmyk', [1, ceil(Jmax / 7)]);

ps = NaN(Jmax, Npostsamples);
ms = NaN(Jmax, Npostsamples);
rs = NaN(Jmax, Npostsamples);
ks = NaN(Jmax, Npostsamples);

nfig = nfig + 1;
figure(nfig);
clf;
plot(nn, Js, 'b', nn([1, end]), repmat(truesample.J, [1, 2]), 'gx:');
xlabel('Sample number');
ylabel('J');
title('Trajectory of J parameter');
axis([nn(1), nn(end), -0.1, max([truesample.J, Jmax]) + 0.1]);

for npostsample = 1 : Npostsamples,
   J = Js(npostsample);
   ps(1 : J, npostsample) = postsamples(npostsample).p.';
   ms(1 : J, npostsample) = postsamples(npostsample).m.';
   rs(1 : J, npostsample) = postsamples(npostsample).r.';
   ks(1 : J, npostsample) = postsamples(npostsample).k.';
end

Jtrue = truesample.J;
pstrue = NaN(Jmax, 1);
mstrue = NaN(Jmax, 1);
rstrue = NaN(Jmax, 1);
kstrue = NaN(Jmax, 1);
pstrue(1 : Jtrue) = truesample.p;
mstrue(1 : Jtrue) = truesample.m;
rstrue(1 : Jtrue) = truesample.r;
kstrue(1 : Jtrue) = truesample.k;

nfig = nfig + 1;
figure(nfig);
clf;
hold on;
for j = 1 : Jmax,
   plot(nn, ps(j, :), cols(j));
   plot(nn([1; end]), repmat(pstrue(j), [2, 1]), [cols(j), 'x:']);
end
xlabel('Sample number');
ylabel('p');
title('Trajectory of p parameter');
axis([nn(1), nn(end), -0.01, 1.01]);

nfig = nfig + 1;
figure(nfig);
clf;
hold on;
for j = 1 : Jmax,
   plot(nn, ms(j, :), cols(j));
   plot(nn([1; end]), repmat(mstrue(j), [2, 1]), [cols(j), 'x:']);
end
xlabel('Sample number');
ylabel('m');
title('Trajectory of m parameter');

nfig = nfig + 1;
figure(nfig);
clf;
hold on;
for j = 1 : Jmax,
   plot(nn, rs(j, :), cols(j));
   plot(nn([1; end]), repmat(rstrue(j), [2, 1]), [cols(j), 'x:']);
end
xlabel('Sample number');
ylabel('r');
title('Trajectory of r parameter');

nfig = nfig + 1;
figure(nfig);
clf;
hold on;
for j = 1 : Jmax,
   plot(nn, ks(j, :), cols(j));
   plot(nn([1; end]), repmat(kstrue(j), [2, 1]), [cols(j), 'x:']);
end
xlabel('Sample number');
ylabel('k');
title('Trajectory of k parameter');

return;


% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:



