function y = probability_alive(t, J, p, m, r, k)
% Usage: y = probability_alive(t, J, p, m, r, k)
% Calculates the survival probability at time t under the
%  lifetime distribution specified by the other parameters.

% Change Log:
%
%     1.1          28:sep:19    jc2062   As first received from JC2062.
%     1.2          10:oct:19    jc2062   As received from jc2062.
%     1.43         23:oct:19    rfs34    Comments only changed.

mytitl = ' /home/rfs/ramakrishnan/software/survival/jc2062/SCCS/s.probability_alive.m 1.57 20/06/20 12:19:04 ';

persistent mytitldone
if isempty(mytitldone),           
   mytitldone = titlfunction(mytitl);
end

global titls

y = ones(size(t));
for i = 1:J

    if k(i) > 0
        y = y .* (1 - p(i) + p(i)*gamcdf(t.^k(i), m(i), 1/(m(i)*(r(i)^k(i))), 'upper'));
    else
        y = y .* (1 - p(i) + p(i)*gamcdf(t.^k(i), m(i), 1/(m(i)*(r(i)^k(i)))));
    end
end

end

% Local Variables: 
% indent-line-function: indent-relative
% eval: (auto-fill-mode 0)
% End:
